/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.crypto.Digest;
import com.koalii.kgsp.bc.crypto.digests.MD5Digest;
import com.koalii.kgsp.bc.crypto.digests.SHA1Digest;
import com.koalii.kgsp.bc.crypto.digests.SHA256Digest;
import com.koalii.kgsp.bc.crypto.digests.SHA384Digest;
import com.koalii.kgsp.bc.crypto.digests.SHA512Digest;
import com.koalii.kgsp.bc.crypto.digests.SM3Digest;

public class KcDigestUtil {
    public static Digest findDigest(String alg) {
        String s = alg.toLowerCase();
        if (s.equalsIgnoreCase("md5")) {
            return new MD5Digest();
        }
        if (s.equalsIgnoreCase("sha1")) {
            return new SHA1Digest();
        }
        if (s.equalsIgnoreCase("sha-1")) {
            return new SHA1Digest();
        }
        if (s.equalsIgnoreCase("sha256")) {
            return new SHA256Digest();
        }
        if (s.equalsIgnoreCase("sha384")) {
            return new SHA384Digest();
        }
        if (s.equalsIgnoreCase("sha512")) {
            return new SHA512Digest();
        }
        if (s.equalsIgnoreCase("sm3")) {
            return new SM3Digest();
        }
        return new SHA256Digest();
    }

    public static byte[] sha1(byte[] oriData) {
        return KcDigestUtil.sha1(oriData, 0, oriData.length);
    }

    public static byte[] sha1(byte[] oriData, int offset, int len) {
        return KcDigestUtil.digest(new SHA1Digest(), oriData, offset, len);
    }

    public static byte[] sha256(byte[] oriData) {
        return KcDigestUtil.sha256(oriData, 0, oriData.length);
    }

    public static byte[] sha256(byte[] oriData, int offset, int len) {
        return KcDigestUtil.digest(new SHA256Digest(), oriData, offset, len);
    }

    public static byte[] sha384(byte[] oriData) {
        return KcDigestUtil.sha384(oriData, 0, oriData.length);
    }

    public static byte[] sha384(byte[] oriData, int offset, int len) {
        return KcDigestUtil.digest(new SHA384Digest(), oriData, offset, len);
    }

    public static byte[] sha512(byte[] oriData) {
        return KcDigestUtil.sha512(oriData, 0, oriData.length);
    }

    public static byte[] sha512(byte[] oriData, int offset, int len) {
        return KcDigestUtil.digest(new SHA512Digest(), oriData, offset, len);
    }

    public static byte[] md5(byte[] oriData) {
        return KcDigestUtil.md5(oriData, 0, oriData.length);
    }

    public static byte[] md5(byte[] oriData, int offset, int len) {
        return KcDigestUtil.digest(new MD5Digest(), oriData, offset, len);
    }

    public static byte[] sm3(byte[] oriData) {
        return KcDigestUtil.sm3(oriData, 0, oriData.length);
    }

    public static byte[] sm3(byte[] oriData, int offset, int len) {
        return KcDigestUtil.digest(new SM3Digest(), oriData, offset, len);
    }

    public static byte[] digest(Digest d, byte[] oriData) {
        return KcDigestUtil.digest(d, oriData, 0, oriData.length);
    }

    public static byte[] digest(Digest d, byte[] oriData, int offset, int len) {
        d.update(oriData, offset, len);
        byte[] bout = new byte[d.getDigestSize()];
        d.doFinal(bout, 0);
        return bout;
    }
}

