/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.crypto.KeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.engines.DESEngine;
import com.koalii.kgsp.bc.crypto.generators.DESKeyGenerator;
import com.koalii.kgsp.bc.util.encoders.Hex;
import com.koalii.kgsp.core.crypto.KcBlockCipher;
import java.security.SecureRandom;

public class KcDES
extends KcBlockCipher {
    public KcDES() {
        super(new DESEngine());
    }

    public KcDES(String mode) {
        super(new DESEngine(), mode);
    }

    @Override
    public byte[] generateKey(byte[] seed) {
        SecureRandom sr = new SecureRandom();
        if (null != seed) {
            sr.setSeed(seed);
        }
        DESKeyGenerator keyGen = new DESKeyGenerator();
        keyGen.init(new KeyGenerationParameters(sr, 64));
        return keyGen.generateKey();
    }

    public static void main(String[] args) throws Exception {
        String s = "Hello,world!";
        KcDES des = new KcDES("ECB");
        byte[] key = des.generateKey();
        byte[] iv = des.generateIV();
        byte[] secData = des.encrypt(s.getBytes(), key);
        System.out.println(des.getAlgorithmName() + ":" + secData.length);
        System.out.println(Hex.toHexString(secData));
        byte[] oriData = des.decrypt(secData, key);
        System.out.println(new String(oriData));
        des.setAlgMode("CBC");
        secData = des.encrypt(s.getBytes(), key, iv);
        System.out.println(des.getAlgorithmName() + ":" + secData.length);
        System.out.println(Hex.toHexString(secData));
        oriData = des.decrypt(secData, key, iv);
        System.out.println(new String(oriData));
    }
}

