/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.core.crypto.KcBlockCipher;
import com.koalii.kgsp.core.crypto.KcCipherFactory;
import com.koalii.kgsp.core.crypto.KcSM4;
import com.koalii.kgsp.core.crypto.KcTripleDES;
import com.koalii.kgsp.core.exception.KcException;

public class KcBlockCipherFactory
implements KcCipherFactory {
    public static final String DES3_CBC = "3DES_CBC";
    public static final String DES3_ECB = "3DES_ECB";
    public static final String SM4_CBC = "SM4_CBC";
    public static final String SM4_ECB = "SM4_ECB";
    private static final String ECB = "ECB";
    private static final String CBC = "CBC";

    @Override
    public KcBlockCipher getCipher(String alg) throws KcException {
        KcBlockCipher result = null;
        if (SM4_ECB.equalsIgnoreCase(alg)) {
            result = new KcSM4(ECB);
        } else if (SM4_CBC.equalsIgnoreCase(alg)) {
            result = new KcSM4(CBC);
        } else if (DES3_ECB.equalsIgnoreCase(alg)) {
            result = new KcTripleDES(ECB);
        } else if (DES3_CBC.equalsIgnoreCase(alg)) {
            result = new KcTripleDES(CBC);
        } else {
            throw new KcException(100135, "create cipher: unknown algName - " + alg);
        }
        return result;
    }
}

