/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.crypto.BlockCipher;
import com.koalii.kgsp.bc.crypto.BufferedBlockCipher;
import com.koalii.kgsp.bc.crypto.CipherKeyGenerator;
import com.koalii.kgsp.bc.crypto.CipherParameters;
import com.koalii.kgsp.bc.crypto.KeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.modes.CBCBlockCipher;
import com.koalii.kgsp.bc.crypto.paddings.BlockCipherPadding;
import com.koalii.kgsp.bc.crypto.paddings.PKCS7Padding;
import com.koalii.kgsp.bc.crypto.params.KeyParameter;
import com.koalii.kgsp.bc.crypto.params.ParametersWithIV;
import com.koalii.kgsp.core.crypto.padding.KcPaddedBufferedBlockCipher;
import com.koalii.kgsp.core.crypto.padding.KcZeroBytePadding;
import com.koalii.kgsp.core.exception.KcException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.crypto.spec.IvParameterSpec;

public abstract class KcBlockCipher {
    public static final String PADDING_ZERO = "PADDING_ZERO";
    public static final String PADDING_PKCS7 = "PADDING_PKCS7";
    private BlockCipher engine;
    private String algName;
    private String algMode = "CBC";
    private String paddingMode = "PADDING_PKCS7";

    public String getAlgorithmName() {
        return this.algName;
    }

    public KcBlockCipher(BlockCipher engine) {
        this.engine = engine;
    }

    public KcBlockCipher(BlockCipher engine, String mode) {
        this.engine = engine;
        this.setAlgMode(mode);
    }

    public void setPaddingMode(String paddingMode) {
        this.paddingMode = paddingMode;
    }

    public String getPaddingMode() {
        return this.paddingMode;
    }

    private BlockCipherPadding getPadding() throws KcException {
        if (PADDING_PKCS7.equalsIgnoreCase(this.paddingMode)) {
            return new PKCS7Padding();
        }
        if (PADDING_ZERO.equalsIgnoreCase(this.paddingMode)) {
            return new KcZeroBytePadding();
        }
        throw new KcException(100137, "block cipher: get padding mode error - " + this.paddingMode);
    }

    public void setAlgMode(String mode) {
        if (mode.equalsIgnoreCase("ECB") || mode.equalsIgnoreCase("CBC")) {
            this.algMode = mode;
        }
    }

    public String getAlgMode() {
        return this.algMode;
    }

    public byte[] generateIV() {
        byte[] rand = new byte[this.engine.getBlockSize()];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(rand);
        IvParameterSpec iv = new IvParameterSpec(rand);
        return iv.getIV();
    }

    public byte[] generateKey() {
        return this.generateKey(null);
    }

    public abstract byte[] generateKey(byte[] var1);

    public byte[] generateKey(int keySize) {
        return this.generateKey(null, keySize);
    }

    public byte[] generateKey(byte[] seed, int keySize) {
        SecureRandom sr = new SecureRandom();
        if (null != seed) {
            sr.setSeed(seed);
        }
        CipherKeyGenerator keyGen = new CipherKeyGenerator();
        keyGen.init(new KeyGenerationParameters(sr, keySize));
        return keyGen.generateKey();
    }

    public byte[] encrypt(byte[] oriData, byte[] key) throws KcException {
        KeyParameter params = new KeyParameter(key);
        if (this.algMode.equalsIgnoreCase("ECB")) {
            return this.encryptWithECB(oriData, params);
        }
        throw new KcException(100135, "block cipher: encrypt alg mode error - " + this.algMode);
    }

    public byte[] encrypt(byte[] oriData, byte[] key, byte[] iv) throws KcException {
        KeyParameter p = new KeyParameter(key);
        ParametersWithIV params = new ParametersWithIV(p, iv);
        if (this.algMode.equalsIgnoreCase("CBC")) {
            return this.encryptWithCBC(oriData, params);
        }
        throw new KcException(100135, "block cipher: encrypt alg mode error - " + this.algMode);
    }

    public byte[] encrypt(byte[] oriData, CipherParameters params) throws KcException {
        if (this.algMode.equalsIgnoreCase("ECB")) {
            return this.encryptWithECB(oriData, params);
        }
        if (this.algMode.equalsIgnoreCase("CBC")) {
            return this.encryptWithCBC(oriData, params);
        }
        throw new KcException(100135, "block cipher: encrypt alg mode error - " + this.algMode);
    }

    protected byte[] encryptWithCBC(byte[] oriData, CipherParameters params) throws KcException {
        CBCBlockCipher cbc = new CBCBlockCipher(this.engine);
        BlockCipherPadding padding = this.getPadding();
        KcPaddedBufferedBlockCipher cipher = new KcPaddedBufferedBlockCipher(cbc, padding);
        cipher.init(true, params);
        return this.processCipherData(cipher, oriData);
    }

    protected byte[] encryptWithECB(byte[] oriData, CipherParameters params) throws KcException {
        BlockCipherPadding padding = this.getPadding();
        KcPaddedBufferedBlockCipher cipher = new KcPaddedBufferedBlockCipher(this.engine, padding);
        cipher.init(true, params);
        return this.processCipherData(cipher, oriData);
    }

    public byte[] decrypt(byte[] secData, byte[] key) throws KcException {
        KeyParameter params = new KeyParameter(key);
        if (this.algMode.equalsIgnoreCase("ECB")) {
            return this.decryptWithECB(secData, params);
        }
        throw new KcException(100135, "block cipher: decrypt alg mode error - " + this.algMode);
    }

    public byte[] decrypt(byte[] secData, byte[] key, byte[] iv) throws KcException {
        KeyParameter p = new KeyParameter(key);
        ParametersWithIV params = new ParametersWithIV(p, iv);
        if (this.algMode.equalsIgnoreCase("CBC")) {
            return this.decryptWithCBC(secData, params);
        }
        throw new KcException(100135, "block cipher: decrypt alg mode error - " + this.algMode);
    }

    public byte[] decrypt(byte[] secData, CipherParameters params) throws KcException {
        if (this.algMode.equalsIgnoreCase("ECB")) {
            return this.decryptWithECB(secData, params);
        }
        if (this.algMode.equalsIgnoreCase("CBC")) {
            return this.decryptWithCBC(secData, params);
        }
        throw new KcException(100135, "block cipher: decrypt alg mode error - " + this.algMode);
    }

    protected byte[] decryptWithCBC(byte[] secData, CipherParameters params) throws KcException {
        CBCBlockCipher cbc = new CBCBlockCipher(this.engine);
        BlockCipherPadding padding = this.getPadding();
        KcPaddedBufferedBlockCipher cipher = new KcPaddedBufferedBlockCipher(cbc, padding);
        cipher.init(false, params);
        return this.processCipherData(cipher, secData);
    }

    protected byte[] decryptWithECB(byte[] secData, CipherParameters params) throws KcException {
        BlockCipherPadding padding = this.getPadding();
        KcPaddedBufferedBlockCipher cipher = new KcPaddedBufferedBlockCipher(this.engine, padding);
        cipher.init(false, params);
        return this.processCipherData(cipher, secData);
    }

    protected byte[] processCipherData(BufferedBlockCipher cipher, byte[] inData) throws KcException {
        int outlen;
        int inlen;
        this.algName = cipher.getUnderlyingCipher().getAlgorithmName();
        int inBlockSize = cipher.getBlockSize() * 8;
        int outBlockSize = cipher.getOutputSize(inBlockSize);
        byte[] inblock = new byte[inBlockSize];
        byte[] outblock = new byte[outBlockSize];
        ByteArrayInputStream bin = new ByteArrayInputStream(inData);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((inlen = bin.read(inblock, 0, inBlockSize)) > 0) {
            outlen = cipher.processBytes(inblock, 0, inlen, outblock, 0);
            if (outlen <= 0) continue;
            bout.write(outblock, 0, outlen);
        }
        try {
            outlen = cipher.doFinal(outblock, 0);
        }
        catch (Exception e) {
            throw new KcException(100136, "block cipher: process cipher failed", e);
        }
        if (outlen > 0) {
            bout.write(outblock, 0, outlen);
        }
        return bout.toByteArray();
    }

    @Deprecated
    public void encrypt(InputStream fin, OutputStream fout, byte[] key) throws KcException {
        KeyParameter params = new KeyParameter(key);
        if (!this.algMode.equalsIgnoreCase("ECB")) {
            throw new KcException(100135, "block cipher: encrypt alg mode error - " + this.algMode);
        }
        this.encryptWithECB(fin, fout, params);
    }

    protected void encryptWithECB(InputStream fin, OutputStream fout, CipherParameters params) throws KcException {
        BlockCipherPadding padding = this.getPadding();
        KcPaddedBufferedBlockCipher cipher = new KcPaddedBufferedBlockCipher(this.engine, padding);
        cipher.init(true, params);
        this.processCipherData(cipher, fin, fout);
    }

    public void encrypt(InputStream fin, OutputStream fout, byte[] key, byte[] iv) throws KcException {
        KeyParameter params = new KeyParameter(key);
        if (this.algMode.equalsIgnoreCase("CBC")) {
            if (null == iv) {
                throw new KcException(100138, "block cipher: encrypt CBC error - iv null");
            }
            ParametersWithIV param = new ParametersWithIV(params, iv);
            this.encryptWithCBC(fin, fout, param);
        } else if (this.algMode.equalsIgnoreCase("ECB")) {
            this.encryptWithECB(fin, fout, params);
        } else {
            throw new KcException(100135, "block cipher: encrypt alg mode error - " + this.algMode);
        }
    }

    protected void encryptWithCBC(InputStream fin, OutputStream fout, CipherParameters params) throws KcException {
        CBCBlockCipher cbc = new CBCBlockCipher(this.engine);
        BlockCipherPadding padding = this.getPadding();
        KcPaddedBufferedBlockCipher cipher = new KcPaddedBufferedBlockCipher(cbc, padding);
        cipher.init(true, params);
        this.processCipherData(cipher, fin, fout);
    }

    public void decrypt(InputStream fin, OutputStream fout, byte[] key, byte[] iv) throws KcException {
        KeyParameter params = new KeyParameter(key);
        if (this.algMode.equalsIgnoreCase("CBC")) {
            if (null == iv) {
                throw new KcException(100138, "block cipher: decrypt CBC error - iv null");
            }
            ParametersWithIV param = new ParametersWithIV(params, iv);
            this.decryptWithCBC(fin, fout, param);
        } else if (this.algMode.equalsIgnoreCase("ECB")) {
            this.decryptWithECB(fin, fout, params);
        } else {
            throw new KcException(100135, "block cipher: decrypt alg mode error - " + this.algMode);
        }
    }

    protected void decryptWithCBC(InputStream fin, OutputStream fout, CipherParameters params) throws KcException {
        CBCBlockCipher cbc = new CBCBlockCipher(this.engine);
        BlockCipherPadding padding = this.getPadding();
        KcPaddedBufferedBlockCipher cipher = new KcPaddedBufferedBlockCipher(cbc, padding);
        cipher.init(false, params);
        this.processCipherData(cipher, fin, fout);
    }

    @Deprecated
    public void decrypt(InputStream fin, OutputStream fout, byte[] key) throws KcException {
        KeyParameter params = new KeyParameter(key);
        if (!this.algMode.equalsIgnoreCase("ECB")) {
            throw new KcException(100135, "block cipher: decrypt alg mode error - " + this.algMode);
        }
        this.decryptWithECB(fin, fout, params);
    }

    protected void decryptWithECB(InputStream fin, OutputStream fout, CipherParameters params) throws KcException {
        BlockCipherPadding padding = this.getPadding();
        KcPaddedBufferedBlockCipher cipher = new KcPaddedBufferedBlockCipher(this.engine, padding);
        cipher.init(false, params);
        this.processCipherData(cipher, fin, fout);
    }

    protected void processCipherData(BufferedBlockCipher cipher, InputStream fin, OutputStream fout) throws KcException {
        this.algName = cipher.getUnderlyingCipher().getAlgorithmName();
        int inBlockSize = cipher.getBlockSize() * 8;
        int outBlockSize = cipher.getOutputSize(inBlockSize);
        byte[] inblock = new byte[inBlockSize];
        byte[] outblock = new byte[outBlockSize];
        try {
            int outlen;
            int inlen;
            while ((inlen = fin.read(inblock, 0, inBlockSize)) > 0) {
                outlen = cipher.processBytes(inblock, 0, inlen, outblock, 0);
                if (outlen <= 0) continue;
                fout.write(outblock, 0, outlen);
            }
            outlen = cipher.doFinal(outblock, 0);
            if (outlen > 0) {
                fout.write(outblock, 0, outlen);
            }
        }
        catch (Exception e) {
            throw new KcException(100136, "block cipher: process cipher failed", e);
        }
    }
}

