/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.crypto.engines.AESEngine;
import com.koalii.kgsp.bc.util.encoders.Hex;
import com.koalii.kgsp.core.crypto.KcBlockCipher;

public class KcAES
extends KcBlockCipher {
    public static final int AES_KEY_SIZE_128 = 128;
    public static final int AES_KEY_SIZE_192 = 192;
    public static final int AES_KEY_SIZE_256 = 256;
    private int keySize = 128;

    public KcAES() {
        super(new AESEngine());
    }

    public KcAES(String mode) {
        super(new AESEngine(), mode);
    }

    public KcAES(int keySize) {
        super(new AESEngine());
        if (keySize == 128 || keySize == 192 || keySize == 256) {
            this.keySize = keySize;
        }
    }

    public KcAES(int keySize, String mode) {
        super(new AESEngine(), mode);
        if (keySize == 128 || keySize == 192 || keySize == 256) {
            this.keySize = keySize;
        }
    }

    @Override
    public byte[] generateKey(byte[] seed) {
        return this.generateKey(seed, this.keySize);
    }

    public static void main(String[] args) throws Exception {
        String s = "Hello,world!";
        int keySize = 256;
        KcAES aes = new KcAES(keySize);
        byte[] key = aes.generateKey();
        byte[] iv = aes.generateIV();
        byte[] secData = aes.encrypt(s.getBytes(), key);
        System.out.println(aes.getAlgorithmName() + ":" + secData.length);
        System.out.println(Hex.toHexString(secData));
        byte[] oriData = aes.decrypt(secData, key);
        System.out.println(new String(oriData));
        secData = aes.encrypt(s.getBytes(), key, iv);
        System.out.println(aes.getAlgorithmName() + ":" + secData.length);
        System.out.println(Hex.toHexString(secData));
        oriData = aes.decrypt(secData, key, iv);
        System.out.println(new String(oriData));
    }
}

