/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cms;

import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.DERNull;
import com.koalii.kgsp.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.pkcs.RSAPublicKey;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.RSAKeyParameters;
import com.koalii.kgsp.bc.operator.ContentSigner;
import com.koalii.kgsp.bc.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.koalii.kgsp.bc.operator.bc.BcRSAContentSignerBuilder;
import com.koalii.kgsp.bc.util.encoders.Hex;
import com.koalii.kgsp.core.cms.CertIssue;
import com.koalii.kgsp.core.crypto.KcRSA;
import com.koalii.kgsp.core.exception.KcException;
import java.io.FileOutputStream;

public class RSACertIssue
extends CertIssue {
    private AlgorithmIdentifier signAid = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256WithRSAEncryption, DERNull.INSTANCE);

    public void setSignAlgOid(ASN1ObjectIdentifier oid) {
        this.signAid = new AlgorithmIdentifier(oid, DERNull.INSTANCE);
    }

    @Override
    protected SubjectPublicKeyInfo generateSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws KcException {
        if (!(publicKey instanceof RSAKeyParameters)) {
            throw new KcException(100126, "issuer rsa cert");
        }
        RSAKeyParameters rsaPublicKey = (RSAKeyParameters)publicKey;
        AlgorithmIdentifier aid = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
        RSAPublicKey p = new RSAPublicKey(rsaPublicKey.getModulus(), rsaPublicKey.getExponent());
        try {
            return new SubjectPublicKeyInfo(aid, p);
        }
        catch (Exception e) {
            throw new KcException(100128, "issuer rsa cert: create public key info error");
        }
    }

    @Override
    protected ContentSigner buildSigner() throws KcException {
        ContentSigner signer;
        DefaultDigestAlgorithmIdentifierFinder digAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
        AlgorithmIdentifier digAlgId = digAlgFinder.find(this.signAid);
        try {
            signer = new BcRSAContentSignerBuilder(this.signAid, digAlgId).build(this.issuerPrivateKey);
        }
        catch (Exception e) {
            throw new KcException(100110, "issuer rsa cert: signer build error", e);
        }
        return signer;
    }

    public static void main(String[] args) throws Exception {
        KcRSA rsa = new KcRSA();
        rsa.generateKeyPair(1024);
        RSACertIssue issuer = new RSACertIssue();
        issuer.setCertDn("CN=Test, C=CN");
        issuer.setIssuerKeyPair(rsa);
        X509CertificateHolder certHolder = issuer.issueSelfSignedCert();
        System.out.println(Hex.toHexString(certHolder.getEncoded()));
        FileOutputStream fout = new FileOutputStream("rootca.cer");
        fout.write(certHolder.getEncoded());
        fout.close();
        KcRSA rsaUser = new KcRSA();
        rsaUser.generateKeyPair(1024);
        issuer.resetForIssueCert();
        issuer.setCertDn("CN=liqy, C=CN");
        issuer.setCertPublicKey(rsaUser.getPublicKey());
        certHolder = issuer.issueSignCert();
        System.out.println(Hex.toHexString(certHolder.getEncoded()));
        fout = new FileOutputStream("user.cer");
        fout.write(certHolder.getEncoded());
        fout.close();
    }
}

