/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cms;

import com.koalii.kgsp.bc.asn1.x500.X500Name;
import com.koalii.kgsp.bc.asn1.x509.BasicConstraints;
import com.koalii.kgsp.bc.asn1.x509.ExtendedKeyUsage;
import com.koalii.kgsp.bc.asn1.x509.Extension;
import com.koalii.kgsp.bc.asn1.x509.KeyPurposeId;
import com.koalii.kgsp.bc.asn1.x509.KeyUsage;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.cert.CertIOException;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.cert.X509v3CertificateBuilder;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.operator.ContentSigner;
import com.koalii.kgsp.bc.util.BigIntegers;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.exception.KcException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;

public abstract class CertIssue {
    protected static final int keyUsageSign = 200;
    protected static final int keyUsageEncrypt = 48;
    protected static final int keyUsageAll = 248;
    protected static final int keyUsageRootCa = 250;
    protected X500Name certDn;
    protected int certValidDays = 365;
    protected int certSnByteSize = 8;
    protected BigInteger certSn = BigInteger.ZERO;
    protected int certKeyUsage = 248;
    protected AsymmetricKeyParameter certPublicKey;
    protected X500Name issuerDn;
    protected AsymmetricKeyParameter issuerPublicKey;
    protected AsymmetricKeyParameter issuerPrivateKey;
    protected X509CertificateHolder issuerCert;

    public void resetForIssueCert() {
        this.certDn = null;
        this.certSn = BigInteger.ZERO;
        this.certPublicKey = null;
    }

    public void setCertDn(String name) {
        this.certDn = new X500Name(name);
    }

    public void setIssuerStore(KcKeyStore store) {
        this.issuerPublicKey = store.getPublicKey();
        this.issuerPrivateKey = store.getPrivateKey();
        this.issuerCert = store.getCert();
        if (null != this.issuerCert) {
            this.issuerDn = this.issuerCert.getSubject();
        }
    }

    public void setIssuerKeyPair(KcAsymmetricKeyPair keyPair) {
        if (keyPair.isKeyEmpty()) {
            keyPair.generateKeyPair();
        }
        this.issuerPublicKey = keyPair.getPublicKey();
        this.issuerPrivateKey = keyPair.getPrivateKey();
    }

    public void setCertValidDays(int days) {
        if (days > 0) {
            this.certValidDays = days;
        }
    }

    public void setCertPublicKey(AsymmetricKeyParameter publicKey) {
        this.certPublicKey = publicKey;
    }

    public void setCertSnByteSize(int size) {
        if (size > 0) {
            this.certSnByteSize = size;
        }
    }

    public void setCertSn(String s) {
        this.certSn = new BigInteger(s);
    }

    public void setCertSn(byte[] b) {
        this.certSn = new BigInteger(BigIntegers.asUnsignedByteArray(new BigInteger(b)));
    }

    public void setCertSnHex(String hex) {
        this.certSn = new BigInteger(hex, 16);
    }

    public X509CertificateHolder issueSelfSignedCert() throws KcException {
        this.issuerDn = this.certDn;
        this.certPublicKey = this.issuerPublicKey;
        this.certKeyUsage = 250;
        X509v3CertificateBuilder certGenerator = this.createCertBuilder();
        try {
            certGenerator.addExtension(Extension.basicConstraints, true, new BasicConstraints(false));
            certGenerator.addExtension(Extension.extendedKeyUsage, true, new ExtendedKeyUsage(KeyPurposeId.id_kp_timeStamping));
        }
        catch (CertIOException e) {
            throw new KcException(100117, "issuer self sign cert: add extension basicConstraints or extendedKeyUsage failed - " + this.certDn, e);
        }
        X509CertificateHolder holder = certGenerator.build(this.buildSigner());
        return holder;
    }

    public X509CertificateHolder issueCert() throws KcException {
        this.certKeyUsage = 248;
        X509v3CertificateBuilder certGenerator = this.createCertBuilder();
        X509CertificateHolder holder = certGenerator.build(this.buildSigner());
        return holder;
    }

    public X509CertificateHolder issueSignCert() throws KcException {
        this.certKeyUsage = 200;
        X509v3CertificateBuilder certGenerator = this.createCertBuilder();
        X509CertificateHolder holder = certGenerator.build(this.buildSigner());
        return holder;
    }

    public X509CertificateHolder issueEncryptCert() throws KcException {
        this.certKeyUsage = 48;
        X509v3CertificateBuilder certGenerator = this.createCertBuilder();
        X509CertificateHolder holder = certGenerator.build(this.buildSigner());
        return holder;
    }

    protected abstract ContentSigner buildSigner() throws KcException;

    protected abstract SubjectPublicKeyInfo generateSubjectPublicKeyInfo(AsymmetricKeyParameter var1) throws KcException;

    protected BigInteger genarateCertSn() {
        if (this.certSn != BigInteger.ZERO) {
            return this.certSn;
        }
        byte[] sn = new byte[this.certSnByteSize];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(sn);
        this.certSn = new BigInteger(BigIntegers.asUnsignedByteArray(new BigInteger(sn))).abs();
        return this.certSn;
    }

    protected X509v3CertificateBuilder createCertBuilder() throws KcException {
        this.checkCertInfo();
        BigInteger sn = this.genarateCertSn();
        SubjectPublicKeyInfo publicInfo = this.generateSubjectPublicKeyInfo(this.certPublicKey);
        Date notBefore = new Date();
        Date notAfter = new Date();
        notAfter.setTime(notBefore.getTime() + (long)(this.certValidDays * 24 * 3600) * 1000L);
        X509v3CertificateBuilder certGenerator = new X509v3CertificateBuilder(this.issuerDn, sn, notBefore, notAfter, this.certDn, publicInfo);
        try {
            certGenerator.addExtension(Extension.keyUsage, true, new KeyUsage(this.certKeyUsage));
        }
        catch (Exception e) {
            throw new KcException(100117, "issue cert: add extension keyUsage failed - " + this.certDn, e);
        }
        return certGenerator;
    }

    protected void checkCertInfo() throws KcException {
        if (null == this.certDn) {
            throw new KcException(100112, "issue cert: subject dn empty");
        }
        if (null == this.certPublicKey) {
            throw new KcException(100114, "issue cert: punlic key empty");
        }
        if (null == this.issuerPrivateKey) {
            throw new KcException(100115, "issue cert: private key empty");
        }
        if (null == this.issuerDn) {
            throw new KcException(100113, "issue cert: issuer dn empty");
        }
    }
}

