/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import com.koalii.kgsp.bc.asn1.gm.GMNamedCurves;
import com.koalii.kgsp.bc.asn1.gm.GMObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.pkcs.PrivateKeyInfo;
import com.koalii.kgsp.bc.asn1.sec.ECPrivateKey;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x9.X9ECParameters;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.ECDomainParameters;
import com.koalii.kgsp.bc.crypto.params.ECPrivateKeyParameters;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.cert.KcSM2CertStore;
import com.koalii.kgsp.core.exception.KcException;
import java.math.BigInteger;
import java.security.PrivateKey;

public class KcSM2KeyStore
extends KcSM2CertStore
implements KcKeyStore {
    public KcSM2KeyStore() {
    }

    public KcSM2KeyStore(X509CertificateHolder cert, AsymmetricKeyParameter privKey) throws KcException {
        this.cert = cert;
        this.publicKey = KcSM2CertStore.parseEcPublicKey(cert);
        this.privateKey = privKey;
    }

    public KcSM2KeyStore(X509CertificateHolder cert, PrivateKeyInfo privKeyInfo) throws KcException {
        this.cert = cert;
        this.publicKey = KcSM2CertStore.parseEcPublicKey(cert);
        this.privateKey = KcSM2KeyStore.parseEcPrivateKey(privKeyInfo);
    }

    public static boolean isSM2Key(PrivateKeyInfo privKeyInfo) {
        AlgorithmIdentifier aid = privKeyInfo.getPrivateKeyAlgorithm();
        return KcSM2CertStore.isSM2Aid(aid);
    }

    protected static ECPrivateKeyParameters parseEcPrivateKey(PrivateKeyInfo privKeyInfo) throws KcException {
        if (!KcSM2KeyStore.isSM2Key(privKeyInfo)) {
            throw new KcException(100121);
        }
        try {
            ECPrivateKey ec = ECPrivateKey.getInstance(privKeyInfo.parsePrivateKey());
            BigInteger d = ec.getKey();
            X9ECParameters gmParams = GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1);
            ECDomainParameters gmDomainParams = new ECDomainParameters(gmParams.getCurve(), gmParams.getG(), gmParams.getN(), gmParams.getH(), gmParams.getSeed());
            return new ECPrivateKeyParameters(d, gmDomainParams);
        }
        catch (Exception e) {
            throw new KcException(100122, (Throwable)e);
        }
    }

    @Override
    public void setPrivateKey(AsymmetricKeyParameter privKey) {
        this.privateKey = privKey;
    }

    @Override
    public AsymmetricKeyParameter getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public PrivateKey getJcaPrivateKey() throws KcException {
        return null;
    }

    @Override
    public boolean isKeyMatched() throws KcException {
        return false;
    }

    @Override
    public void loadKeyData(byte[] keyData, char[] password) throws KcException {
    }
}

