/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.core.cert.KcCertStoreImpl;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.exception.KcException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class KcSDFKeyStore
extends KcCertStoreImpl
implements KcKeyStore {
    private String provName;
    private String provType;
    private String provId;
    private int keyIndex;
    private byte[] keyImprint;
    private String algName;
    private int keyBitLength;

    public KcSDFKeyStore() {
    }

    public KcSDFKeyStore(X509CertificateHolder cert, String keyData) throws KcException {
        this.cert = cert;
        this.loadKeyData(keyData.getBytes(), null);
        if (!this.isKeyMatched()) {
            throw new KcException(100134, "sdf cert and key unmatched");
        }
    }

    public String getProvName() {
        return this.provName;
    }

    public String getProvId() {
        return this.provId;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public String getProvType() {
        return this.provType;
    }

    public byte[] getKeyImprint() {
        return this.keyImprint;
    }

    @Override
    public void setCert(X509CertificateHolder cert) throws KcException {
        this.cert = cert;
    }

    @Override
    public PublicKey getJcaPublicKey() throws KcException {
        return null;
    }

    @Override
    public boolean isIssuerOf(X509CertificateHolder child) {
        return false;
    }

    @Override
    public String getKeyAlgName() {
        return this.algName;
    }

    @Override
    public int getKeyBitLength() throws KcException {
        return this.keyBitLength;
    }

    @Override
    public void setPrivateKey(AsymmetricKeyParameter key) {
    }

    @Override
    public AsymmetricKeyParameter getPrivateKey() {
        return null;
    }

    @Override
    public PrivateKey getJcaPrivateKey() throws KcException {
        return null;
    }

    @Override
    public boolean isKeyMatched() throws KcException {
        return false;
    }

    @Override
    public void loadKeyData(byte[] keyData, char[] password) throws KcException {
    }

    public static boolean isSdfKey(byte[] keyData) {
        return false;
    }

    public static boolean isKeyMatched(X509CertificateHolder cert, String keyData) {
        return false;
    }

    protected static Map<String, String> parseSdfKey(byte[] keyData) throws KcException {
        String strKeyData = new String(keyData);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            strKeyData = strKeyData.trim();
            strKeyData = strKeyData.substring(1, strKeyData.length() - 1);
            String[] strKeyDatas = strKeyData.split(",");
            for (int i = 0; i < strKeyDatas.length; ++i) {
                String key = strKeyDatas[i].split("=")[0].trim();
                String value = strKeyDatas[i].split("=")[1];
                value = value.replace("\"", "");
                value = value.replace("'", "");
                map.put(key, value);
            }
        }
        catch (Exception e) {
            throw new KcException(100003, (Throwable)e);
        }
        if (null == map.get("provName") || null == map.get("provType") || null == map.get("provId") || null == map.get("keyIndex") || null == map.get("b64keyImprint") || null == map.get("algName")) {
            throw new KcException(100133);
        }
        try {
            Integer.parseInt((String)map.get("keyIndex"));
        }
        catch (Exception e) {
            throw new KcException(100003, (Throwable)e);
        }
        return map;
    }
}

