/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.pkcs.PrivateKeyInfo;
import com.koalii.kgsp.bc.asn1.pkcs.RSAPrivateKey;
import com.koalii.kgsp.bc.asn1.pkcs.RSAPublicKey;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.RSAPrivateCrtKeyParameters;
import com.koalii.kgsp.bc.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.koalii.kgsp.bc.openssl.PEMKeyPair;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.cert.KcRSACertStore;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.pkcs.Pkcs8Decryptor;
import com.koalii.kgsp.core.util.PemKeyPairUtil;
import java.security.PrivateKey;

public class KcRSAKeyStore
extends KcRSACertStore
implements KcKeyStore {
    public KcRSAKeyStore() {
    }

    public KcRSAKeyStore(X509CertificateHolder cert, PrivateKeyInfo privKeyInfo) throws KcException {
        if (!KcRSAKeyStore.isKeyMatched(cert, privKeyInfo)) {
            throw new KcException(100143, "rsa cert and private key unmatched");
        }
        this.cert = cert;
        this.publicKey = KcRSACertStore.parseRsaPublicKey(cert);
        this.privateKey = KcRSAKeyStore.parseRsaPrivateKey(privKeyInfo);
    }

    public KcRSAKeyStore(X509CertificateHolder cert, AsymmetricKeyParameter privKey) throws KcException {
        if (!KcRSAKeyStore.isKeyMatched(cert, privKey)) {
            throw new KcException(100143, "rsa cert and private key unmatched");
        }
        this.cert = cert;
        this.publicKey = KcRSACertStore.parseRsaPublicKey(cert);
        this.privateKey = privKey;
    }

    @Override
    public void setPrivateKey(AsymmetricKeyParameter privKey) {
        this.privateKey = privKey;
    }

    @Override
    public boolean isKeyMatched() throws KcException {
        return KcRSAKeyStore.isKeyMatched(this.cert, this.privateKey);
    }

    @Override
    public AsymmetricKeyParameter getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public PrivateKey getJcaPrivateKey() throws KcException {
        return null;
    }

    public static boolean isRsaKey(PrivateKeyInfo privKeyInfo) {
        ASN1ObjectIdentifier aid = privKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        return RSAUtil.isRsaOid(aid);
    }

    public static boolean isKeyMatched(RSAPublicKey pubKey, RSAPrivateKey privKey) throws KcException {
        return pubKey.getModulus().equals(privKey.getModulus()) && pubKey.getPublicExponent().equals(privKey.getPublicExponent());
    }

    public static boolean isKeyMatched(X509CertificateHolder cert, AsymmetricKeyParameter privKey) throws KcException {
        if (!KcRSACertStore.isRsaCert(cert)) {
            throw new KcException(100116, "rsa cert key alg error");
        }
        if (!(privKey instanceof RSAPrivateCrtKeyParameters)) {
            throw new KcException(100121, "rsa private key alg error");
        }
        RSAPublicKey pubKey = null;
        try {
            pubKey = RSAPublicKey.getInstance(cert.getSubjectPublicKeyInfo().parsePublicKey());
        }
        catch (Exception e) {
            throw new KcException(100127, "rsa public key parse failed", e);
        }
        RSAPrivateCrtKeyParameters rsaPrivKeyParams = (RSAPrivateCrtKeyParameters)privKey;
        return pubKey.getModulus().equals(rsaPrivKeyParams.getModulus()) && pubKey.getPublicExponent().equals(rsaPrivKeyParams.getPublicExponent());
    }

    public static boolean isKeyMatched(X509CertificateHolder cert, PrivateKeyInfo privKeyInfo) throws KcException {
        if (!KcRSACertStore.isRsaCert(cert)) {
            throw new KcException(100116, "rsa cert key alg error");
        }
        if (!KcRSAKeyStore.isRsaKey(privKeyInfo)) {
            throw new KcException(100121, "rsa private key alg error");
        }
        RSAPublicKey pubKey = null;
        RSAPrivateKey privKey = null;
        try {
            pubKey = RSAPublicKey.getInstance(cert.getSubjectPublicKeyInfo().parsePublicKey());
        }
        catch (Exception e) {
            throw new KcException(100127, "rsa public key parse failed", e);
        }
        try {
            privKey = RSAPrivateKey.getInstance(privKeyInfo.parsePrivateKey());
        }
        catch (Exception e) {
            throw new KcException(100127, "rsa public key parse failed", e);
        }
        return KcRSAKeyStore.isKeyMatched(pubKey, privKey);
    }

    public static RSAPrivateCrtKeyParameters parseRsaPrivateKey(PrivateKeyInfo privKeyInfo) throws KcException {
        if (!KcRSAKeyStore.isRsaKey(privKeyInfo)) {
            throw new KcException(100121, "parse rsa private key failed");
        }
        try {
            RSAPrivateKey privKey = RSAPrivateKey.getInstance(privKeyInfo.parsePrivateKey());
            return new RSAPrivateCrtKeyParameters(privKey.getModulus(), privKey.getPublicExponent(), privKey.getPrivateExponent(), privKey.getPrime1(), privKey.getPrime2(), privKey.getExponent1(), privKey.getExponent2(), privKey.getCoefficient());
        }
        catch (Exception e) {
            throw new KcException(100122);
        }
    }

    @Override
    public void loadKeyData(byte[] keyData, char[] password) throws KcException {
        PEMKeyPair keyPair = PemKeyPairUtil.parsePemKeyPair(keyData, password);
        this.privateKey = KcRSAKeyStore.parseRsaPrivateKey(keyPair.getPrivateKeyInfo());
        if (null == this.publicKey) {
            this.publicKey = KcRSAKeyStore.parseRsaPublicKey(keyPair.getPublicKeyInfo());
        }
    }

    public void loadPbeKeyData(byte[] keyData, char[] password) throws KcException {
        PrivateKeyInfo privKey = Pkcs8Decryptor.pbeDecrypt(keyData, password);
        this.privateKey = KcRSAKeyStore.parseRsaPrivateKey(privKey);
    }
}

