/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import com.koalii.kgsp.bc.asn1.x509.KeyUsage;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.cert.jcajce.JcaX509CertificateConverter;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.core.cert.KcCertStore;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.util.ImprintUtil;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public abstract class KcCertStoreImpl
implements KcCertStore {
    protected X509CertificateHolder cert;
    protected AsymmetricKeyParameter publicKey;
    protected AsymmetricKeyParameter privateKey;

    protected KcCertStoreImpl() {
    }

    @Override
    public X509CertificateHolder getCert() {
        return this.cert;
    }

    @Override
    public boolean isSignCert() {
        KeyUsage usage = KeyUsage.fromExtensions(this.getCert().getExtensions());
        if (usage == null) {
            return false;
        }
        return usage.hasUsages(128) || usage.hasUsages(64) || usage.hasUsages(4) || usage.hasUsages(2);
    }

    @Override
    public boolean isEncryptCert() {
        KeyUsage usage = KeyUsage.fromExtensions(this.getCert().getExtensions());
        if (usage == null) {
            return false;
        }
        return usage.hasUsages(16) || usage.hasUsages(32768) || usage.hasUsages(1) || usage.hasUsages(32);
    }

    @Override
    public String getCertImprint() throws KcException {
        if (null == this.cert) {
            return null;
        }
        return ImprintUtil.genCertImprint(this.cert);
    }

    @Override
    public AsymmetricKeyParameter getPublicKey() {
        return this.publicKey;
    }

    @Override
    public X509Certificate getJcaCert() throws KcException {
        JcaX509CertificateConverter convertor = new JcaX509CertificateConverter();
        try {
            return convertor.getCertificate(this.cert);
        }
        catch (CertificateException e) {
            throw new KcException(100111, "to jca cert failed", e);
        }
    }

    @Override
    public X509Certificate getJcaCert(String providerName) throws KcException {
        JcaX509CertificateConverter convertor = new JcaX509CertificateConverter();
        convertor.setProvider(providerName);
        try {
            return convertor.getCertificate(this.cert);
        }
        catch (Exception e) {
            throw new KcException(100111, "to jca cert failed with provider " + providerName, e);
        }
    }
}

