/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.core.cert.KcCertStore;
import com.koalii.kgsp.core.cert.KcCertStoreImpl;
import com.koalii.kgsp.core.cert.KcRSACertStore;
import com.koalii.kgsp.core.cert.KcSM2CertStore;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.util.X509CertUtil;
import java.io.FileInputStream;

public class KcCertStoreFactory {
    public static KcCertStore createCertStoreByFile(String certFilename) throws KcException {
        byte[] pdata;
        try {
            FileInputStream fin = new FileInputStream(certFilename);
            int ndata = fin.available();
            pdata = new byte[ndata];
            ndata = fin.read(pdata);
            fin.close();
        }
        catch (Exception e) {
            throw new KcException(100003, (Throwable)e);
        }
        return KcCertStoreFactory.createCertStore(pdata);
    }

    public static KcCertStoreImpl createCertStore(byte[] certData) throws KcException {
        X509CertificateHolder cert = null;
        try {
            cert = X509CertUtil.parseCertData(certData);
        }
        catch (Exception e) {
            throw new KcException(100111, (Throwable)e);
        }
        return KcCertStoreFactory.createCertStore(cert);
    }

    public static KcCertStoreImpl createCertStore(X509CertificateHolder cert) throws KcException {
        if (KcRSACertStore.isRsaCert(cert)) {
            return new KcRSACertStore(cert);
        }
        if (KcSM2CertStore.isSM2Cert(cert)) {
            return new KcSM2CertStore(cert);
        }
        throw new KcException(100116);
    }

    public static void main(String[] args) {
    }
}

