/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.pkcs.bc;

import com.koalii.kgsp.bc.asn1.DERNull;
import com.koalii.kgsp.bc.asn1.pkcs.PKCS12PBEParams;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.operator.MacCalculator;
import com.koalii.kgsp.bc.operator.OperatorCreationException;
import com.koalii.kgsp.bc.operator.bc.BcDigestProvider;
import com.koalii.kgsp.bc.pkcs.PKCS12MacCalculatorBuilder;
import com.koalii.kgsp.bc.pkcs.PKCS12MacCalculatorBuilderProvider;
import com.koalii.kgsp.bc.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider digestProvider) {
        this.digestProvider = digestProvider;
    }

    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] password) throws OperatorCreationException {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pbeParams, password);
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

