/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.pkcs;

import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.nist.NISTObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.koalii.kgsp.bc.util.Integers;
import java.util.HashMap;
import java.util.Map;

class PKCSUtils {
    private static final Map PRFS_SALT = new HashMap();

    PKCSUtils() {
    }

    static int getSaltSize(ASN1ObjectIdentifier algorithm) {
        if (!PRFS_SALT.containsKey(algorithm)) {
            throw new IllegalStateException("no salt size for algorithm: " + algorithm);
        }
        return (Integer)PRFS_SALT.get(algorithm);
    }

    static {
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA1, Integers.valueOf(20));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA256, Integers.valueOf(32));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA512, Integers.valueOf(64));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA224, Integers.valueOf(28));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA384, Integers.valueOf(48));
        PRFS_SALT.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, Integers.valueOf(28));
        PRFS_SALT.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, Integers.valueOf(32));
        PRFS_SALT.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, Integers.valueOf(48));
        PRFS_SALT.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, Integers.valueOf(64));
        PRFS_SALT.put(CryptoProObjectIdentifiers.gostR3411Hmac, Integers.valueOf(32));
    }
}

