/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.operator.bc;

import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.crypto.AsymmetricBlockCipher;
import com.koalii.kgsp.bc.crypto.CipherParameters;
import com.koalii.kgsp.bc.crypto.InvalidCipherTextException;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.ParametersWithRandom;
import com.koalii.kgsp.bc.operator.AsymmetricKeyWrapper;
import com.koalii.kgsp.bc.operator.GenericKey;
import com.koalii.kgsp.bc.operator.OperatorException;
import com.koalii.kgsp.bc.operator.bc.OperatorUtils;
import java.security.SecureRandom;

public abstract class BcAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private AsymmetricKeyParameter publicKey;
    private SecureRandom random;

    public BcAsymmetricKeyWrapper(AlgorithmIdentifier encAlgId, AsymmetricKeyParameter publicKey) {
        super(encAlgId);
        this.publicKey = publicKey;
    }

    public BcAsymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        AsymmetricBlockCipher keyEncryptionCipher = this.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        CipherParameters params = this.publicKey;
        if (this.random != null) {
            params = new ParametersWithRandom(params, this.random);
        }
        try {
            byte[] keyEnc = OperatorUtils.getKeyBytes(encryptionKey);
            keyEncryptionCipher.init(true, params);
            return keyEncryptionCipher.processBlock(keyEnc, 0, keyEnc.length);
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to encrypt contents key", e);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier var1);
}

