/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.crypto.signers;

import com.koalii.kgsp.bc.crypto.AsymmetricCipherKeyPair;
import com.koalii.kgsp.bc.crypto.CipherParameters;
import com.koalii.kgsp.bc.crypto.CryptoServicesRegistrar;
import com.koalii.kgsp.bc.crypto.DSAExt;
import com.koalii.kgsp.bc.crypto.DataLengthException;
import com.koalii.kgsp.bc.crypto.generators.ECKeyPairGenerator;
import com.koalii.kgsp.bc.crypto.params.ECKeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.params.ECKeyParameters;
import com.koalii.kgsp.bc.crypto.params.ECPrivateKeyParameters;
import com.koalii.kgsp.bc.crypto.params.ECPublicKeyParameters;
import com.koalii.kgsp.bc.crypto.params.ParametersWithRandom;
import com.koalii.kgsp.bc.math.ec.ECAlgorithms;
import com.koalii.kgsp.bc.math.ec.ECConstants;
import com.koalii.kgsp.bc.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNRSigner
implements DSAExt {
    private boolean forSigning;
    private ECKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.forSigning = forSigning;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] digest) {
        ECKeyPairGenerator keyGen;
        AsymmetricCipherKeyPair tempPair;
        ECPublicKeyParameters V;
        BigInteger Vx;
        if (!this.forSigning) {
            throw new IllegalStateException("not initialised for signing");
        }
        BigInteger n = this.getOrder();
        int nBitLength = n.bitLength();
        BigInteger e = new BigInteger(1, digest);
        int eBitLength = e.bitLength();
        ECPrivateKeyParameters privKey = (ECPrivateKeyParameters)this.key;
        if (eBitLength > nBitLength) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        BigInteger r = null;
        BigInteger s = null;
        do {
            keyGen = new ECKeyPairGenerator();
            keyGen.init(new ECKeyGenerationParameters(privKey.getParameters(), this.random));
        } while ((r = (Vx = (V = (ECPublicKeyParameters)(tempPair = keyGen.generateKeyPair()).getPublic()).getQ().getAffineXCoord().toBigInteger()).add(e).mod(n)).equals(ECConstants.ZERO));
        BigInteger x = privKey.getD();
        BigInteger u = ((ECPrivateKeyParameters)tempPair.getPrivate()).getD();
        s = u.subtract(r.multiply(x)).mod(n);
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] digest, BigInteger r, BigInteger s) {
        ECPoint W;
        if (this.forSigning) {
            throw new IllegalStateException("not initialised for verifying");
        }
        ECPublicKeyParameters pubKey = (ECPublicKeyParameters)this.key;
        BigInteger n = pubKey.getParameters().getN();
        int nBitLength = n.bitLength();
        BigInteger e = new BigInteger(1, digest);
        int eBitLength = e.bitLength();
        if (eBitLength > nBitLength) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        if (r.compareTo(ECConstants.ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ECConstants.ZERO) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        ECPoint G = pubKey.getParameters().getG();
        ECPoint P = ECAlgorithms.sumOfTwoMultiplies(G, s, W = pubKey.getQ(), r).normalize();
        if (P.isInfinity()) {
            return false;
        }
        BigInteger x = P.getAffineXCoord().toBigInteger();
        BigInteger t = r.subtract(x).mod(n);
        return t.equals(e);
    }
}

