/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.crypto.generators;

import com.koalii.kgsp.bc.crypto.AsymmetricCipherKeyPair;
import com.koalii.kgsp.bc.crypto.AsymmetricCipherKeyPairGenerator;
import com.koalii.kgsp.bc.crypto.KeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.generators.DHKeyGeneratorHelper;
import com.koalii.kgsp.bc.crypto.params.DHParameters;
import com.koalii.kgsp.bc.crypto.params.ElGamalKeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.params.ElGamalParameters;
import com.koalii.kgsp.bc.crypto.params.ElGamalPrivateKeyParameters;
import com.koalii.kgsp.bc.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

