/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.crypto.ec;

import com.koalii.kgsp.bc.crypto.CipherParameters;
import com.koalii.kgsp.bc.crypto.ec.ECDecryptor;
import com.koalii.kgsp.bc.crypto.ec.ECPair;
import com.koalii.kgsp.bc.crypto.params.ECPrivateKeyParameters;
import com.koalii.kgsp.bc.math.ec.ECAlgorithms;
import com.koalii.kgsp.bc.math.ec.ECCurve;
import com.koalii.kgsp.bc.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters param) {
        if (!(param instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)param;
    }

    @Override
    public ECPoint decrypt(ECPair pair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECCurve curve = this.key.getParameters().getCurve();
        ECPoint tmp = ECAlgorithms.cleanPoint(curve, pair.getX()).multiply(this.key.getD());
        return ECAlgorithms.cleanPoint(curve, pair.getY()).subtract(tmp).normalize();
    }
}

