/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.crypto.agreement;

import com.koalii.kgsp.bc.crypto.CipherParameters;
import com.koalii.kgsp.bc.crypto.agreement.ECDHCBasicAgreement;
import com.koalii.kgsp.bc.crypto.params.ECDHUPrivateParameters;
import com.koalii.kgsp.bc.crypto.params.ECDHUPublicParameters;
import com.koalii.kgsp.bc.util.Arrays;
import com.koalii.kgsp.bc.util.BigIntegers;
import java.math.BigInteger;

public class ECDHCUnifiedAgreement {
    private ECDHUPrivateParameters privParams;

    public void init(CipherParameters key) {
        this.privParams = (ECDHUPrivateParameters)key;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        ECDHUPublicParameters pubParams = (ECDHUPublicParameters)pubKey;
        ECDHCBasicAgreement sAgree = new ECDHCBasicAgreement();
        ECDHCBasicAgreement eAgree = new ECDHCBasicAgreement();
        sAgree.init(this.privParams.getStaticPrivateKey());
        BigInteger sComp = sAgree.calculateAgreement(pubParams.getStaticPublicKey());
        eAgree.init(this.privParams.getEphemeralPrivateKey());
        BigInteger eComp = eAgree.calculateAgreement(pubParams.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), eComp), BigIntegers.asUnsignedByteArray(this.getFieldSize(), sComp));
    }
}

