/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.cms;

import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.kgsp.bc.asn1.cms.KeyTransRecipientInfo;
import com.koalii.kgsp.bc.asn1.cms.RecipientIdentifier;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.cms.AuthAttributesProvider;
import com.koalii.kgsp.bc.cms.CMSException;
import com.koalii.kgsp.bc.cms.CMSSecureReadable;
import com.koalii.kgsp.bc.cms.KeyTransRecipient;
import com.koalii.kgsp.bc.cms.KeyTransRecipientId;
import com.koalii.kgsp.bc.cms.Recipient;
import com.koalii.kgsp.bc.cms.RecipientInformation;
import com.koalii.kgsp.bc.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        RecipientIdentifier r = info.getRecipientIdentifier();
        if (r.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(octs.getOctets());
        } else {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

