/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.cms;

import com.koalii.kgsp.bc.asn1.ASN1EncodableVector;
import com.koalii.kgsp.bc.asn1.BEROctetString;
import com.koalii.kgsp.bc.asn1.BERSet;
import com.koalii.kgsp.bc.asn1.DERSet;
import com.koalii.kgsp.bc.asn1.cms.AttributeTable;
import com.koalii.kgsp.bc.asn1.cms.CMSObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.cms.ContentInfo;
import com.koalii.kgsp.bc.asn1.cms.EncryptedContentInfo;
import com.koalii.kgsp.bc.asn1.cms.EnvelopedData;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.cms.CMSEnvelopedData;
import com.koalii.kgsp.bc.cms.CMSEnvelopedGenerator;
import com.koalii.kgsp.bc.cms.CMSException;
import com.koalii.kgsp.bc.cms.CMSTypedData;
import com.koalii.kgsp.bc.cms.RecipientInfoGenerator;
import com.koalii.kgsp.bc.operator.GenericKey;
import com.koalii.kgsp.bc.operator.OutputEncryptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    private CMSEnvelopedData doGenerate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        if (!this.oldRecipientInfoGenerators.isEmpty()) {
            throw new IllegalStateException("can only use addRecipientGenerator() with this method");
        }
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            OutputStream cOut = contentEncryptor.getOutputStream(bOut);
            content.write(cOut);
            cOut.close();
        }
        catch (IOException e) {
            throw new CMSException("");
        }
        byte[] encryptedContent = bOut.toByteArray();
        AlgorithmIdentifier encAlgId = contentEncryptor.getAlgorithmIdentifier();
        BEROctetString encContent = new BEROctetString(encryptedContent);
        GenericKey encKey = contentEncryptor.getKey();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add(recipient.generate(encKey));
        }
        EncryptedContentInfo eci = new EncryptedContentInfo(content.getContentType(), encAlgId, encContent);
        BERSet unprotectedAttrSet = null;
        if (this.unprotectedAttributeGenerator != null) {
            AttributeTable attrTable = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            unprotectedAttrSet = new BERSet(attrTable.toASN1EncodableVector());
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.envelopedData, new EnvelopedData(this.originatorInfo, new DERSet(recipientInfos), eci, unprotectedAttrSet));
        return new CMSEnvelopedData(contentInfo);
    }

    public CMSEnvelopedData generate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        return this.doGenerate(content, contentEncryptor);
    }
}

