/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.cms;

import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.cms.CompressedData;
import com.koalii.kgsp.bc.asn1.cms.ContentInfo;
import com.koalii.kgsp.bc.cms.CMSException;
import com.koalii.kgsp.bc.cms.CMSUtils;
import com.koalii.kgsp.bc.operator.InputExpander;
import com.koalii.kgsp.bc.operator.InputExpanderProvider;
import com.koalii.kgsp.bc.util.Encodable;
import java.io.IOException;
import java.io.InputStream;

public class CMSCompressedData
implements Encodable {
    ContentInfo contentInfo;
    CompressedData comData;

    public CMSCompressedData(byte[] compressedData) throws CMSException {
        this(CMSUtils.readContentInfo(compressedData));
    }

    public CMSCompressedData(InputStream compressedData) throws CMSException {
        this(CMSUtils.readContentInfo(compressedData));
    }

    public CMSCompressedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            this.comData = CompressedData.getInstance(contentInfo.getContent());
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentInfo.getContentType();
    }

    public byte[] getContent(InputExpanderProvider expanderProvider) throws CMSException {
        ContentInfo content = this.comData.getEncapContentInfo();
        ASN1OctetString bytes = (ASN1OctetString)content.getContent();
        InputExpander expander = expanderProvider.get(this.comData.getCompressionAlgorithmIdentifier());
        InputStream zIn = expander.getInputStream(bytes.getOctetStream());
        try {
            return CMSUtils.streamToByteArray(zIn);
        }
        catch (IOException e) {
            throw new CMSException("exception reading compressed stream.", e);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

