/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.crypto;

import com.koalii.kgsp.bc.crypto.BufferedBlockCipher;
import com.koalii.kgsp.bc.crypto.KeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.engines.DESedeEngine;
import com.koalii.kgsp.bc.crypto.generators.DESedeKeyGenerator;
import com.koalii.kgsp.bc.crypto.modes.CBCBlockCipher;
import com.koalii.kgsp.bc.crypto.paddings.PKCS7Padding;
import com.koalii.kgsp.bc.crypto.paddings.PaddedBufferedBlockCipher;
import com.koalii.kgsp.bc.crypto.paddings.ZeroBytePadding;
import com.koalii.kgsp.bc.crypto.params.KeyParameter;
import com.koalii.kgsp.bc.crypto.params.ParametersWithIV;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.crypto.spec.IvParameterSpec;

public class DESUtil {
    public static final String PADDING_ZERO = "PADDING_ZERO";
    public static final String PADDING_PKCS7 = "PADDING_PKCS7";

    public static byte[] generateKey(byte[] seed) {
        SecureRandom sr = new SecureRandom();
        if (null != seed) {
            sr.setSeed(seed);
        } else {
            sr.setSeed(System.currentTimeMillis());
        }
        KeyGenerationParameters kgp = new KeyGenerationParameters(sr, 192);
        DESedeKeyGenerator kg = new DESedeKeyGenerator();
        kg.init(kgp);
        return kg.generateKey();
    }

    private static IvParameterSpec createCtrIvForAES(int messageNumber, SecureRandom random) {
        byte[] ivBytes = new byte[8];
        random.nextBytes(ivBytes);
        ivBytes[0] = (byte)(messageNumber >> 24);
        ivBytes[1] = (byte)(messageNumber >> 16);
        ivBytes[2] = (byte)(messageNumber >> 8);
        ivBytes[3] = (byte)(messageNumber >> 0);
        for (int i = 0; i <= 7; ++i) {
            ivBytes[i] = 0;
        }
        ivBytes[15] = 1;
        return new IvParameterSpec(ivBytes);
    }

    public static DESResulte encrypt(byte[] key, byte[] oridata) throws Exception {
        int outlen;
        int inlen;
        if (null == key || null == oridata) {
            throw new IllegalArgumentException();
        }
        CBCBlockCipher cbc = new CBCBlockCipher(new DESedeEngine());
        byte[] rand = new byte[8];
        IvParameterSpec zeroIv = new IvParameterSpec(rand);
        KeyParameter p = new KeyParameter(key);
        ParametersWithIV param = new ParametersWithIV(p, zeroIv.getIV());
        cbc.init(true, param);
        BufferedBlockCipher cipher = new BufferedBlockCipher(cbc);
        cipher.init(true, new KeyParameter(key));
        int inBlockSize = cipher.getBlockSize() * 10;
        int outBlockSize = cipher.getOutputSize(inBlockSize);
        byte[] inblock = new byte[inBlockSize];
        byte[] outblock = new byte[outBlockSize];
        ByteArrayInputStream bin = new ByteArrayInputStream(oridata);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((inlen = bin.read(inblock, 0, inBlockSize)) != -1) {
            outlen = cipher.processBytes(inblock, 0, inlen, outblock, 0);
            if (outlen <= 0) continue;
            bout.write(outblock, 0, outlen);
        }
        outlen = cipher.doFinal(outblock, 0);
        if (outlen > 0) {
            bout.write(outblock, 0, outlen);
        }
        DESResulte ret = new DESResulte();
        ret.m_ivp = rand;
        ret.m_encrypt = bout.toByteArray();
        return ret;
    }

    public static byte[] decrypt(byte[] key, byte[] secretdata) throws Exception {
        if (null == key || null == secretdata) {
            throw new IllegalArgumentException();
        }
        CBCBlockCipher cbc = new CBCBlockCipher(new DESedeEngine());
        byte[] rand = new byte[8];
        IvParameterSpec zeroIv = new IvParameterSpec(rand);
        KeyParameter p = new KeyParameter(key);
        ParametersWithIV param = new ParametersWithIV(p, zeroIv.getIV());
        cbc.init(false, param);
        BufferedBlockCipher cipher = new BufferedBlockCipher(cbc);
        cipher.init(false, new KeyParameter(key));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] outblock = new byte[cipher.getOutputSize(secretdata.length)];
        int outlen = cipher.processBytes(secretdata, 0, secretdata.length, outblock, 0);
        if (outlen > 0) {
            bout.write(outblock, 0, outlen);
        }
        if ((outlen = cipher.doFinal(outblock, 0)) > 0) {
            bout.write(outblock, 0, outlen);
        }
        return bout.toByteArray();
    }

    public static byte[] decrypt(byte[] key, byte[] secretdata, byte[] iv) throws Exception {
        if (null == key || null == secretdata) {
            throw new IllegalArgumentException();
        }
        CBCBlockCipher cbc = new CBCBlockCipher(new DESedeEngine());
        KeyParameter p = new KeyParameter(key);
        ParametersWithIV param = new ParametersWithIV(p, iv);
        cbc.init(true, param);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(cbc);
        cipher.init(false, new KeyParameter(key));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] outblock = new byte[cipher.getOutputSize(secretdata.length)];
        int outlen = cipher.processBytes(secretdata, 0, secretdata.length, outblock, 0);
        if (outlen > 0) {
            bout.write(outblock, 0, outlen);
        }
        if ((outlen = cipher.doFinal(outblock, 0)) > 0) {
            bout.write(outblock, 0, outlen);
        }
        return bout.toByteArray();
    }

    public static int encAndDec(byte[] key, InputStream inputStream, OutputStream outputStream, String paddingType, boolean isEnc) throws Exception {
        int outlen;
        int inlen;
        if (null == key || null == inputStream || null == paddingType) {
            throw new IllegalArgumentException();
        }
        CBCBlockCipher cbc = new CBCBlockCipher(new DESedeEngine());
        byte[] rand = new byte[8];
        IvParameterSpec zeroIv = new IvParameterSpec(rand);
        KeyParameter p = new KeyParameter(key);
        ParametersWithIV param = new ParametersWithIV(p, zeroIv.getIV());
        cbc.init(isEnc, param);
        PaddedBufferedBlockCipher cipher = null;
        if (paddingType.equals(PADDING_PKCS7)) {
            cipher = new PaddedBufferedBlockCipher(cbc, new PKCS7Padding());
        } else if (paddingType.equals(PADDING_ZERO)) {
            cipher = new PaddedBufferedBlockCipher(cbc, new ZeroBytePadding());
        }
        cipher.init(isEnc, new KeyParameter(key));
        int inBlockSize = cipher.getBlockSize() * 512;
        int outBlockSize = cipher.getOutputSize(inBlockSize);
        byte[] inblock = new byte[inBlockSize];
        byte[] outblock = new byte[outBlockSize];
        while ((inlen = inputStream.read(inblock, 0, inBlockSize)) != -1) {
            outlen = cipher.processBytes(inblock, 0, inlen, outblock, 0);
            if (outlen <= 0) continue;
            outputStream.write(outblock, 0, outlen);
        }
        outlen = cipher.doFinal(outblock, 0);
        if (outlen > 0) {
            outputStream.write(outblock, 0, outlen);
        }
        return 0;
    }

    public static class DESResulte {
        public byte[] m_encrypt;
        public byte[] m_decrypt;
        public byte[] m_ivp;
    }
}

