/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import com.kinggrid.commons.KGCommonUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import javax.imageio.ImageIO;

public class PrintMarkUtil {
    public static void main(String[] args) throws IOException {
        PrintMarkUtil printMarkUtil = new PrintMarkUtil();
        printMarkUtil.createCopyBitmapByTextEx(45, "HUA WEI", 56, 4, 3, "\u9ed1\u4f53", Color.red, 4.5, 3.0, 600);
    }

    public byte[] createCopyBitmapByTextEx(Integer vJD, String vText, int vParam1, int vParam2, int vParam3, String vFontName, Color vFontColor, double vWidth, double vHeight, int vDPI) throws IOException {
        BufferedImage mBmp = null;
        BufferedImage mSrc = null;
        int mDpi = 0;
        double mWidth = 0.0;
        double mHeight = 0.0;
        int mJD = 0;
        Point mSize = new Point();
        Point mLage = new Point();
        Point mThis = new Point();
        mDpi = vDPI;
        mWidth = vWidth;
        mHeight = vHeight;
        mJD = vJD % 360;
        int ModA = 9;
        int HB_A = 2;
        int ModB = 9;
        int HB_B = 3;
        mSize.setLocation((int)((double)mDpi * mWidth / 2.54), (int)((double)mDpi * mHeight / 2.54));
        mLage = this.rotatedSize(mSize, mJD);
        mSrc = new BufferedImage((int)mLage.getX(), (int)mLage.getY(), 12);
        Graphics2D gMSrc = (Graphics2D)mSrc.getGraphics();
        gMSrc.setColor(Color.WHITE);
        gMSrc.fill(new Rectangle(0, 0, mSrc.getWidth(), mSrc.getHeight()));
        mBmp = new BufferedImage((int)mLage.getX(), (int)mLage.getY(), 12);
        Graphics2D gMBmp = (Graphics2D)mBmp.getGraphics();
        gMBmp.setColor(Color.WHITE);
        gMBmp.fill(new Rectangle(0, 0, mBmp.getWidth(), mBmp.getHeight()));
        int i = 0;
        while (i < mBmp.getHeight()) {
            if (i % ModA < HB_A) {
                int j = 0;
                while (j < mBmp.getWidth()) {
                    if (j % ModB < HB_B) {
                        mBmp.setRGB(j, i, 0);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Point pt = new Point();
        pt.setLocation(4, 4);
        mThis = this.rotatedPoint(pt, 360 - mJD, mSize);
        gMSrc.setClip(0, 0, mSrc.getWidth(), mSrc.getHeight());
        gMSrc.setColor(vFontColor);
        this.writeText(gMSrc, mThis.x, mThis.y, mSize.x - 4, mSize.y - 4, mJD, vText, vFontName, mLage);
        int i2 = 0;
        while (i2 < mSrc.getHeight()) {
            int mx = 0;
            int j = 0;
            while (j < mSrc.getWidth()) {
                if (mSrc.getRGB(j, i2) < -1) {
                    mBmp.setRGB(j, i2, 0xFFFFFF);
                    if ((int)Math.random() * 100 > 40 + vParam1 || mx > vParam2 && i2 % vParam3 == 0) {
                        mBmp.setRGB(j, i2, 0);
                        mx = 1;
                    } else {
                        ++mx;
                    }
                }
                ++j;
            }
            ++i2;
        }
        mSrc = new BufferedImage((int)mLage.getX(), (int)mLage.getY(), 12);
        gMSrc = (Graphics2D)mSrc.getGraphics();
        gMSrc.setColor(Color.BLACK);
        gMSrc.fill(new Rectangle(0, 0, mSrc.getWidth(), mSrc.getHeight()));
        gMSrc.setColor(Color.WHITE);
        int mBjDx = 4;
        int va = 40 * mBjDx;
        int vb = 8 * mBjDx;
        int vc = 16 * mBjDx;
        int vw = 2 * mBjDx;
        int i3 = 1;
        int j = 1;
        BasicStroke stroke = new BasicStroke(vw);
        gMSrc.setStroke(stroke);
        while (i3 < mSrc.getHeight()) {
            j = 1;
            while (j < mSrc.getWidth()) {
                gMSrc.drawRect(i3, j, va, va);
                gMSrc.drawRect(i3 + vb, j + vb, va - 2 * vb, va - 2 * vb);
                gMSrc.drawRect(i3 + vc - mBjDx, j + vc - mBjDx, va - 2 * vc + mBjDx, va - 2 * vc + mBjDx);
                j += va + mBjDx * 2 * 4;
            }
            i3 += va + mBjDx * 2 * 4;
        }
        i3 = 0;
        while (i3 < mSrc.getHeight()) {
            j = 0;
            while (j < mSrc.getWidth()) {
                if (mSrc.getRGB(j, i3) == -1) {
                    mBmp.setRGB(j, i3, 0xFFFFFF);
                }
                ++j;
            }
            ++i3;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        mBmp = this.getRotatedBitmap(mBmp, vJD, mSize);
        ImageIO.write((RenderedImage)mBmp, "bmp", byteArrayOutputStream);
        byte[] imageData = byteArrayOutputStream.toByteArray();
        float fdpi = 23622.547f;
        int dpi = Math.round(fdpi);
        byte[] buff = KGCommonUtils.reverseByteArray(KGCommonUtils.intToByteArray(dpi));
        imageData[38] = buff[0];
        imageData[39] = buff[1];
        imageData[42] = buff[0];
        imageData[43] = buff[1];
        return imageData;
    }

    public BufferedImage createPrintBitmapByTextEx(Integer vJD, String vFText, String vBText, String vSText, String vFontName, Color vFontColor, double vWidth, double vHeight, int vDPI, int vWy) throws IOException {
        int j;
        vDPI = 600;
        BufferedImage mBmp = null;
        BufferedImage mSrc = null;
        int mDpi = 0;
        double mWidth = 0.0;
        double mHeight = 0.0;
        int mJD = 0;
        Point mSize = new Point();
        Point mLage = new Point();
        Point mThis = new Point();
        int ModA = 0;
        int ModB = 0;
        int HB_A = 0;
        int HB_B = 0;
        mDpi = vDPI;
        mWidth = vWidth;
        mHeight = vHeight;
        mJD = vJD % 360;
        if (mDpi == 600) {
            ModA = 6;
            ModB = 3;
        } else {
            ModA = 12;
            ModB = 6;
        }
        HB_A = vWy;
        HB_B = ModB / 2;
        mSize.setLocation((int)((double)mDpi * mWidth / 2.54), (int)((double)mDpi * mHeight / 2.54));
        mLage = this.rotatedSize(mSize, mJD);
        mSrc = new BufferedImage((int)mLage.getX(), (int)mLage.getY(), 5);
        mBmp = new BufferedImage((int)mLage.getX(), (int)mLage.getY(), 5);
        Graphics2D gMBmp = (Graphics2D)mBmp.getGraphics();
        gMBmp.setColor(Color.WHITE);
        gMBmp.fill(new Rectangle(0, 0, mBmp.getWidth(), mBmp.getHeight()));
        Graphics2D gMSrc = (Graphics2D)mSrc.getGraphics();
        gMSrc.setColor(Color.WHITE);
        gMSrc.fill(new Rectangle(0, 0, mSrc.getWidth(), mSrc.getHeight()));
        int i = 0;
        while (i < mBmp.getHeight()) {
            if (i % ModA < HB_A) {
                int j2 = 0;
                while (j2 < mBmp.getWidth()) {
                    if (j2 % ModB < HB_B) {
                        mBmp.setRGB(j2, i, 0);
                    }
                    ++j2;
                }
            }
            ++i;
        }
        Point pt = new Point();
        pt.setLocation(4, 4);
        mThis = this.rotatedPoint(pt, 360 - mJD, mSize);
        gMSrc.setClip(0, 0, mSrc.getWidth(), mSrc.getHeight());
        gMSrc.setColor(vFontColor);
        this.writeText(gMSrc, mThis.x, mThis.y, mSize.x - 4, mSize.y - 4, mJD, vFText, vFontName, mLage);
        int k = ModA / 2;
        int i2 = 0;
        while (i2 < mSrc.getHeight() - k) {
            j = 0;
            while (j < mSrc.getWidth()) {
                if (mSrc.getRGB(j, i2) < -1) {
                    mBmp.setRGB(j, i2, mBmp.getRGB(j, i2 + k));
                }
                ++j;
            }
            ++i2;
        }
        pt = new Point();
        pt.setLocation(6, 6);
        mThis = this.rotatedPoint(pt, 360 - mJD, mSize);
        mSrc = new BufferedImage((int)mLage.getX(), (int)mLage.getY(), 5);
        gMSrc = (Graphics2D)mSrc.getGraphics();
        gMSrc.setColor(Color.WHITE);
        gMSrc.fill(new Rectangle(0, 0, mBmp.getWidth(), mBmp.getHeight()));
        this.writeText(gMSrc, mThis.x, mThis.y, mSize.x - 6, mSize.y - 6, mJD, vBText, vFontName, mLage);
        k = ModB / 2;
        i2 = 0;
        while (i2 < mSrc.getHeight()) {
            j = 0;
            while (j < mSrc.getWidth() - k) {
                if (mSrc.getRGB(j, i2) < -1) {
                    mBmp.setRGB(j, i2, mBmp.getRGB(j + k, i2));
                }
                ++j;
            }
            ++i2;
        }
        mBmp = this.getRotatedBitmap(mBmp, vJD, mSize);
        return mBmp;
    }

    private boolean writeText(Graphics2D g, int x, int y, int width, int height, int rotate, String text, String vFontName, Point mLage) {
        boolean result = false;
        Font baseSizeFont = new Font(vFontName, 1, 10);
        Font varFont = null;
        int fontWidth = (int)((double)width / ((double)text.length() * 0.1 + (double)text.length()));
        int totalTextWidth = 0;
        FontMetrics fontMetrics = null;
        varFont = baseSizeFont.deriveFont(AffineTransform.getScaleInstance((double)fontWidth / 10.0, (double)height / 10.0));
        fontMetrics = g.getFontMetrics(varFont);
        int tempCharWidth = 0;
        int i = 0;
        while (i < text.length()) {
            tempCharWidth = !this.isChinese(text.charAt(i)) ? fontMetrics.charWidth(text.charAt(i)) * 2 - 5 : fontMetrics.charWidth(text.charAt(i));
            totalTextWidth += tempCharWidth;
            ++i;
        }
        int textStart = (width + 4 - totalTextWidth) / 2;
        int varWidth = 0;
        int i2 = 0;
        while (i2 < text.length()) {
            if (!this.isChinese(text.charAt(i2))) {
                if (i2 != 0) {
                    if (!this.isChinese(text.charAt(i2 - 1))) {
                        varFont = baseSizeFont.deriveFont(AffineTransform.getScaleInstance((double)fontWidth / 10.0 * 2.0, (double)height / 10.0));
                        varWidth = varWidth + g.getFontMetrics(varFont).charWidth(text.charAt(i2 - 1)) - 5;
                    } else {
                        varFont = baseSizeFont.deriveFont(AffineTransform.getScaleInstance((double)fontWidth / 10.0, (double)height / 10.0));
                        varWidth += g.getFontMetrics(varFont).charWidth(text.charAt(i2 - 1));
                    }
                }
                varFont = baseSizeFont.deriveFont(AffineTransform.getScaleInstance((double)fontWidth / 10.0 * 2.0, (double)height / 10.0));
            } else {
                if (i2 != 0) {
                    if (!this.isChinese(text.charAt(i2 - 1))) {
                        varFont = baseSizeFont.deriveFont(AffineTransform.getScaleInstance((double)fontWidth / 10.0 * 2.0, (double)height / 10.0));
                        varWidth = varWidth + g.getFontMetrics(varFont).charWidth(text.charAt(i2 - 1)) - 5;
                    } else {
                        varFont = baseSizeFont.deriveFont(AffineTransform.getScaleInstance((double)fontWidth / 10.0, (double)height / 10.0));
                        varWidth += g.getFontMetrics(varFont).charWidth(text.charAt(i2 - 1));
                    }
                }
                varFont = baseSizeFont.deriveFont(AffineTransform.getScaleInstance((double)fontWidth / 10.0, (double)height / 10.0));
            }
            g.setPaintMode();
            double theta = Math.toRadians(rotate);
            AffineTransform at = new AffineTransform();
            at.setToRotation(theta);
            g.setTransform(at);
            g.setFont(varFont);
            fontMetrics = g.getFontMetrics();
            g.setColor(Color.BLACK);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.drawString(text.substring(i2, i2 + 1), textStart + varWidth + height / 2, fontMetrics.getAscent() - fontMetrics.getDescent() - height / 2);
            ++i2;
        }
        g.dispose();
        return result;
    }

    private Point rotatedPoint(Point pt, float Angle, Point Small) {
        Point Prime = new Point();
        Point OrgDst = new Point();
        Point OrgSrc = new Point();
        Point Lage = new Point();
        Point result = new Point();
        float NormalAngle = (Angle / 360.0f - (float)((int)(Angle / 360.0f))) * 360.0f;
        float SinTheta = (float)Math.sin(Math.PI * (double)(-NormalAngle) / 180.0);
        float CosTheta = (float)Math.cos(Math.PI * (double)(-NormalAngle) / 180.0);
        Lage = this.rotatedSize(Small, Angle);
        int tempPointx = (int)(Lage.getX() / 2.0);
        if ((int)Lage.getX() % 2 == 0 && ((double)NormalAngle == 0.0 || (double)NormalAngle == -90.0)) {
            --tempPointx;
        }
        int tempPointy = (int)(Lage.getY() / 2.0);
        if ((int)Lage.getY() % 2 == 0 && ((double)NormalAngle == 0.0 || (double)NormalAngle == 90.0)) {
            --tempPointy;
        }
        OrgDst.setLocation(tempPointx, tempPointy);
        OrgSrc.setLocation((int)(Small.getX() / 2.0), (int)(Small.getY() / 2.0));
        Prime.setLocation(pt.x - OrgSrc.x, pt.y - OrgSrc.y);
        tempPointx = new BigDecimal(String.valueOf((double)((float)Prime.x * CosTheta - (float)Prime.y * SinTheta) + 0.5)).setScale(0, 4).intValue() + OrgDst.x;
        tempPointy = new BigDecimal(String.valueOf((double)((float)Prime.x * SinTheta + (float)Prime.y * CosTheta) + 0.5)).setScale(0, 4).intValue() + OrgDst.y;
        result.setLocation(tempPointx, tempPointy);
        return result;
    }

    private Point rotatedSize(Point bitmap, float Angle) {
        Point result = new Point();
        float NormalAngle = (Angle / 360.0f - (float)((int)(Angle / 360.0f))) * 360.0f;
        float SinTheta = (float)Math.sin(Math.PI * (double)(-NormalAngle) / 180.0);
        float CosTheta = (float)Math.cos(Math.PI * (double)(-NormalAngle) / 180.0);
        int iSinTheta = (int)(SinTheta * 65536.0f);
        int iCosTheta = (int)(CosTheta * 65536.0f);
        int pointx = (int)(bitmap.getX() * (double)Math.abs(iCosTheta) + bitmap.getY() * (double)Math.abs(iSinTheta)) >>> 16;
        int pointy = (int)(bitmap.getX() * (double)Math.abs(iSinTheta) + bitmap.getY() * (double)Math.abs(iCosTheta)) >>> 16;
        result.setLocation(pointx, pointy);
        return result;
    }

    private BufferedImage getRotatedBitmap(BufferedImage bitmap, int Angle, Point BmpSize) {
        BufferedImage result = null;
        result = new BufferedImage((int)BmpSize.getX(), (int)BmpSize.getY(), 12);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setColor(Color.WHITE);
        g.fill(new Rectangle(0, 0, result.getWidth(), result.getHeight()));
        g.dispose();
        float NormalAngle = (int)(((double)Angle / 360.0 - (double)((int)((double)Angle / 360.0))) * 360.0);
        float SinTheta = (float)Math.sin(Math.PI * (double)(-NormalAngle) / 180.0);
        float CosTheta = (float)Math.cos(Math.PI * (double)(-NormalAngle) / 180.0);
        int iSinTheta = (int)(SinTheta * 65536.0f);
        int iCosTheta = (int)(CosTheta * 65536.0f);
        int srcWidth = (int)BmpSize.getX();
        int srcHeight = (int)BmpSize.getY();
        int xOSrc = srcWidth >>> 1;
        int yOSrc = srcHeight >>> 1;
        int dstWidth = srcWidth * Math.abs(iCosTheta) + srcHeight * Math.abs(iSinTheta) >>> 16;
        int dstHeight = srcWidth * Math.abs(iSinTheta) + srcHeight * Math.abs(iCosTheta) >>> 16;
        int xODst = dstWidth >>> 1;
        if (dstWidth % 2 == 0 && ((double)NormalAngle == 0.0 || (double)NormalAngle == -90.0)) {
            --xODst;
        }
        int yODst = dstHeight >>> 1;
        if (dstHeight % 2 == 0 && ((double)NormalAngle == 0.0 || (double)NormalAngle == 90.0)) {
            --yODst;
        }
        int yPrime = yODst;
        int yDst = dstHeight - 1;
        while (yDst >= 0) {
            int yPrimeSinTheta = yPrime * iSinTheta;
            int yPrimeCosTheta = yPrime * iCosTheta;
            int xPrime = xODst;
            int xDst = dstWidth - 1;
            while (xDst >= 0) {
                int xSrc = (short)(xPrime * iCosTheta - yPrimeSinTheta >>> 16) + xOSrc;
                int ySrc = (short)(xPrime * iSinTheta + yPrimeCosTheta >>> 16) + yOSrc;
                if (ySrc >= 0 && ySrc < srcHeight && xSrc >= 0 && xSrc < srcWidth) {
                    result.setRGB(xSrc, ySrc, bitmap.getRGB(xDst, yDst));
                }
                --xPrime;
                --xDst;
            }
            --yPrime;
            --yDst;
        }
        return result;
    }

    private boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }
}

