/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import com.kinggrid.commons.KGCommonUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import javax.imageio.ImageIO;

public class NewAntiCopyImage {
    private static boolean debug = false;
    private static String path = "d:/tmp/";

    public byte[] createCopyBitmapByTextEx(Integer angle, String text, int vParam1, int vParam2, int vParam3, String fontName, Color fontColor, double width, double height, int dpi, int l, int h) throws IOException {
        int newAngle = angle % 360;
        Point size = new Point();
        size.setLocation((int)((double)dpi * width / 2.54), (int)((double)dpi * height / 2.54));
        Point rotateSize = new Point();
        rotateSize = this.rotatedSize(size, newAngle);
        BufferedImage src = new BufferedImage((int)rotateSize.getX(), (int)rotateSize.getY(), 12);
        Graphics2D g2dsrc = (Graphics2D)src.getGraphics();
        g2dsrc.setColor(Color.WHITE);
        g2dsrc.fill(new Rectangle(0, 0, src.getWidth(), src.getHeight()));
        Point pt = new Point();
        pt.setLocation(4, 4);
        Point mThis = this.rotatedPoint(pt, 360 - newAngle, size, rotateSize);
        g2dsrc.setColor(fontColor);
        this.writeText(g2dsrc, mThis.x, mThis.y, size.x - 4, size.y - 4, newAngle, text, fontName, rotateSize);
        if (debug) {
            ImageIO.write((RenderedImage)src, "BMP", new File(String.valueOf(path) + "1.bmp"));
        }
        BufferedImage bmp = new BufferedImage((int)rotateSize.getX(), (int)rotateSize.getY(), 12);
        Graphics2D g2dbmp = (Graphics2D)bmp.getGraphics();
        g2dbmp.setColor(Color.WHITE);
        g2dbmp.fill(new Rectangle(0, 0, bmp.getWidth(), bmp.getHeight()));
        int ModA = l;
        int HB_A = h;
        int ModB = l;
        int HB_B = h;
        int i = 0;
        while (i < bmp.getHeight()) {
            if (i % ModA < HB_A) {
                int j = 0;
                while (j < bmp.getWidth()) {
                    if (j % ModB < HB_B) {
                        bmp.setRGB(j, i, 0);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (debug) {
            ImageIO.write((RenderedImage)bmp, "BMP", new File(String.valueOf(path) + "2.bmp"));
        }
        i = 0;
        while (i < src.getHeight()) {
            int mx = 0;
            int j = 0;
            while (j < src.getWidth()) {
                if (src.getRGB(j, i) < -1) {
                    bmp.setRGB(j, i, 0xFFFFFF);
                    if (Math.random() * 100.0 > (double)vParam1 || mx > vParam2 && i % vParam3 == 0) {
                        bmp.setRGB(j, i, 0);
                        mx = 1;
                    } else {
                        ++mx;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (debug) {
            ImageIO.write((RenderedImage)bmp, "BMP", new File(String.valueOf(path) + "3.bmp"));
        }
        src = new BufferedImage((int)rotateSize.getX(), (int)rotateSize.getY(), 12);
        g2dsrc = (Graphics2D)src.getGraphics();
        g2dsrc.setColor(Color.BLACK);
        g2dsrc.fill(new Rectangle(0, 0, src.getWidth(), src.getHeight()));
        g2dsrc.setColor(Color.WHITE);
        int mBjDx = 4;
        int va = 40 * mBjDx;
        int vb = 8 * mBjDx;
        int vc = 16 * mBjDx;
        int vw = 2 * mBjDx;
        int i2 = 1;
        int j = 1;
        BasicStroke stroke = new BasicStroke(vw);
        g2dsrc.setStroke(stroke);
        while (i2 < src.getHeight()) {
            j = 1;
            while (j < src.getWidth()) {
                g2dsrc.drawRect(i2, j, va, va);
                g2dsrc.drawRect(i2 + vb, j + vb, va - 2 * vb, va - 2 * vb);
                g2dsrc.drawRect(i2 + vc - mBjDx, j + vc - mBjDx, va - 2 * vc + mBjDx, va - 2 * vc + mBjDx);
                j += va + mBjDx * 2 * 4;
            }
            i2 += va + mBjDx * 2 * 4;
        }
        i2 = 0;
        while (i2 < src.getHeight()) {
            j = 0;
            while (j < src.getWidth()) {
                if (src.getRGB(j, i2) == -1) {
                    bmp.setRGB(j, i2, 0xFFFFFF);
                }
                ++j;
            }
            ++i2;
        }
        if (debug) {
            ImageIO.write((RenderedImage)bmp, "BMP", new File(String.valueOf(path) + "4.bmp"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bmp = this.getRotatedBitmap(bmp, newAngle, size);
        ImageIO.write((RenderedImage)bmp, "bmp", byteArrayOutputStream);
        byte[] imageData = byteArrayOutputStream.toByteArray();
        float fdpi = 23622.047f;
        int idpi = Math.round(fdpi);
        byte[] buff = KGCommonUtils.reverseByteArray(KGCommonUtils.intToByteArray(idpi));
        imageData[38] = buff[0];
        imageData[39] = buff[1];
        imageData[42] = buff[0];
        imageData[43] = buff[1];
        if (debug) {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(String.valueOf(path) + "5.bmp"));
            fileOutputStream.write(imageData);
            fileOutputStream.close();
        }
        return imageData;
    }

    public BufferedImage createPrintBitmapByText(Integer angle, String text, String vBText, String vSText, String fontName, Color fontColor, double width, double height, int vDPI, int accuracy) throws IOException {
        int j;
        int dpi = 600;
        int newAngle = angle % 360;
        Point size = new Point();
        Point rotateSize = new Point();
        size.setLocation((int)((double)dpi * width / 2.54), (int)((double)dpi * height / 2.54));
        rotateSize = this.rotatedSize(size, newAngle);
        BufferedImage src = new BufferedImage((int)rotateSize.getX(), (int)rotateSize.getY(), 5);
        BufferedImage bmp = new BufferedImage((int)rotateSize.getX(), (int)rotateSize.getY(), 5);
        Graphics2D gMBmp = (Graphics2D)bmp.getGraphics();
        gMBmp.setColor(Color.WHITE);
        gMBmp.fill(new Rectangle(0, 0, bmp.getWidth(), bmp.getHeight()));
        Graphics2D gMSrc = (Graphics2D)src.getGraphics();
        gMSrc.setColor(Color.WHITE);
        gMSrc.fill(new Rectangle(0, 0, src.getWidth(), src.getHeight()));
        int ModA = 6;
        int ModB = 6;
        int HB_A = accuracy;
        int HB_B = ModB / 2;
        int i = 0;
        while (i < bmp.getHeight()) {
            if (i % ModA < HB_A) {
                int j2 = 0;
                while (j2 < bmp.getWidth()) {
                    if (j2 % ModB < HB_B) {
                        bmp.setRGB(j2, i, 0);
                    }
                    ++j2;
                }
            }
            ++i;
        }
        if (debug) {
            ImageIO.write((RenderedImage)bmp, "BMP", new File(String.valueOf(path) + "optic1.bmp"));
        }
        Point pt = new Point();
        pt.setLocation(4, 4);
        Point mThis = new Point();
        mThis = this.rotatedPoint(pt, 360 - newAngle, size, rotateSize);
        gMSrc.setClip(0, 0, src.getWidth(), src.getHeight());
        gMSrc.setColor(fontColor);
        this.writeText(gMSrc, mThis.x, mThis.y, size.x - 4, size.y - 4, newAngle, text, fontName, rotateSize);
        if (debug) {
            ImageIO.write((RenderedImage)src, "BMP", new File(String.valueOf(path) + "optic2.bmp"));
        }
        int k = ModA / 2;
        int i2 = 0;
        while (i2 < src.getHeight() - k) {
            j = 0;
            while (j < src.getWidth()) {
                if (src.getRGB(j, i2) < -1) {
                    bmp.setRGB(j, i2, bmp.getRGB(j, i2 + k));
                }
                ++j;
            }
            ++i2;
        }
        if (debug) {
            ImageIO.write((RenderedImage)bmp, "BMP", new File(String.valueOf(path) + "optic3.bmp"));
        }
        pt.setLocation(6, 6);
        mThis = this.rotatedPoint(pt, 360 - newAngle, size, rotateSize);
        src = new BufferedImage((int)rotateSize.getX(), (int)rotateSize.getY(), 5);
        gMSrc = (Graphics2D)src.getGraphics();
        gMSrc.setColor(Color.WHITE);
        gMSrc.fill(new Rectangle(0, 0, bmp.getWidth(), bmp.getHeight()));
        gMSrc.setColor(fontColor);
        this.writeText(gMSrc, mThis.x, mThis.y, size.x - 6, size.y - 6, newAngle, vBText, fontName, rotateSize);
        if (debug) {
            ImageIO.write((RenderedImage)src, "BMP", new File(String.valueOf(path) + "optic4.bmp"));
        }
        k = ModB / 2;
        i2 = 0;
        while (i2 < src.getHeight()) {
            j = 0;
            while (j < src.getWidth() - k) {
                if (src.getRGB(j, i2) < -1) {
                    bmp.setRGB(j, i2, bmp.getRGB(j + k, i2));
                }
                ++j;
            }
            ++i2;
        }
        if (debug) {
            ImageIO.write((RenderedImage)bmp, "BMP", new File(String.valueOf(path) + "optic5.bmp"));
        }
        bmp = this.getRotatedBitmap(bmp, newAngle, size);
        if (debug) {
            ImageIO.write((RenderedImage)bmp, "BMP", new File(String.valueOf(path) + "optic6.bmp"));
        }
        return bmp;
    }

    private Point rotatedSize(Point bitmap, int angle) {
        Point point = new Point();
        if (angle == 90 || angle == 270) {
            point.setLocation(bitmap.getY(), bitmap.getX());
        } else {
            double sin = Math.abs(Math.sin(Math.PI * (double)angle / 180.0));
            double cos = Math.abs(Math.cos(Math.PI * (double)angle / 180.0));
            int x = (int)(cos * bitmap.getX() + sin * bitmap.getY());
            int y = (int)(sin * bitmap.getX() + cos * bitmap.getY());
            point.setLocation(x, y);
        }
        return point;
    }

    private Point rotatedPoint(Point pt, int angle, Point size, Point rotateSize) {
        int tempPointx = (int)(rotateSize.getX() / 2.0);
        int tempPointy = (int)(rotateSize.getY() / 2.0);
        if (angle != 0 && angle != 90) {
            if ((int)rotateSize.getX() % 2 == 0) {
                --tempPointx;
            }
            if ((int)rotateSize.getY() % 2 == 0) {
                --tempPointx;
            }
        }
        double x = (double)pt.x - size.getX() / 2.0;
        double y = (double)pt.y - size.getY() / 2.0;
        double sin = Math.sin(Math.PI * (double)(-angle) / 180.0);
        double cos = Math.cos(Math.PI * (double)(-angle) / 180.0);
        BigDecimal bigDecimalX = new BigDecimal(String.valueOf(x * cos - y * sin + 0.5));
        tempPointx = bigDecimalX.setScale(0, 4).intValue() + tempPointx;
        BigDecimal bigDecimalY = new BigDecimal(String.valueOf(x * sin + y * cos + 0.5));
        tempPointy = bigDecimalY.setScale(0, 4).intValue() + tempPointy;
        Point result = new Point();
        result.setLocation(tempPointx, tempPointy);
        return result;
    }

    private void writeText(Graphics2D g2D, int x, int y, int width, int height, int rotate, String text, String fontName, Point rotateSize) {
        float fontSize = 10.0f;
        Font baseSizeFont = new Font(fontName, 1, (int)fontSize);
        int fontWidth = (int)((float)width / ((float)text.length() * 0.1f + (float)text.length()));
        Font font = baseSizeFont.deriveFont(AffineTransform.getScaleInstance((float)fontWidth / fontSize, (float)height / fontSize));
        FontMetrics fontMetrics = g2D.getFontMetrics(font);
        int totalTextWidth = 0;
        int i = 0;
        while (i < text.length()) {
            totalTextWidth = !this.isChinese(text.charAt(i)) ? (totalTextWidth += fontMetrics.charWidth(text.charAt(i)) * 2 - 5) : (totalTextWidth += fontMetrics.charWidth(text.charAt(i)));
            ++i;
        }
        Font scalefont = baseSizeFont.deriveFont(AffineTransform.getScaleInstance((float)fontWidth / fontSize * 2.0f, (float)height / fontSize));
        FontMetrics scaleFontMetrics = g2D.getFontMetrics(scalefont);
        int textStart = (width + 4 - totalTextWidth) / 2;
        int varWidth = 0;
        int i2 = 0;
        while (i2 < text.length()) {
            Font mfont = null;
            if (i2 == 0) {
                mfont = this.isChinese(text.charAt(i2)) ? font : scalefont;
            } else if (!this.isChinese(text.charAt(i2))) {
                if (!this.isChinese(text.charAt(i2 - 1))) {
                    varWidth += scaleFontMetrics.charWidth(text.charAt(i2 - 1)) - 5;
                    mfont = scalefont;
                } else {
                    varWidth += fontMetrics.charWidth(text.charAt(i2 - 1));
                    mfont = font;
                }
            } else if (!this.isChinese(text.charAt(i2 - 1))) {
                varWidth += scaleFontMetrics.charWidth(text.charAt(i2 - 1)) - 5;
                mfont = scalefont;
            } else {
                varWidth += fontMetrics.charWidth(text.charAt(i2 - 1));
                mfont = font;
            }
            g2D.setPaintMode();
            AffineTransform at = new AffineTransform();
            at.setToRotation(Math.toRadians(rotate));
            g2D.setTransform(at);
            g2D.setFont(mfont);
            fontMetrics = g2D.getFontMetrics();
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawString(text.substring(i2, i2 + 1), textStart + varWidth + height / 2, fontMetrics.getAscent() - fontMetrics.getDescent() - height / 2);
            ++i2;
        }
        g2D.dispose();
    }

    private boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    private BufferedImage getRotatedBitmap(BufferedImage bitmap, int angle, Point BmpSize) {
        BufferedImage result = new BufferedImage((int)BmpSize.getX(), (int)BmpSize.getY(), 12);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setColor(Color.WHITE);
        g.fill(new Rectangle(0, 0, result.getWidth(), result.getHeight()));
        g.dispose();
        float SinTheta = (float)Math.sin(Math.PI * (double)(-angle) / 180.0);
        float CosTheta = (float)Math.cos(Math.PI * (double)(-angle) / 180.0);
        int iSinTheta = (int)(SinTheta * 65536.0f);
        int iCosTheta = (int)(CosTheta * 65536.0f);
        int srcWidth = (int)BmpSize.getX();
        int srcHeight = (int)BmpSize.getY();
        int xOSrc = srcWidth / 2;
        int yOSrc = srcHeight / 2;
        int dstWidth = srcWidth * Math.abs(iCosTheta) + srcHeight * Math.abs(iSinTheta) >>> 16;
        int dstHeight = srcWidth * Math.abs(iSinTheta) + srcHeight * Math.abs(iCosTheta) >>> 16;
        int xODst = dstWidth >>> 1;
        int yODst = dstHeight >>> 1;
        if (dstWidth % 2 == 0 && ((double)angle == 0.0 || (double)angle == -90.0)) {
            --xODst;
        }
        if (dstHeight % 2 == 0 && ((double)angle == 0.0 || (double)angle == 90.0)) {
            --yODst;
        }
        int yPrime = yODst;
        int yDst = dstHeight - 1;
        while (yDst >= 0) {
            int yPrimeSinTheta = yPrime * iSinTheta;
            int yPrimeCosTheta = yPrime * iCosTheta;
            int xPrime = xODst;
            int xDst = dstWidth - 1;
            while (xDst >= 0) {
                int xSrc = (short)(xPrime * iCosTheta - yPrimeSinTheta >>> 16) + xOSrc;
                int ySrc = (short)(xPrime * iSinTheta + yPrimeCosTheta >>> 16) + yOSrc;
                if (ySrc >= 0 && ySrc < srcHeight && xSrc >= 0 && xSrc < srcWidth) {
                    result.setRGB(xSrc, ySrc, bitmap.getRGB(xDst, yDst));
                }
                --xPrime;
                --xDst;
            }
            --yPrime;
            --yDst;
        }
        return result;
    }
}

