/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfBoolean;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.executes.electronicseal.KGDefaultMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGMessageDigest;
import com.kinggrid.pdf.utils.HashPDFDoc10;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGPdfUtils {
    public static byte[] calculatePdfHash4Elec(PdfReader reader) {
        return KGPdfUtils.calculatePdfHash4Elec(reader, new KGDefaultMessageDigest());
    }

    public static byte[] calculatePdfHash4Elec(PdfReader reader, KGMessageDigest messageDigest) {
        try {
            String createTime = null;
            int k = 1;
            while (k <= reader.getNumberOfPages()) {
                PdfArray annots;
                PdfDictionary pdfDictionary = reader.getPageN(k);
                PdfObject pdfObject = pdfDictionary.get(PdfName.CONTENTS);
                byte[] content = null;
                if (pdfObject instanceof PdfArray) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PdfArray arrays = (PdfArray)pdfObject;
                    int i = 0;
                    while (i < arrays.size()) {
                        byte[] cont = PdfReader.getStreamBytesRaw((PRStream)arrays.getAsStream(i));
                        if (cont != null) {
                            out.write(cont);
                        }
                        ++i;
                    }
                    content = out.toByteArray();
                } else {
                    content = PdfReader.getStreamBytesRaw((PRStream)pdfDictionary.getAsStream(PdfName.CONTENTS));
                }
                if (content != null) {
                    messageDigest.update(content);
                }
                if ((annots = reader.getPageN(k).getAsArray(PdfName.ANNOTS)) != null) {
                    int j = 0;
                    while (j < annots.size()) {
                        PdfName subtype;
                        PdfName ft;
                        PdfDictionary annot = annots.getAsDict(j);
                        if (!(annot == null || (ft = annot.getAsName(PdfName.FT)) != null && ft.equals(PdfName.SIG) || (subtype = annot.getAsName(PdfName.SUBTYPE)) != null && KGElectronicSealName.SEAL.equals(subtype))) {
                            String s1;
                            PdfString modifTime = annot.getAsString(PdfName.M);
                            if (modifTime != null) {
                                createTime = modifTime.toString();
                            }
                            if (createTime != null) {
                                Integer y = Integer.valueOf(createTime.substring(2, 6));
                                Integer m = Integer.valueOf(createTime.substring(6, 8));
                                Integer h = Integer.valueOf(createTime.substring(10, 12));
                                Integer nin = Integer.valueOf(createTime.substring(12, 14));
                                Integer sec = Integer.valueOf(createTime.substring(14, 16));
                                s1 = String.valueOf(y.toString()) + "-" + m.toString() + "-0 " + h.toString() + ":" + nin.toString() + ":" + sec.toString() + ":0\r\n";
                            } else {
                                s1 = "Error\r\n";
                            }
                            messageDigest.update(s1.getBytes("GBK"));
                        }
                        ++j;
                    }
                }
                ++k;
            }
            return messageDigest.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String calculatePdfDoc104Elec(PdfReader reader) {
        return KGPdfUtils.calculatePdfDoc104Elec(reader, new KGDefaultMessageDigest());
    }

    public static String calculatePdfDoc104Elec(PdfReader reader, KGMessageDigest messageDigest) {
        try {
            return HashPDFDoc10.getHash(reader, messageDigest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] calculatePdfDoc104ElecByte(PdfReader reader, KGMessageDigest messageDigest) {
        try {
            return HashPDFDoc10.getHashByte(reader, messageDigest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> parseSeal(PdfDictionary annot) throws IOException {
        Map<String, String> map = null;
        PdfDictionary info = annot.getAsDict(PdfName.INFO);
        if (info != null) {
            PdfNumber proversion = info.getAsNumber(KGElectronicSealName.PROVERSION);
            PdfBoolean unicode = info.getAsBoolean(KGElectronicSealName.UNICODE);
            PdfNumber hashType = info.getAsNumber(KGElectronicSealName.HASH_TYPE);
            boolean isUnicode = false;
            if (unicode != null) {
                isUnicode = unicode.booleanValue();
            }
            String charSet = "GBK";
            if (isUnicode) {
                charSet = "UTF-16LE";
            }
            PRStream baseInfo = (PRStream)info.getAsStream(KGElectronicSealName.BASEINFO);
            byte[] baseInfob = PdfReader.getStreamBytes(baseInfo);
            KGBase64 base64 = new KGBase64();
            base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
            String sealDetail = new String(base64.decode(new String(baseInfob)), charSet);
            map = KGPdfUtils.getBaseInfo(sealDetail);
            map.put("proversion", String.valueOf(proversion.intValue()));
            if (hashType != null) {
                map.put("hashType", String.valueOf(hashType.intValue()));
            }
        }
        return map;
    }

    public static Map<String, String> getBaseInfo(String string) {
        String[] strings;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = strings = string.split("\r\n");
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            int indx = str.indexOf("=");
            if (indx != -1) {
                map.put(str.substring(0, indx), str.substring(indx + 1));
            }
            ++n2;
        }
        return map;
    }

    public static Map<String, Float> RotationXY(float x, float y, float width, float height, int rotation) {
        float tmp = x;
        if (rotation == 90) {
            x = y;
            y = width - tmp;
        } else if (rotation == 180) {
            x = width - x;
            y = height - y;
        } else if (rotation == 270) {
            x = height - y;
            y = tmp;
        }
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("x", Float.valueOf(x));
        map.put("y", Float.valueOf(y));
        return map;
    }
}

