/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.signinter;

import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.pdf.signinter.DigitalSignature;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;

public class DigitalSignatureByServer
implements DigitalSignature {
    private static final String DEFAULT_ENCRYPTIONALGORITHM = "RSA";
    private static final String DEFAULT_HASHALGORITHM = "SHA-1";
    private String encryptionAlgorithm = "RSA";
    private String hashAlgorithm = "SHA-1";
    private String url;
    private String keySN;
    private KGHttpUtils httpUtils = new KGHttpUtils();

    public DigitalSignatureByServer(String url, String keySN) {
        this.url = url;
        this.keySN = keySN;
    }

    public byte[] sign(byte[] message) throws GeneralSecurityException {
        Map<String, Object> map;
        try {
            map = this.httpUtils.sign(this.url, this.keySN, message);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        return (byte[])map.get("signData");
    }

    public X509Certificate[] getCertificate() {
        Map<String, Object> map;
        try {
            map = this.httpUtils.sign(this.url, this.keySN, null);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        return new X509Certificate[]{(X509Certificate)map.get("certificate")};
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }
}

