/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.exporter;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.Chunk;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Font;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Paragraph;
import com.KGitextpdf.text.Phrase;
import com.KGitextpdf.text.pdf.FontSelector;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.exporter.KGElement;
import com.kinggrid.pdf.exporter.KGPdfExporter;
import java.io.File;
import java.io.IOException;

public class KGChunk
extends KGElement {
    private String fontName;
    private float fontSize = 13.0f;
    private String fontWeight;
    private String fontColor;
    private boolean underLine;
    private String underLineColor = "000000";
    private String text;
    private float textRise;
    private float lineHeight = -1.0f;
    private String background;
    private String imagePath;
    private int imgWidth = -1;
    private int imgHeight = -1;
    private int offsetX = 0;
    private int offsetY = 0;
    private KGPdfExporter pdfExporter;

    public KGChunk(KGPdfExporter pdfExporter) {
        this.pdfExporter = pdfExporter;
    }

    @Deprecated
    public Phrase build() throws DocumentException, IOException {
        Phrase phrase = null;
        this.setGlobalFontName(this.pdfExporter.getFontName());
        Font font = this.getFont(this.fontName, this.fontSize, this.fontColor, this.fontWeight);
        if (this.underLine) {
            phrase = new Paragraph();
            Chunk chunk = new Chunk(this.text, font);
            BaseColor baseColor = new BaseColor(Integer.parseInt(this.underLineColor, 16));
            chunk.setUnderline(baseColor, 0.05f, 0.0f, 0.0f, -0.2f, 0);
            phrase.add(chunk);
        } else {
            FontSelector fontSelector = new FontSelector();
            fontSelector.addFont(font);
            phrase = fontSelector.process(this.formatText(this.text));
        }
        return phrase;
    }

    public Chunk build2() throws DocumentException, IOException {
        Chunk chunk = null;
        if (this.imagePath != null) {
            Image image = null;
            if (this.imagePath.startsWith("data:")) {
                KGBase64 base64 = new KGBase64();
                image = Image.getInstance(base64.decode(this.imagePath.substring(5)));
            } else {
                File file = new File(this.imagePath);
                if (file.exists()) {
                    image = Image.getInstance(this.imagePath);
                }
            }
            if (image == null) {
                throw new RuntimeException("\u56fe\u7247\u8def\u5f84\u6216\u8005\u6570\u636e\u6709\u95ee\u9898\uff1aimagePath=" + this.imagePath);
            }
            if (this.imgWidth != -1 && this.imgHeight != -1) {
                image.scaleToFit(this.imgWidth, this.imgHeight);
            }
            chunk = new Chunk(image, (float)this.offsetX, this.offsetY);
            chunk.setLineHeight(100.0f);
        } else {
            BaseColor baseColor;
            this.setGlobalFontName(this.pdfExporter.getFontName());
            Font font = this.getFont(this.fontName, this.fontSize, this.fontColor, this.fontWeight);
            chunk = new Chunk(this.formatText(this.text), font);
            chunk.setTextRise(this.textRise);
            if (this.lineHeight != -1.0f) {
                chunk.setLineHeight(this.lineHeight);
            } else {
                chunk.setLineHeight(this.fontSize + 3.0f);
            }
            if (this.underLine) {
                baseColor = new BaseColor(Integer.parseInt(this.underLineColor, 16));
                chunk.setUnderline(baseColor, 0.05f, 0.0f, 0.0f, -0.2f, 0);
            }
            if (this.background != null && this.background.length() > 0) {
                baseColor = new BaseColor(Integer.parseInt(this.background, 16));
                chunk.setBackground(baseColor);
            }
        }
        return chunk;
    }

    public boolean isUnderLine() {
        return this.underLine;
    }

    public void setUnderLine(boolean underLine) {
        this.underLine = underLine;
    }

    public String getUnderLineColor() {
        return this.underLineColor;
    }

    public void setUnderLineColor(String underLineColor) {
        this.underLineColor = underLineColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public float getTextRise() {
        return this.textRise;
    }

    public void setTextRise(float textRise) {
        this.textRise = textRise;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public int getImgWidth() {
        return this.imgWidth;
    }

    public void setImgWidth(int imgWidth) {
        this.imgWidth = imgWidth;
    }

    public int getImgHeight() {
        return this.imgHeight;
    }

    public void setImgHeight(int imgHeight) {
        this.imgHeight = imgHeight;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }
}

