/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.exporter;

import com.KGitextpdf.text.Document;
import com.KGitextpdf.text.Font;
import com.KGitextpdf.text.pdf.PdfDocument;
import com.KGitextpdf.text.pdf.PdfPageEventHelper;
import com.KGitextpdf.text.pdf.PdfTemplate;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.kinggrid.pdf.exporter.KGPdfExporter;
import org.dom4j.Element;

public class HeaderFooter
extends PdfPageEventHelper {
    private Element header;
    private Element footer;
    private PdfTemplate totalPage;
    private Font font;
    private KGPdfExporter pdfExporter;

    public HeaderFooter(Element header, Element footer, KGPdfExporter pdfExporter) {
        this.header = header;
        this.footer = footer;
        this.pdfExporter = pdfExporter;
    }

    public void onStartPage(PdfWriter writer, Document document) {
        block5: {
            PdfDocument pdfDocument = (PdfDocument)document;
            PdfDocument.Indentation indentation = pdfDocument.getIndentation();
            pdfDocument.setIndentation(new PdfDocument.Indentation());
            try {
                if (this.header == null) break block5;
                try {
                    this.pdfExporter.addElements(document, writer, this.header.elements());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                pdfDocument.setIndentation(indentation);
            }
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        block5: {
            PdfDocument pdfDocument = (PdfDocument)document;
            float bottomMargin = pdfDocument.bottomMargin();
            float pageHeight = pdfDocument.getPageSize().getHeight();
            PdfDocument.Indentation indentation = pdfDocument.getIndentation();
            pdfDocument.setCurrentHeight(pageHeight - bottomMargin);
            pdfDocument.allowNewpage = false;
            pdfDocument.setIndentation(new PdfDocument.Indentation());
            try {
                if (this.footer == null) break block5;
                try {
                    this.pdfExporter.addElements(document, writer, this.footer.elements());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                pdfDocument.allowNewpage = true;
                pdfDocument.setIndentation(indentation);
            }
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        if (this.totalPage != null) {
            this.totalPage.beginText();
            this.totalPage.setFontAndSize(this.font.getBaseFont(), this.font.getSize());
            if (this.font.getColor() != null) {
                this.totalPage.setColorFill(this.font.getColor());
            }
            this.totalPage.showTextAligned(1, String.valueOf(writer.getPageNumber() - 1), 5.0f, 0.0f, 0.0f);
            this.totalPage.endText();
        }
    }

    public PdfTemplate getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(PdfTemplate totalPage) {
        this.totalPage = totalPage;
    }

    protected Font getFont() {
        return this.font;
    }

    protected void setFont(Font font) {
        this.font = font;
    }
}

