/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature.customize;

import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfFormField;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.executes.signature.KGPdfSignaureExecute;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Date;

public class ExtraSignaturePKS7
extends KGPdfSignaureExecute {
    private byte[] encodedSig = null;
    private byte[] certBytes = null;

    public void execute(PdfStamper pdfStamper, PdfFormField sigField, int pagen) {
        try {
            PdfWriter writer = pdfStamper.getWriter();
            PdfDictionary sealSig = new PdfDictionary();
            if (this.encodedSig != null) {
                PdfNumber signedNumber = new PdfNumber(this.encodedSig.length);
                PdfIndirectObject signedNumberIndObj = writer.addToBody(signedNumber);
                PdfStream certSignMsg6 = new PdfStream(this.encodedSig);
                certSignMsg6.put(KGElectronicSealName.STRLEN, signedNumberIndObj.getIndirectReference());
                PdfIndirectObject certSignMsg6Ref = writer.addToBody(certSignMsg6);
                sealSig.put(new PdfName("certSignMsg6"), certSignMsg6Ref.getIndirectReference());
            }
            if (this.certBytes != null) {
                PdfNumber number = new PdfNumber(this.certBytes.length);
                PdfIndirectObject indObj = writer.addToBody(number);
                PdfStream certContext = new PdfStream(this.certBytes);
                certContext.put(KGElectronicSealName.STRLEN, indObj.getIndirectReference());
                PdfIndirectObject certContextRef = writer.addToBody(certContext);
                sealSig.put(new PdfName("certContext"), certContextRef.getIndirectReference());
            }
            sealSig.put(new PdfName("signTime"), new PdfString(KGDateUtils.dateTime(new Date())));
            PdfName kgName = new PdfName("KG");
            PdfDictionary kg = sigField.getAsDict(kgName);
            if (kg == null) {
                kg = new PdfDictionary();
                sigField.put(new PdfName("KG"), kg);
            }
            kg.put(new PdfName("sealSig"), sealSig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setEncodedSig(byte[] encodedSig) {
        if (encodedSig == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff08encodedSig\uff09.");
        }
        try {
            KGBase64 base64 = new KGBase64();
            this.encodedSig = base64.encode(encodedSig).getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCert(Certificate cert) throws CertificateEncodingException {
        this.certBytes = cert.getEncoded();
    }
}

