/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature;

import com.KGitextpdf.text.pdf.PdfFormField;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.pdf.executes.signature.KGPdfSignaureExecute;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class KGPdfSignatureAndSM2
extends KGPdfSignaureExecute {
    private static final PdfName KGXML = new PdfName("KGXML");
    private String sigData;
    private String sigCert;
    private String length;
    private String keysn;

    public static String getSM3Digest(String fileName) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileName);
            String string = KGPdfSignatureAndSM2.getSM3Digest(fileInputStream);
            return string;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static String getSM3Digest(InputStream in) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        JSONObject obj = new JSONObject();
        Security.addProvider((Provider)new BouncyCastleProvider());
        MessageDigest messageDigest = MessageDigest.getInstance("SM3", "BC");
        int len = -1;
        int length = 0;
        byte[] buff = new byte[4096];
        while ((len = in.read(buff)) != -1) {
            length += len;
            messageDigest.update(buff, 0, len);
        }
        byte[] digest = messageDigest.digest();
        obj.put("digest", (Object)new String(Hex.encode((byte[])digest)));
        obj.put("length", (Object)length);
        return obj.toJSONString();
    }

    public void execute(PdfStamper pdfStamper, PdfFormField sigField, int pagen) {
        StringBuilder builder = new StringBuilder();
        builder.append("SM2Sig:").append(this.sigData).append(";").append("SM2Cert:").append(this.sigCert).append(";").append("Length:").append(this.length).append(";").append("SM2Type:0;").append("Ver:1.0;").append("KeySn:").append(this.keysn).append(";");
        sigField.put(KGXML, new PdfString(builder.toString()));
    }

    public String getSigData() {
        return this.sigData;
    }

    public void setSigData(String sigData) {
        this.sigData = sigData;
    }

    public String getSigCert() {
        return this.sigCert;
    }

    public void setSigCert(String sigCert) {
        this.sigCert = sigCert;
    }

    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public String getKeysn() {
        return this.keysn;
    }

    public void setKeysn(String keysn) {
        this.keysn = keysn;
    }
}

