/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.postil;

import com.KGitextpdf.awt.geom.AffineTransform;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.PdfTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.executes.postil.KGPostil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfPostil
extends KGExecute {
    private List<String> postilArray = null;
    private Map<Integer, List<KGPostil>> pagePostils = new HashMap<Integer, List<KGPostil>>();

    public void setPostilArray(List<String> postilArray) {
        this.postilArray = postilArray;
    }

    public List<String> getPostilArray() {
        return this.postilArray;
    }

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        if (this.postilArray == null) {
            return;
        }
        for (String str : this.postilArray) {
            JSONArray postils = (JSONArray)JSON.parse((String)str);
            int i = 0;
            while (i < postils.size()) {
                JSONObject object = postils.getJSONObject(i);
                KGPostil kgPostil = (KGPostil)JSON.parseObject((String)object.toJSONString(), KGPostil.class);
                int pageNo = kgPostil.getPageNo();
                List<KGPostil> list = this.pagePostils.get(pageNo);
                if (list == null) {
                    list = new ArrayList<KGPostil>();
                    this.pagePostils.put(pageNo, list);
                }
                list.add(kgPostil);
                ++i;
            }
        }
    }

    @Override
    protected void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        List<KGPostil> postils = this.pagePostils.get(pagen);
        if (postils == null) {
            return;
        }
        int rotation = pdfReader.getPageRotation(pagen);
        PdfDictionary page = pdfReader.getPageN(pagen);
        page.put(PdfName.ROTATE, new PdfNumber(0));
        Rectangle pageSize = pdfReader.getPageSize(pagen);
        for (KGPostil kgPostil : postils) {
            Rectangle rect;
            PdfAnnotation pdfAnnotation = null;
            String date = kgPostil.getCreateTime().replaceAll("-", "").replaceAll(":", "").replaceAll(" ", "");
            date = "D:" + date + "+08'00'";
            if (kgPostil.getStyleId() == 0) {
                rect = kgPostil.getRect();
                String title = kgPostil.getAuthorName();
                String contents = kgPostil.getAnnotContent();
                pdfAnnotation = PdfAnnotation.createText(pdfStamper.getWriter(), rect, title, contents, false, null);
                pdfAnnotation.setFlags(4);
                pdfAnnotation.put(PdfName.TYPE, PdfName.ANNOT);
                pdfAnnotation.put(PdfName.M, new PdfString(date));
                pdfAnnotation.put(PdfName.CREATIONDATE, new PdfString(date));
                pdfAnnotation.put(PdfName.NM, new PdfString(UUID.randomUUID().toString()));
                pdfAnnotation.put(PdfName.NAME, new PdfName("Comment"));
                pdfAnnotation.put(PdfName.T, new PdfString(kgPostil.getAuthorName(), "UnicodeBig"));
                PdfArray c = new PdfArray();
                int[] nArray = new int[3];
                nArray[0] = 1;
                nArray[1] = 1;
                c.add(nArray);
                pdfAnnotation.put(PdfName.C, c);
                PdfDictionary ap = new PdfDictionary();
                KGBase64 base64 = new KGBase64();
                byte[] n = base64.decode("MCBHIDEgMSAwIHJnIDAgaSAwLjYwIHcgNCBNIDEgaiAwIEogW10wIGQgIDE5LjYyIDcuNTIgbSAxOS42MiA1LjcyIDE4LjEyIDQuMjYgMTYuMjggNC4yNiBjIDkuMDcgNC4yNSBsIDQuOTMgMC4zMiBsIDYuMDMgNC4yNiBsIDMuNzAgNC4yNiBsIDEuODYgNC4yNiAwLjM2IDUuNzIgMC4zNiA3LjUyIGMgMC4zNiAxNC4zNyBsIDAuMzYgMTYuMTcgMS44NiAxNy42MyAzLjcwIDE3LjYzIGMgMTYuMjggMTcuNjMgbCAxOC4xMiAxNy42MyAxOS42MiAxNi4xNyAxOS42MiAxNC4zNyBjIDE5LjYyIDcuNTIgbCBoIEIgMCBnIDMuODcgMTQuNDEgbSAzLjcwIDE0LjQxIDMuNTcgMTQuMjggMy41NyAxNC4xMSBjIDMuNTcgMTMuOTUgMy43MCAxMy44MSAzLjg3IDEzLjgxIGMgMTYuMTAgMTMuODEgbCAxNi4yNyAxMy44MSAxNi40MSAxMy45NSAxNi40MSAxNC4xMSBjIDE2LjQxIDE0LjI4IDE2LjI3IDE0LjQxIDE2LjEwIDE0LjQxIGMgMy44NyAxNC40MSBsIGggZiAzLjg3IDExLjIzIG0gMy43MCAxMS4yMyAzLjU3IDExLjEwIDMuNTcgMTAuOTMgYyAzLjU3IDEwLjc2IDMuNzAgMTAuNjMgMy44NyAxMC42MyBjIDE2LjEwIDEwLjYzIGwgMTYuMjcgMTAuNjMgMTYuNDEgMTAuNzYgMTYuNDEgMTAuOTMgYyAxNi40MSAxMS4xMCAxNi4yNyAxMS4yMyAxNi4xMCAxMS4yMyBjIDMuODcgMTEuMjMgbCBoIGYgMy44NyA4LjA1IG0gMy43MCA4LjA1IDMuNTcgNy45MSAzLjU3IDcuNzUgYyAzLjU3IDcuNTggMy43MCA3LjQ1IDMuODcgNy40NSBjIDEyLjg0IDcuNDUgbCAxMy4wMSA3LjQ1IDEzLjE1IDcuNTggMTMuMTUgNy43NSBjIDEzLjE1IDcuOTEgMTMuMDEgOC4wNSAxMi44NCA4LjA1IGMgMy44NyA4LjA1IGwgaCBm");
                ap.put(PdfName.N, this.createStream(pdfStamper, n, 20, 18).getIndirectReference());
                pdfAnnotation.put(PdfName.AP, ap);
                Rectangle popupRect = new Rectangle(pageSize.getWidth() - 180.0f, rect.getBottom() - 120.0f, pageSize.getWidth(), rect.getBottom());
                PdfAnnotation popup = PdfAnnotation.createPopup(pdfStamper.getWriter(), popupRect, null, false);
                popup.put(PdfName.PARENT, pdfAnnotation.getIndirectReference());
                pdfAnnotation.put(PdfName.POPUP, popup.getIndirectReference());
                pdfStamper.addAnnotation(pdfAnnotation, pagen);
                pdfStamper.addAnnotation(popup, pagen);
                continue;
            }
            if (kgPostil.getStyleId() == 12 || kgPostil.getStyleId() == 99) {
                rect = kgPostil.getRect();
                pdfAnnotation = PdfAnnotation.createStamp(pdfStamper.getWriter(), rect, "", "");
                PdfTemplate template = PdfTemplate.createTemplate(pdfStamper.getWriter(), rect.getWidth(), rect.getHeight());
                pdfAnnotation.setAppearance(PdfName.N, template);
                pdfAnnotation.put(PdfName.TYPE, PdfName.ANNOT);
                pdfAnnotation.put(PdfName.SUBTYPE, new PdfName(kgPostil.getStyleName()));
                pdfAnnotation.put(PdfName.T, new PdfString(kgPostil.getAuthorName(), "UnicodeBig"));
                pdfAnnotation.put(PdfName.M, new PdfString(date));
                if (kgPostil.getAnnotSignature() == null || "".equals(kgPostil.getAnnotSignature())) {
                    String annotContent = kgPostil.getAnnotContent();
                    template.add(annotContent.getBytes());
                } else {
                    byte[] imgBytes = Hex.decode((String)kgPostil.getAnnotSignature());
                    PdfGState gstate = new PdfGState();
                    gstate.setBlendMode(PdfGState.BM_MULTIPLY);
                    template.setGState(gstate);
                    template.addImage(Image.getInstance(imgBytes), rect.getWidth(), 0.0f, 0.0f, rect.getHeight(), 0.0f, 0.0f);
                    this.rotationApp(template, rotation);
                }
                pdfAnnotation.put(PdfName.F, new PdfNumber(4));
                pdfStamper.addAnnotation(pdfAnnotation, pagen);
                continue;
            }
            if (kgPostil.getStyleId() == 17) {
                rect = kgPostil.getRect();
                pdfAnnotation = new PdfAnnotation(pdfStamper.getWriter(), rect);
                pdfAnnotation.put(PdfName.TYPE, PdfName.ANNOT);
                pdfAnnotation.put(PdfName.SUBTYPE, new PdfName("Sound"));
                pdfAnnotation.put(PdfName.NM, new PdfString(kgPostil.getUnType()));
                pdfAnnotation.put(PdfName.T, new PdfString(kgPostil.getAuthorName(), "UnicodeBig"));
                pdfAnnotation.put(PdfName.M, new PdfString(date));
                pdfAnnotation.put(PdfName.F, new PdfNumber(4));
                PdfArray c = new PdfArray();
                int[] nArray = new int[3];
                nArray[0] = 1;
                nArray[1] = 1;
                c.add(nArray);
                pdfAnnotation.put(PdfName.C, c);
                PdfDictionary ap = new PdfDictionary();
                KGBase64 base64 = new KGBase64();
                byte[] n = base64.decode("MCBHIDAgaSAwLjU5IHcgNCBNIDAgaiAxIEogW10wIGQgIDEyLjA4IDkuNjggbSAxNC42MSA3LjkwIDEyLjA4IDUuMzcgdiBTIDEzLjc3IDExLjk5IG0gMTkuMDUgOC4yOSAxMy43NyAzLjAxIHYgUyAxNS43NCAxNC41NiBtIDI0LjEwIDguNzAgMTUuNzQgMC4zNSB2IFMgMS4wMDAwIDEuMDAwMCAwLjAwMDAgcmcgMSBqIDAgSiAgOS42OCAxNC4zOCBtIDUuNDMgMTAuMDUgbCA1LjQzIDEwLjA1IGwgMC4zOCAxMC4wNSBsIDAuMzggNS4wMSBsIDUuNDMgNS4wMSBsIDUuNDMgNS4wMyBsIDkuNjggMC43MCBsIDkuNjggMTQuMzggbCBoIEIgMC4yIHcgMCBqICA1LjE5IDEwLjA3IG0gNS4xOSA1LjA5IGwgUw==");
                ap.put(PdfName.N, this.createStream(pdfStamper, n, 20, 15).getIndirectReference());
                pdfAnnotation.put(PdfName.AP, ap);
                byte[] data = Hex.decode((String)kgPostil.getSoundData());
                int i = 0;
                while (i < data.length) {
                    byte tmp = data[i];
                    data[i] = data[i + 1];
                    data[i + 1] = tmp;
                    i += 2;
                }
                PdfIndirectObject indirectObject = this.createSoundStream(pdfStamper, data, kgPostil);
                pdfAnnotation.put(new PdfName("Sound"), indirectObject.getIndirectReference());
                pdfStamper.addAnnotation(pdfAnnotation, pagen);
                continue;
            }
            throw new RuntimeException("\u76ee\u524d\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\uff1astyleId=" + kgPostil.getStyleId() + "  styleName=" + kgPostil.getStyleName());
        }
        page.put(PdfName.ROTATE, new PdfNumber(rotation));
    }

    private PdfIndirectObject createStream(PdfStamper pdfStamper, byte[] data, int width, int height) throws IOException {
        PdfStream stream = new PdfStream(data);
        stream.put(PdfName.SUBJECT, PdfName.FORM);
        stream.put(PdfName.TYPE, PdfName.XOBJECT);
        int[] nArray = new int[4];
        nArray[2] = width;
        nArray[3] = height;
        stream.put(PdfName.BBOX, new PdfArray(nArray));
        int[] nArray2 = new int[6];
        nArray2[0] = 1;
        nArray2[3] = 1;
        stream.put(PdfName.MATRIX, new PdfArray(nArray2));
        stream.put(PdfName.FORMTYPE, new PdfNumber(1));
        PdfDictionary resources = new PdfDictionary();
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(new PdfName("PDF"));
        pdfArray.add(new PdfName("Text"));
        pdfArray.add(new PdfName("ImageB"));
        pdfArray.add(new PdfName("ImageC"));
        pdfArray.add(new PdfName("ImageI"));
        resources.put(PdfName.PROCSET, pdfArray);
        stream.put(PdfName.RESOURCES, resources);
        stream.put(PdfName.LENGTH, new PdfNumber(data.length));
        return pdfStamper.getWriter().addToBody(stream);
    }

    private PdfIndirectObject createSoundStream(PdfStamper pdfStamper, byte[] data, KGPostil kgPostil) throws IOException {
        PdfStream stream = new PdfStream(data);
        stream.put(PdfName.R, new PdfNumber(kgPostil.getAnnotRate()));
        stream.put(PdfName.B, new PdfNumber(kgPostil.getAnnotBitspersample()));
        stream.put(PdfName.C, new PdfNumber(kgPostil.getAnnotChannels()));
        stream.put(PdfName.TYPE, new PdfName(kgPostil.getStyleName()));
        stream.put(PdfName.E, new PdfName("Signed"));
        stream.flateCompress(1);
        return pdfStamper.getWriter().addToBody(stream);
    }

    protected void rotationApp(PdfTemplate app, int rotation) {
        if (rotation != 0) {
            AffineTransform transform = null;
            switch (rotation % 360) {
                case 0: {
                    break;
                }
                case 90: {
                    transform = new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f);
                    break;
                }
                case 180: {
                    transform = new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
                    break;
                }
                case 270: {
                    transform = new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not suport the rotation : " + rotation);
                }
            }
            if (transform != null) {
                double[] matrix = new double[6];
                transform.getMatrix(matrix);
                app.setMatrix((float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5]);
            }
        }
    }
}

