/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.fields;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.AcroFields;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.pdf.KGExecute;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfFieldsExtractText
extends KGExecute {
    private String split = "\r\n";
    private StringBuilder fields = new StringBuilder();
    private Map<String, String> map = new HashMap<String, String>();

    @Override
    protected void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.after(pdfReader, pdfStamper);
        this.fields.append("</items>");
    }

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.before(pdfReader, pdfStamper);
        this.fields.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(this.split);
        this.fields.append("<items>").append(this.split);
    }

    @Override
    protected void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        PdfDictionary page = pdfReader.getPageN(pagen);
        AcroFields acroFields = pdfReader.getAcroFields();
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        if (annots != null) {
            int i = 0;
            while (i < annots.size()) {
                PdfDictionary annot = annots.getAsDict(i);
                if (PdfName.WIDGET.equals(annot.getAsName(PdfName.SUBTYPE))) {
                    PdfString name = annot.getAsString(PdfName.T);
                    PdfName ft = annot.getAsName(PdfName.FT);
                    PdfString tm = annot.getAsString(PdfName.TM);
                    PdfDictionary parent = annot.getAsDict(PdfName.PARENT);
                    if (ft == null && parent != null) {
                        ft = parent.getAsName(PdfName.FT);
                    }
                    if (name == null && parent != null) {
                        name = parent.getAsString(PdfName.T);
                    }
                    if (name != null) {
                        String nameUnicode;
                        String nameVal = nameUnicode = name.toUnicodeString();
                        if (tm != null) {
                            nameVal = nameVal.substring(0, nameVal.length() - 3);
                        }
                        if (!this.map.containsKey(nameVal)) {
                            String val = acroFields.getField(nameUnicode);
                            String type = null;
                            type = ft != null ? ft.toString().substring(1) : "";
                            this.map.put(nameVal, val);
                            this.fields.append("<item name=\"").append(nameVal).append("\" type=\"").append(type).append("\">");
                            this.fields.append(val);
                            this.fields.append("</item>").append(this.split);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public String getFieldsContent() {
        return this.fields.toString();
    }

    public Map<String, String> getFields() {
        return this.map;
    }
}

