/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.electronicseal.customize;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.executes.electronicseal.KGDefaultMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.customize.PdfElecWriterAspect;
import com.kinggrid.pdf.utils.KGPdfUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class PdfElecWriter
extends KGExecute {
    private List<PdfElecWriterAspect> executes;
    private KGMessageDigest messageDigest = new KGDefaultMessageDigest();
    private String strMd5;
    private String strMd5_6;
    private String strMd5_10;

    protected void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        PdfNumber sealNum = pdfReader.getCatalog().getAsNumber(KGElectronicSealName.SEALNUM);
        if (sealNum == null || sealNum.intValue() <= 0) {
            return;
        }
        PdfDictionary page = pdfReader.getPageN(pagen);
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        if (annots != null) {
            int i = annots.size() - 1;
            while (i >= 0) {
                PdfDictionary annot = annots.getAsDict(i);
                if (annot != null && KGElectronicSealName.SEAL.equals(annot.getAsName(PdfName.SUBTYPE))) {
                    PdfDictionary info = annot.getAsDict(PdfName.INFO);
                    if (info != null) {
                        PdfNumber proversion = info.getAsNumber(KGElectronicSealName.PROVERSION);
                        PdfNumber hashType = info.getAsNumber(KGElectronicSealName.HASH_TYPE);
                        if (hashType == null || hashType.intValue() == KGElectronicSealName.HASH_TYPE_SHA1.intValue()) {
                            if (proversion != null && proversion.intValue() == 10) {
                                if (this.strMd5_10 == null) {
                                    this.strMd5_10 = KGPdfUtils.calculatePdfDoc104Elec(pdfReader, this.messageDigest);
                                }
                                this.strMd5 = this.strMd5_10;
                            } else {
                                if (this.strMd5_6 == null) {
                                    this.strMd5_6 = new String(Hex.encode((byte[])KGPdfUtils.calculatePdfHash4Elec(pdfReader, this.messageDigest)));
                                }
                                this.strMd5 = this.strMd5_6;
                            }
                        }
                    }
                    if (this.executes != null) {
                        for (PdfElecWriterAspect pdfElectronicExecute : this.executes) {
                            pdfElectronicExecute.execute(pdfReader, pdfStamper, annot, pagen, this.strMd5);
                        }
                    }
                }
                --i;
            }
        }
    }

    public void addExtraExecute(PdfElecWriterAspect pdfElecWriterAspect) {
        if (this.executes == null) {
            this.executes = new ArrayList<PdfElecWriterAspect>();
        }
        this.executes.add(pdfElecWriterAspect);
    }

    public KGMessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public void setMessageDigest(KGMessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }
}

