/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.electronicseal;

import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.executes.electronicseal.IElecTSA;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import java.io.IOException;

public class KGPdfElectronicTSA
extends KGPdfElectronicExecute {
    private String tSTime;
    private String tSCert;
    private IElecTSA elecTSA;
    private PdfString str_tsTime;
    private PdfIndirectReference ref_tsCert;

    @Deprecated
    public void setRSA(String tSTime, String tSCert) {
        this.tSCert = tSCert;
        this.tSTime = tSTime;
    }

    public void setTSA(String tSTime, String tSCert) {
        this.tSCert = tSCert;
        this.tSTime = tSTime;
    }

    public void setTSA(IElecTSA elecTSA) {
        this.elecTSA = elecTSA;
    }

    public void execute(PdfStamper pdfStamper, PdfAnnotation annotation, int pagen, String hash) {
        if (this.str_tsTime != null && this.ref_tsCert != null) {
            annotation.put(new PdfName("TSTime"), this.str_tsTime);
            annotation.put(new PdfName("TSCert"), this.ref_tsCert);
            return;
        }
        KGBase64 base64 = new KGBase64();
        if (this.elecTSA != null) {
            this.elecTSA.sendTsaRequest(hash);
            this.tSTime = this.elecTSA.getTSTime();
            this.tSCert = this.elecTSA.getTSCert();
        }
        if (this.tSTime != null) {
            this.str_tsTime = new PdfString(base64.decode(this.tSTime));
            annotation.put(new PdfName("TSTime"), this.str_tsTime);
        }
        if (this.tSCert != null) {
            byte[] tscertData = base64.decode(this.tSCert);
            PdfStream stream = new PdfStream(tscertData);
            stream.put(PdfName.LENGTH, new PdfNumber(tscertData.length));
            try {
                PdfIndirectObject refObj1 = pdfStamper.getWriter().addToBody(stream);
                this.ref_tsCert = refObj1.getIndirectReference();
                annotation.put(new PdfName("TSCert"), this.ref_tsCert);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

