/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.electronicseal;

import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.encrypt.KGSignature;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import com.kinggrid.pdf.signinter.DigitalSignature;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class KGPdfElectronicSig
extends KGPdfElectronicExecute {
    private int sigType = 0;
    private String certSignMsg;
    private String certContext;
    private String pwd;
    private InputStream pfxStream;
    private DigitalSignature digitalSignature;
    private PdfIndirectReference refCertSignMsg;
    private PdfIndirectReference refCertContext;
    private String signatureAlgorithm = "RSA";
    private byte[] sm2Cert;

    public void setSig(String certSignMsg, String certContext) {
        this.sigType = 0;
        this.certSignMsg = certSignMsg;
        this.certContext = certContext;
    }

    public void setCertMsg(InputStream stream, String pwd) {
        this.sigType = 1;
        this.pfxStream = stream;
        this.pwd = pwd;
    }

    public void setCertMsg(DigitalSignature digitalSignature) {
        this.sigType = 2;
        this.digitalSignature = digitalSignature;
    }

    public void execute(PdfStamper pdfStamper, PdfAnnotation annotation, int pagen, String hash) {
        try {
            if (this.refCertSignMsg != null && this.refCertContext != null) {
                annotation.put(new PdfName("certContext"), this.refCertContext);
                annotation.put(new PdfName("certSignMsg"), this.refCertSignMsg);
                return;
            }
            if (this.sigType == 1) {
                KGBase64 base64 = new KGBase64();
                byte[] hashData = hash.getBytes("GBK");
                KGSignature kgSignature = new KGSignature(this.pfxStream, this.pwd, this.pwd);
                kgSignature.update(hashData);
                byte[] digest = kgSignature.sign();
                Certificate[] chain = kgSignature.getChain();
                PdfPKCS7 pkcs7 = new PdfPKCS7(null, chain, "SHA1", "BC", null, false);
                pkcs7.setExternalDigest(digest, hashData, "RSA");
                byte[] p7 = pkcs7.getEncodedPKCS7();
                String cert = "-----BEGIN CERTIFICATE-----\n" + base64.encode(chain[0].getEncoded()) + "\n-----END CERTIFICATE-----\n";
                this.setSig(base64.encode(p7), cert);
            } else if (this.sigType == 2 && this.digitalSignature != null) {
                if ("RSA".equals(this.signatureAlgorithm)) {
                    this.sigWithRSA(hash);
                } else if ("SM2".equals(this.signatureAlgorithm)) {
                    this.sigWithSM2(hash);
                } else {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d\u7b97\u6cd5\uff1a" + this.signatureAlgorithm);
                }
            }
            if (this.certSignMsg != null) {
                byte[] streambyte = this.certSignMsg.getBytes("UTF-16LE");
                PdfStream certSignMsgStream = new PdfStream(streambyte);
                PdfIndirectObject refObj = pdfStamper.getWriter().addToBody(certSignMsgStream);
                this.refCertSignMsg = refObj.getIndirectReference();
                annotation.put(new PdfName("certSignMsg"), this.refCertSignMsg);
            }
            if (this.certContext != null) {
                byte[] streambyte1;
                byte[] tmp = streambyte1 = this.certContext.getBytes("UTF-16LE");
                streambyte1 = new byte[tmp.length * 2];
                System.arraycopy(tmp, 0, streambyte1, 0, tmp.length);
                PdfStream certContextStream = new PdfStream(streambyte1);
                PdfIndirectObject refObj1 = pdfStamper.getWriter().addToBody(certContextStream);
                this.refCertContext = refObj1.getIndirectReference();
                annotation.put(new PdfName("certContext"), this.refCertContext);
            }
            pdfStamper.markUsed(annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sigWithRSA(String hash) throws Exception {
        KGBase64 base64 = new KGBase64();
        byte[] hashData = hash.getBytes("GBK");
        Certificate[] chain = null;
        byte[] digest = null;
        chain = this.digitalSignature.getCertificate();
        digest = this.digitalSignature.sign(hashData);
        PdfPKCS7 pkcs7 = new PdfPKCS7(null, chain, "SHA1", "BC", null, false);
        pkcs7.setExternalDigest(digest, hashData, "RSA");
        byte[] p7 = pkcs7.getEncodedPKCS7();
        String cert = "-----BEGIN CERTIFICATE-----\n" + base64.encode(chain[0].getEncoded()) + "\n-----END CERTIFICATE-----\n";
        this.setSig(base64.encode(p7), cert);
    }

    private void sigWithSM2(String hash) throws Exception {
        KGBase64 base64 = new KGBase64();
        byte[] hashData = hash.getBytes("GBK");
        byte[] digest = this.digitalSignature.sign(hashData);
        X509Certificate[] chain = this.digitalSignature.getCertificate();
        byte[] certdata = null;
        certdata = chain != null ? chain[0].getEncoded() : this.sm2Cert;
        String cert = "-----BEGIN CERTIFICATE-----\n" + base64.encode(certdata) + "\n-----END CERTIFICATE-----\n";
        this.setSig(new String(digest), cert);
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public byte[] getSm2Cert() {
        return this.sm2Cert;
    }

    public void setSm2Cert(byte[] sm2Cert) {
        this.sm2Cert = sm2Cert;
    }
}

