/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.customize.iwebpdf;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.ImgRaw;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.kinggrid.pdf.executes.PdfSignature;
import com.kinggrid.pdf.executes.customize.iwebpdf.KGSealInfo;
import com.kinggrid.pdf.executes.customize.iwebpdf.KGiWebPdfParser;
import java.io.IOException;
import java.util.List;

public class PdfSignature4SaveSignDataToLocal
extends PdfSignature {
    private String data;
    private List<KGSealInfo> sealInfos;

    public PdfSignature4SaveSignDataToLocal(String data) {
        this.data = data;
    }

    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        this.sealInfos = KGiWebPdfParser.parserSaveSignDataToLocal(this.data);
        super.before(pdfReader, pdfStamper);
    }

    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        if (this.sealInfos != null && this.sealInfos.size() > 0) {
            int rotation = pdfReader.getPageRotation(pagen);
            PdfDictionary page = pdfReader.getPageN(pagen);
            page.put(PdfName.ROTATE, new PdfNumber(0));
            for (KGSealInfo sealInfo : this.sealInfos) {
                if (pagen != sealInfo.getPage()) continue;
                PdfStream icon = KGiWebPdfParser.createImg(sealInfo, pdfStamper);
                PdfIndirectObject pdfIndirectObject = pdfStamper.getWriter().addToBody(icon);
                ImgRaw image = new ImgRaw(sealInfo.getWidth(), sealInfo.getHeight(), 1, 1, null);
                image.setDirectReference(pdfIndirectObject.getIndirectReference());
                Rectangle rect = new Rectangle(sealInfo.getLeft(), sealInfo.getBottom(), sealInfo.getRight(), sealInfo.getTop(), 0);
                this.setImage(image);
                this.setRect(rect);
                super.execute(pdfReader, pdfStamper, pagen);
            }
            page.put(PdfName.ROTATE, new PdfNumber(rotation));
        }
    }
}

