/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.customize.iwebpdf;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.ImgRaw;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.executes.PdfElectronicSeal;
import com.kinggrid.pdf.executes.customize.iwebpdf.KGSealInfo;
import com.kinggrid.pdf.executes.customize.iwebpdf.KGiWebPdfParser;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicSig;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicTSA;
import com.kinggrid.pdf.utils.KGPdfUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PdfElecSeal4SaveSignDataToLocal
extends PdfElectronicSeal {
    private String data;
    private List<KGSealInfo> sealInfos;
    private boolean reCalcHash = false;
    private KGPdfElectronicTSA electronicTSA = new KGPdfElectronicTSA();
    private KGPdfElectronicSig electronicSig = new KGPdfElectronicSig();

    public PdfElecSeal4SaveSignDataToLocal(String data) {
        this.data = data;
    }

    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        this.sealInfos = KGiWebPdfParser.parserSaveSignDataToLocal(this.data);
        if (this.sealInfos.size() > 0) {
            KGSealInfo sealInfo = this.sealInfos.get(0);
            String[] pageids = sealInfo.getPageID().split("\\^");
            int k = 0;
            while (k < pageids.length) {
                PdfDictionary dict = pdfReader.getPageNRelease(k + 1);
                if (dict != null && dict.getAsString(PdfName.ID) == null) {
                    dict.put(PdfName.ID, new PdfString(pageids[k]));
                }
                ++k;
            }
        }
        super.before(pdfReader, pdfStamper);
    }

    public void setSig(String certSignMsg, String certContext) {
        this.electronicSig.setSig(certSignMsg, certContext);
    }

    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        if (this.sealInfos != null && this.sealInfos.size() > 0) {
            int rotation = pdfReader.getPageRotation(pagen);
            PdfDictionary page = pdfReader.getPageN(pagen);
            page.put(PdfName.ROTATE, new PdfNumber(0));
            int i = 0;
            while (i < this.sealInfos.size()) {
                KGSealInfo sealInfo = this.sealInfos.get(i);
                if (pagen == sealInfo.getPage()) {
                    KGBase64 base64;
                    PdfStream icon = KGiWebPdfParser.createImg(sealInfo, pdfStamper);
                    PdfIndirectObject pdfIndirectObject = pdfStamper.getWriter().addToBody(icon);
                    ImgRaw image = new ImgRaw(sealInfo.getWidth(), sealInfo.getHeight(), 1, 1, null);
                    image.setDirectReference(pdfIndirectObject.getIndirectReference());
                    Rectangle rect = new Rectangle(sealInfo.getLeft(), sealInfo.getBottom(), sealInfo.getRight(), sealInfo.getTop(), 0);
                    this.setImage(image);
                    this.setRect(rect);
                    if (this.reCalcHash) {
                        base64 = new KGBase64();
                        base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
                        String baseInfo = new String(base64.decode(sealInfo.getBaseInfo()), "UTF-16LE");
                        Map<String, String> map = KGPdfUtils.getBaseInfo(baseInfo);
                        this.setSealMsg(map.get("KeySerial"), map.get("CompName"), map.get("UserName"), map.get("SealSerial"), map.get("KeyName"));
                        this.setProtectDoc(map.get("bProtectDoc"));
                        this.setProversion(6);
                    } else {
                        this.setProversion(sealInfo.getProVersion());
                        this.setSealMsg(sealInfo.getBaseInfo());
                        base64 = new KGBase64();
                        if (sealInfo.getCertSignMsg() != null && sealInfo.getCertContext() != null) {
                            this.electronicSig.setSig(new String(base64.decode(sealInfo.getCertSignMsg()), "UTF-16LE"), new String(base64.decode(sealInfo.getCertContext()), "UTF-16LE"));
                            this.addExtraExecute(this.electronicSig);
                        }
                    }
                    this.electronicTSA.setRSA(sealInfo.getTsTime(), sealInfo.getTsCert());
                    this.addExtraExecute(this.electronicTSA);
                    super.execute(pdfReader, pdfStamper, pagen);
                    this.sealInfos.remove(sealInfo);
                    continue;
                }
                ++i;
            }
            page.put(PdfName.ROTATE, new PdfNumber(rotation));
        }
    }

    public boolean isReCalcHash() {
        return this.reCalcHash;
    }

    public void setReCalcHash(boolean reCalcHash) {
        this.reCalcHash = reCalcHash;
    }

    public String getHash() {
        return super.getHash().toUpperCase();
    }
}

