/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.customize.iwebpdf;

import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfLiteral;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.executes.customize.iwebpdf.KGSealInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGiWebPdfParser {
    public static List<KGSealInfo> parserSaveSignDataToLocal(String data) {
        ArrayList<KGSealInfo> sealInfos = new ArrayList<KGSealInfo>();
        if (data != null) {
            String[] seals = data.split(";");
            KGBase64 base64 = new KGBase64();
            base64.setBase64Table("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*-");
            String[] stringArray = seals;
            int n = seals.length;
            int n2 = 0;
            while (n2 < n) {
                String seal = stringArray[n2];
                if (!"".equals(seal)) {
                    byte[] decoded = base64.decode(seal);
                    byte[] temp = new byte[decoded.length];
                    byte[] key = "www.goldgrid.com".getBytes();
                    RC4Engine rc4Engine = new RC4Engine();
                    KeyParameter keyParameter = new KeyParameter(key);
                    rc4Engine.init(false, (CipherParameters)keyParameter);
                    rc4Engine.processBytes(decoded, 0, decoded.length, temp, 0);
                    rc4Engine.reset();
                    sealInfos.addAll(KGiWebPdfParser.loadSignData(new ByteArrayInputStream(temp)));
                }
                ++n2;
            }
        }
        return sealInfos;
    }

    private static List<KGSealInfo> loadSignData(InputStream in) {
        ArrayList<KGSealInfo> sealInfos = new ArrayList<KGSealInfo>();
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(in);
            List list = document.selectNodes("/Signature/Item");
            int i = 0;
            while (i < list.size()) {
                KGSealInfo sealInfo = new KGSealInfo();
                Node node = (Node)list.get(i);
                String val = KGiWebPdfParser.getNodeText(node, "page");
                if (val != null) {
                    sealInfo.setPage(Integer.parseInt(val));
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "width")) != null) {
                    sealInfo.setWidth(Integer.parseInt(val));
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "height")) != null) {
                    sealInfo.setHeight(Integer.parseInt(val));
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "proVersion")) != null) {
                    sealInfo.setProVersion(Integer.parseInt(val));
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "left")) != null) {
                    sealInfo.setLeft(Float.parseFloat(val));
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "top")) != null) {
                    sealInfo.setTop(Float.parseFloat(val));
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "right")) != null) {
                    sealInfo.setRight(Float.parseFloat(val));
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "bottom")) != null) {
                    sealInfo.setBottom(Float.parseFloat(val));
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "BaseInfo")) != null) {
                    sealInfo.setBaseInfo(val);
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "icon")) != null) {
                    sealInfo.setIcon(val);
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "PageID")) != null) {
                    sealInfo.setPageID(val);
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "TSTime")) != null) {
                    sealInfo.setTsTime(val);
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "TSCert")) != null) {
                    sealInfo.setTsCert(val);
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "certSignMsg")) != null) {
                    sealInfo.setCertSignMsg(val);
                }
                if ((val = KGiWebPdfParser.getNodeText(node, "certContext")) != null) {
                    sealInfo.setCertContext(val);
                }
                sealInfos.add(sealInfo);
                ++i;
            }
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        return sealInfos;
    }

    private static String getNodeText(Node parent, String name) {
        String val = null;
        Node node = parent.selectSingleNode(name);
        if (node != null) {
            val = node.getText();
        }
        return val;
    }

    public static PdfStream createImg(KGSealInfo sealInfo, PdfStamper stamper) throws IOException {
        KGBase64 base64 = new KGBase64();
        byte[] iconbyte = base64.decode(sealInfo.getIcon());
        PdfStream icon = new PdfStream(iconbyte);
        icon.put(PdfName.TYPE, PdfName.XOBJECT);
        icon.put(PdfName.SUBTYPE, new PdfName("Image"));
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(new PdfNumber(0));
        pdfArray.add(new PdfNumber(0));
        pdfArray.add(new PdfNumber(sealInfo.getWidth()));
        pdfArray.add(new PdfNumber(sealInfo.getHeight()));
        icon.put(PdfName.BBOX, pdfArray);
        icon.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
        icon.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
        icon.put(PdfName.MASK, new PdfLiteral("[200 255 200 255 200 255]"));
        icon.put(PdfName.WIDTH, new PdfNumber(sealInfo.getWidth()));
        icon.put(PdfName.HEIGHT, new PdfNumber(sealInfo.getHeight()));
        PdfDictionary decodeparms = new PdfDictionary();
        decodeparms.put(PdfName.COLUMNS, new PdfNumber(sealInfo.getWidth()));
        decodeparms.put(PdfName.ROWS, new PdfNumber(sealInfo.getHeight()));
        decodeparms.put(PdfName.COLORS, new PdfNumber(3));
        icon.put(PdfName.DECODEPARMS, decodeparms);
        icon.put(PdfName.FILTER, PdfName.FLATEDECODE);
        icon.put(PdfName.LENGTH, new PdfNumber(iconbyte.length));
        return icon;
    }
}

