/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.BaseFont;
import com.KGitextpdf.text.pdf.PdfContentByte;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.pdf.KGExecute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfWatermark
extends KGExecute
implements Cloneable {
    private String watermarkName = "KINGGRID";
    private String text = "\u6c5f\u897f\u91d1\u683c\u79d1\u6280\u80a1\u4efd\u6709\u9650\u516c\u53f8";
    private Image image;
    private BaseFont baseFont;
    private float fontSize = 40.0f;
    private float rotation = 45.0f;
    private BaseColor color = BaseColor.RED;
    private int alignment = 1;
    private float x;
    private float y;
    private float fillOpacity = 0.5f;
    private PdfGState gstate = new PdfGState();
    private String type;
    private boolean crossPage = false;
    private boolean hideFirstAndLast = true;
    private float prePageWidth = -1.0f;
    private Map<Integer, Float> pageWidthMap = new HashMap<Integer, Float>();
    private boolean byXYDistance = false;
    private float xDistance;
    private float yDistance;
    private float marginTop = 0.0f;
    private float marginLeft = 0.0f;
    private float prePageLastRowY;
    private float pageLastRowY;
    private int prePageColumnNum;
    private float pageFirstX;
    private float pageFirstY;
    private List<Float> xAxisInRow = new ArrayList<Float>();
    private double toUp;
    private double toBottom;
    private boolean byDensity = false;
    private float density = 0.5f;
    private static final float DEFAULT_DENSITY = 0.5f;
    private float pageFirstRowY;
    private boolean startPage = true;
    private Map<Integer, int[]> pageCrossPageMap = new HashMap<Integer, int[]>();
    private boolean imageTransparent;

    public String getWatermarkName() {
        return this.watermarkName;
    }

    public void setWatermarkName(String watermarkName) {
        this.watermarkName = watermarkName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.type = "1";
        this.text = text;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.type = "2";
        this.image = image;
    }

    public BaseFont getBaseFont() {
        return this.baseFont;
    }

    public void setBaseFont(BaseFont baseFont) {
        this.baseFont = baseFont;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public BaseColor getColor() {
        return this.color;
    }

    public void setColor(BaseColor color) {
        this.color = color;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getFillOpacity() {
        return this.fillOpacity;
    }

    public void setFillOpacity(float fillOpacity) {
        this.fillOpacity = fillOpacity;
    }

    public boolean isCrossPage() {
        return this.crossPage;
    }

    public void setCrossPage(boolean crossPage) {
        this.crossPage = crossPage;
    }

    public boolean isHideFirstAndLast() {
        return this.hideFirstAndLast;
    }

    public void setHideFirstAndLast(boolean hideFirstAndLast) {
        this.hideFirstAndLast = hideFirstAndLast;
    }

    public void setXYDistance(float xDistance, float yDistance, float marginLeft, float marginTop) {
        this.byXYDistance = true;
        this.xDistance = xDistance;
        this.yDistance = yDistance;
        this.marginLeft = marginLeft;
        this.marginTop = marginTop;
    }

    public void setDensity(float density) {
        this.byDensity = true;
        this.density = density;
    }

    public void setImageTransparent() {
        this.imageTransparent = true;
    }

    public boolean isImageTransparent() {
        return this.imageTransparent;
    }

    public void setTextAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        if (this.isImageTransparent()) {
            this.gstate.setBlendMode(PdfGState.BM_MULTIPLY);
        } else {
            this.gstate.setFillOpacity(this.fillOpacity);
        }
        if (this.baseFont == null) {
            this.baseFont = BaseFont.createFont("STSongStd-Light", "UniGB-UCS2-H", false);
        }
        PdfContentByte pdfContentByte = pdfStamper.getOverContent(pagen);
        pdfContentByte.beginMarkedContentSequence(new PdfName(this.watermarkName));
        pdfContentByte.setGState(this.gstate);
        if ("1".equals(this.type)) {
            if (this.byXYDistance) {
                if (this.crossPage) {
                    this.textWatermarkByXYDistanceWithCrossPage(pdfReader, pdfContentByte, pagen);
                } else {
                    this.textWatermarkByXYDistanceWithoutCrossPage(pdfReader, pdfContentByte, pagen);
                }
            } else if (this.byDensity) {
                if (this.crossPage) {
                    this.equidistanceWatermarkWithCrossPage(pdfReader, pdfContentByte, pagen);
                } else {
                    this.equidistanceWatermarkWithoutCrossPage(pdfReader, pdfContentByte, pagen);
                }
            } else {
                this.textWatermark(pdfReader, pdfContentByte, pagen);
            }
        } else if ("2".equals(this.type)) {
            this.image.setAbsolutePosition(this.x, this.y);
            pdfContentByte.addImage(this.image);
        }
        pdfContentByte.endMarkedContentSequence();
    }

    private void textWatermark(PdfReader pdfReader, PdfContentByte pdfContentByte, int pagen) {
        boolean upCross = false;
        if (this.crossPage) {
            int[] crossPageArray = this.checkCrossPage(pdfReader, pagen);
            Rectangle rect = pdfReader.getPageSize(pagen);
            float pageHeight = rect.getHeight();
            float pageWidth = rect.getWidth();
            int pageRotation = pdfReader.getPageRotation(pagen) % 360;
            if (pageRotation == 90 || pageRotation == 270) {
                pageHeight = rect.getWidth();
                pageWidth = rect.getHeight();
            }
            float xOffset = 0.0f;
            if (crossPageArray[0] == 1) {
                if (crossPageArray[1] == 1) {
                    crossPageArray[2] = 1;
                    this.y = rect.getHeight() - this.y;
                    upCross = true;
                }
                if (crossPageArray[2] == 1) {
                    if (this.prePageWidth != -1.0f) {
                        xOffset = (pageWidth - this.prePageWidth) / 2.0f;
                    }
                    if (pagen == 1) {
                        if (!this.hideFirstAndLast) {
                            this.watermarkWithText(pdfContentByte, this.x + xOffset, pageHeight + Math.abs(this.y));
                        }
                    } else {
                        this.watermarkWithText(pdfContentByte, this.x + xOffset, pageHeight + Math.abs(this.y));
                    }
                }
                if (this.hideFirstAndLast && !upCross && pagen == pdfReader.getNumberOfPages()) {
                    return;
                }
            }
            this.prePageWidth = pageWidth;
        }
        this.watermarkWithText(pdfContentByte, this.x, this.y);
    }

    private void watermarkWithText(PdfContentByte pdfContentByte, float x, float y) {
        pdfContentByte.beginText();
        pdfContentByte.setFontAndSize(this.baseFont, this.fontSize);
        pdfContentByte.setColorFill(this.color);
        pdfContentByte.showTextAligned(this.alignment, this.text, x, y, this.rotation);
        pdfContentByte.endText();
    }

    private void textWatermarkByXYDistanceWithCrossPage(PdfReader pdfReader, PdfContentByte pdfContentByte, int pagen) {
        float xInRow;
        Rectangle rectangle = pdfReader.getPageSizeWithRotation(pagen);
        float pageWidth = rectangle.getWidth();
        float pageHeight = rectangle.getHeight();
        float textWidth = (float)this.text.length() * this.fontSize;
        float textHeight = this.fontSize;
        this.rotation %= 360.0f;
        double radianRotation = Math.toRadians(this.rotation);
        if (this.pageFirstX == 0.0f) {
            this.pageFirstX = (float)((double)textWidth * this.absCos(radianRotation) / 2.0 + (double)textHeight * this.absSin(radianRotation) + (double)this.marginLeft);
            this.pageFirstY = (float)((double)pageHeight - ((double)textWidth * this.absSin(radianRotation) / 2.0 + (double)textHeight * this.absCos(radianRotation)) - (double)this.marginTop);
            xInRow = this.pageFirstX;
            this.xAxisInRow.add(Float.valueOf(xInRow));
            while (!((xInRow += this.xDistance) > pageWidth)) {
                this.xAxisInRow.add(Float.valueOf(xInRow));
            }
        } else {
            float xOffset = pageWidth - this.prePageWidth;
            this.pageFirstX += xOffset / 2.0f;
            this.pageFirstY = pageHeight - (this.yDistance - this.prePageLastRowY);
            xInRow = this.pageFirstX;
            this.xAxisInRow.add(Float.valueOf(xInRow));
            int i = 0;
            while (i < this.prePageColumnNum - 1) {
                if ((xInRow += this.xDistance) <= pageWidth) {
                    this.xAxisInRow.add(Float.valueOf(xInRow));
                }
                ++i;
            }
        }
        ArrayList<Float> yAxisInColumn = new ArrayList<Float>();
        float yInColumn = this.pageFirstY;
        yAxisInColumn.add(Float.valueOf(yInColumn));
        while (!((yInColumn -= this.yDistance) < 0.0f)) {
            yAxisInColumn.add(Float.valueOf(yInColumn));
        }
        this.pageFirstRowY = this.pageFirstY;
        this.pageLastRowY = ((Float)yAxisInColumn.get(yAxisInColumn.size() - 1)).floatValue();
        Iterator iterator = yAxisInColumn.iterator();
        while (iterator.hasNext()) {
            float yTemp = ((Float)iterator.next()).floatValue();
            Iterator<Float> iterator2 = this.xAxisInRow.iterator();
            while (iterator2.hasNext()) {
                float xTemp;
                this.x = xTemp = iterator2.next().floatValue();
                this.y = yTemp;
                this.multiTextWatermark(pdfReader, pdfContentByte, pagen);
            }
        }
        this.prePageLastRowY = ((Float)yAxisInColumn.get(yAxisInColumn.size() - 1)).floatValue();
        this.prePageColumnNum = this.xAxisInRow.size();
        this.prePageWidth = pageWidth;
        this.xAxisInRow.removeAll(this.xAxisInRow);
        yAxisInColumn.retainAll(yAxisInColumn);
    }

    private void textWatermarkByXYDistanceWithoutCrossPage(PdfReader pdfReader, PdfContentByte pdfContentByte, int pagen) {
        Rectangle rectangle = pdfReader.getPageSizeWithRotation(pagen);
        float pageWidth = rectangle.getWidth();
        float pageHeight = rectangle.getHeight();
        float textWidth = (float)this.text.length() * this.fontSize;
        float textHeight = this.fontSize;
        this.rotation %= 360.0f;
        double radianRotation = Math.toRadians(this.rotation);
        float xStartPoint = (float)((double)textWidth * this.absCos(radianRotation) / 2.0 + (double)textHeight * this.absSin(radianRotation) + (double)this.marginLeft);
        float yStartPoint = (float)((double)pageHeight - ((double)textWidth * this.absSin(radianRotation) / 2.0 + (double)textHeight * this.absCos(radianRotation)) - (double)this.marginTop);
        this.x = xStartPoint;
        this.y = yStartPoint;
        ArrayList<Float> xAxisInRow = new ArrayList<Float>();
        ArrayList<Float> yAxisInColumn = new ArrayList<Float>();
        float xInRow = xStartPoint;
        float yInColumn = yStartPoint;
        xAxisInRow.add(Float.valueOf(xInRow));
        yAxisInColumn.add(Float.valueOf(yInColumn));
        while (!((xInRow += this.xDistance) > pageWidth)) {
            xAxisInRow.add(Float.valueOf(xInRow));
        }
        while (!((yInColumn -= this.yDistance) < 0.0f)) {
            yAxisInColumn.add(Float.valueOf(yInColumn));
        }
        Iterator iterator = yAxisInColumn.iterator();
        while (iterator.hasNext()) {
            float yTemp = ((Float)iterator.next()).floatValue();
            Iterator iterator2 = xAxisInRow.iterator();
            while (iterator2.hasNext()) {
                float xTemp = ((Float)iterator2.next()).floatValue();
                this.watermarkWithText(pdfContentByte, xTemp, yTemp);
            }
        }
        this.prePageLastRowY = ((Float)yAxisInColumn.get(yAxisInColumn.size() - 1)).floatValue();
        this.prePageColumnNum = xAxisInRow.size();
    }

    private void equidistanceWatermarkWithCrossPage(PdfReader pdfReader, PdfContentByte pdfContentByte, int pagen) {
        Rectangle rectangle = pdfReader.getPageSizeWithRotation(pagen);
        float pageWidth = rectangle.getWidth();
        float pageHeight = rectangle.getHeight();
        float textHeight = this.fontSize;
        if (this.pageFirstX == 0.0f) {
            double minXDistance = (double)textHeight / this.absSin(this.rotation);
            double minYDistance = this.getHorizontalAndVerticalLength(pdfReader, pdfContentByte, pagen)[1];
            if (this.density <= 0.0f || this.density > 1.0f) {
                this.density = 0.5f;
            }
            this.xDistance = (float)(minXDistance / (double)this.density);
            this.yDistance = (float)(minYDistance / (double)this.density);
            this.yDistance = this.xDistance > this.yDistance ? this.xDistance : this.yDistance;
            this.xDistance = this.yDistance;
            float maxDistance = Math.min(pageWidth, pageHeight);
            if (this.xDistance > maxDistance) {
                this.xDistance = this.yDistance = maxDistance;
            }
        }
        if (this.pageFirstX == 0.0f) {
            this.startPage = true;
            this.pageFirstY = pageHeight / 2.0f;
        } else {
            this.startPage = false;
            this.pageFirstY = pageHeight - (this.yDistance - this.prePageLastRowY);
        }
        this.pageFirstX = pageWidth / 2.0f;
        Map<Character, List<Float>> xYCoordinateMap = this.getXYCoordinateList(this.pageFirstX, this.pageFirstY, this.xDistance, this.xDistance, pageWidth, pageHeight);
        List<Float> xList = xYCoordinateMap.get(Character.valueOf('x'));
        List<Float> yList = xYCoordinateMap.get(Character.valueOf('y'));
        this.prePageColumnNum = xList.size();
        for (float x : xList) {
            for (float y : yList) {
                this.x = x;
                this.y = y;
                this.multiTextWatermark(pdfReader, pdfContentByte, pagen);
            }
        }
        this.prePageLastRowY = this.pageLastRowY;
    }

    private void equidistanceWatermarkWithoutCrossPage(PdfReader pdfReader, PdfContentByte pdfContentByte, int pagen) {
        Rectangle rectangle = pdfReader.getPageSizeWithRotation(pagen);
        float pageWidth = rectangle.getWidth();
        float pageHeight = rectangle.getHeight();
        float textHeight = this.fontSize;
        double minXDistance = (double)textHeight / this.absSin(this.rotation);
        double minYDistance = this.getHorizontalAndVerticalLength(pdfReader, pdfContentByte, pagen)[1];
        if (this.density <= 0.0f || this.density > 1.0f) {
            this.density = 0.5f;
        }
        this.xDistance = (float)(minXDistance / (double)this.density);
        this.yDistance = (float)(minYDistance / (double)this.density);
        this.yDistance = this.xDistance > this.yDistance ? this.xDistance : this.yDistance;
        this.xDistance = this.yDistance;
        float pageMidPointX = pageWidth / 2.0f;
        float pageMidPointY = pageHeight / 2.0f;
        Map<Character, List<Float>> xYCoordinateMap = this.getXYCoordinateList(pageMidPointX, pageMidPointY, this.xDistance, this.xDistance, pageWidth, pageHeight);
        List<Float> xList = xYCoordinateMap.get(Character.valueOf('x'));
        List<Float> yList = xYCoordinateMap.get(Character.valueOf('y'));
        for (float x : xList) {
            for (float y : yList) {
                this.x = x;
                this.y = y;
                this.watermarkWithText(pdfContentByte, x, y);
            }
        }
    }

    private int[] checkCrossPage(PdfReader pdfReader, int pageNum) {
        int[] crossPage = new int[3];
        float textWidth = (float)this.text.length() * this.fontSize;
        float textHeight = this.fontSize;
        float pageHeight = pdfReader.getPageSizeWithRotation(pageNum).getHeight();
        float diagonal = (float)Math.sqrt(Math.pow(textWidth, 2.0) + Math.pow(textHeight, 2.0));
        double diagonalAngle = Math.atan(textHeight / textWidth);
        double textVerticalHeight = 0.0;
        float quadrant = this.rotation % 360.0f;
        double rotationInRadians = Math.toRadians(quadrant);
        if (quadrant == 0.0f) {
            if (textHeight > pageHeight) {
                crossPage[0] = 1;
                crossPage[1] = 1;
            }
        } else if (quadrant == 180.0f) {
            if (this.y < textHeight) {
                crossPage[0] = 1;
                crossPage[2] = 1;
            }
        } else if (quadrant == 90.0f || quadrant == 270.0f) {
            if (pageHeight - this.y < textWidth / 2.0f) {
                crossPage[0] = 1;
                crossPage[1] = 1;
            }
            if (this.y < textWidth / 2.0f) {
                crossPage[0] = 1;
                crossPage[2] = 1;
            }
        } else {
            double gap = (double)(textHeight / 2.0f) * this.absCos(rotationInRadians);
            if (0.0f < quadrant && quadrant < 90.0f) {
                textVerticalHeight = (double)diagonal * this.absSin(rotationInRadians + diagonalAngle);
                this.toUp = textVerticalHeight / 2.0 + gap;
            } else if (90.0f < quadrant && quadrant < 180.0f) {
                textVerticalHeight = (double)diagonal * this.absSin(rotationInRadians - diagonalAngle);
                this.toUp = textVerticalHeight / 2.0 - gap;
            } else if (180.0f < quadrant && quadrant < 270.0f) {
                textVerticalHeight = (double)diagonal * this.absSin(rotationInRadians + diagonalAngle);
                this.toUp = textVerticalHeight / 2.0 - gap;
            } else if (270.0f < quadrant && quadrant < 360.0f) {
                textVerticalHeight = (double)diagonal * this.absSin(rotationInRadians - diagonalAngle);
                this.toUp = textVerticalHeight / 2.0 + gap;
            }
            this.toBottom = textVerticalHeight - this.toUp;
            if ((double)this.y + this.toUp > (double)pageHeight) {
                crossPage[0] = 1;
                crossPage[1] = 1;
            }
            if ((double)this.y < this.toBottom) {
                crossPage[0] = 1;
                crossPage[2] = 1;
            }
        }
        return crossPage;
    }

    private double absSin(double radian) {
        return Math.abs(Math.sin(radian));
    }

    private double absCos(double radian) {
        return Math.abs(Math.cos(radian));
    }

    private void multiTextWatermark(PdfReader pdfReader, PdfContentByte pdfContentByte, int pagen) {
        if (this.crossPage) {
            int[] prePageCrossPageInfo;
            int[] crossPageArray = this.checkCrossPage(pdfReader, pagen);
            this.pageCrossPageMap.put(pagen, crossPageArray);
            Rectangle rectangle = pdfReader.getPageSizeWithRotation(pagen);
            float pageWidth = rectangle.getWidth();
            float pageHeight = rectangle.getHeight();
            int totalNumberOfPages = pdfReader.getNumberOfPages();
            if (pagen != 1 && this.y == this.pageFirstRowY && this.pageCrossPageMap.size() > 0 && this.pageCrossPageMap.containsKey(pagen - 1) && (prePageCrossPageInfo = this.pageCrossPageMap.get(pagen - 1))[0] == 1 && prePageCrossPageInfo[2] == 1) {
                this.watermarkWithText(pdfContentByte, this.x, pageHeight + this.prePageLastRowY);
            }
            if (pagen != totalNumberOfPages && this.y == this.pageLastRowY && (double)(this.yDistance - this.y) < this.toUp) {
                this.watermarkWithText(pdfContentByte, this.x, this.y - this.yDistance);
            }
            this.pageWidthMap.put(pagen, Float.valueOf(pageWidth));
        }
        this.watermarkWithText(pdfContentByte, this.x, this.y);
    }

    private double[] getHorizontalAndVerticalLength(PdfReader pdfReader, PdfContentByte pdfContentByte, int pagen) {
        double[] horizontalAndVerticalLength = new double[2];
        float textWidth = (float)this.text.length() * this.fontSize;
        float textHeight = this.fontSize;
        if (this.density <= 0.0f || this.density > 1.0f) {
            this.density = 0.5f;
        }
        float quadrant = this.rotation % 360.0f;
        double rotationInRadians = Math.toRadians(quadrant);
        double textDiagonal = Math.sqrt(Math.pow(textWidth, 2.0) + Math.pow(textHeight, 2.0));
        double diagonalAngle = Math.atan(textHeight / textWidth);
        double textHorizontalLength = 0.0;
        double textVerticalHeight = 0.0;
        if (quadrant == 0.0f || quadrant == 180.0f) {
            textVerticalHeight = textHeight;
            textHorizontalLength = textWidth;
        } else if (quadrant == 90.0f || quadrant == 270.0f) {
            textVerticalHeight = textWidth;
            textHorizontalLength = textHeight;
        } else if (0.0f < quadrant && quadrant < 90.0f) {
            textVerticalHeight = textDiagonal * this.absSin(rotationInRadians + diagonalAngle);
            textHorizontalLength = textDiagonal * this.absCos(rotationInRadians + diagonalAngle);
        } else if (90.0f < quadrant && quadrant < 180.0f) {
            double inRadians_180 = Math.toRadians(180.0);
            textVerticalHeight = textDiagonal * this.absSin(inRadians_180 - rotationInRadians + diagonalAngle);
            textHorizontalLength = textDiagonal * this.absCos(inRadians_180 - rotationInRadians + diagonalAngle);
        } else if (180.0f < quadrant && quadrant < 270.0f) {
            double inRadians_180 = Math.toRadians(180.0);
            textVerticalHeight = textDiagonal * this.absSin(rotationInRadians - inRadians_180 + diagonalAngle);
            textHorizontalLength = textDiagonal * this.absCos(rotationInRadians - inRadians_180 + diagonalAngle);
        } else if (270.0f < quadrant && quadrant < 360.0f) {
            double inRadians_360 = Math.toRadians(360.0);
            textVerticalHeight = textDiagonal * this.absSin(inRadians_360 - rotationInRadians + diagonalAngle);
            textHorizontalLength = textDiagonal * this.absCos(inRadians_360 - rotationInRadians + diagonalAngle);
        }
        horizontalAndVerticalLength[0] = textHorizontalLength;
        horizontalAndVerticalLength[1] = textVerticalHeight;
        return horizontalAndVerticalLength;
    }

    private Map<Character, List<Float>> getXYCoordinateList(float pageMidPointX, float pageMidPointY, float xDistance, float yDistance, float pageWidth, float pageHeight) {
        HashMap<Character, List<Float>> xYCoordinateMap = new HashMap<Character, List<Float>>();
        ArrayList<Float> xList = new ArrayList<Float>();
        ArrayList<Float> yList = new ArrayList<Float>();
        float leftXCoordinate = pageMidPointX;
        float rightXCoordinate = pageMidPointX;
        if (this.crossPage && !this.startPage) {
            int i = 0;
            while (i < this.prePageColumnNum / 2) {
                if ((leftXCoordinate -= xDistance) > 0.0f) {
                    xList.add(Float.valueOf(leftXCoordinate));
                }
                ++i;
            }
            xList.add(Float.valueOf(pageMidPointX));
            i = 0;
            while (i < this.prePageColumnNum / 2) {
                if ((rightXCoordinate += xDistance) < pageWidth) {
                    xList.add(Float.valueOf(rightXCoordinate));
                }
                ++i;
            }
        } else {
            while (!((leftXCoordinate -= xDistance) < 0.0f)) {
                xList.add(Float.valueOf(leftXCoordinate));
            }
            xList.add(Float.valueOf(pageMidPointX));
            while (!((rightXCoordinate += xDistance) > pageWidth)) {
                xList.add(Float.valueOf(rightXCoordinate));
            }
        }
        float upYCoordinate = pageMidPointY;
        float bottomYCoordinate = pageMidPointY;
        while (!((upYCoordinate += yDistance) > pageHeight)) {
            yList.add(Float.valueOf(upYCoordinate));
        }
        int upYListSize = yList.size();
        this.pageFirstRowY = upYListSize >= 1 ? ((Float)yList.get(yList.size() - 1)).floatValue() : pageMidPointY;
        yList.add(Float.valueOf(pageMidPointY));
        while (!((bottomYCoordinate -= yDistance) < 0.0f)) {
            yList.add(Float.valueOf(bottomYCoordinate));
        }
        int yListSize = yList.size();
        this.pageLastRowY = yListSize > upYListSize ? ((Float)yList.get(yList.size() - 1)).floatValue() : pageMidPointY;
        xYCoordinateMap.put(Character.valueOf('x'), xList);
        xYCoordinateMap.put(Character.valueOf('y'), yList);
        return xYCoordinateMap;
    }

    public Object clone() throws CloneNotSupportedException {
        PdfWatermark pdfWatermark = (PdfWatermark)super.clone();
        return pdfWatermark;
    }
}

