/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.AcroFields;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.encrypt.ARCFour;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.kgcore.KGElectronicSeal;
import com.kinggrid.kgcore.SealInformation;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import com.kinggrid.pdf.executes.PdfSignature;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PdfSignature4KG
extends PdfSignature {
    public PdfSignature4KG(String keyPath, int sealNumb, String sealPwd) {
        this.kgElectronicSeal = new KGElectronicSeal(keyPath, sealNumb, sealPwd);
    }

    public PdfSignature4KG(String url, KGServerTypeEnum type, String keySN, String password, String signName) {
        this.kgElectronicSeal = new KGElectronicSeal(url, type, keySN, password, signName);
    }

    public PdfSignature4KG(String url, KGServerTypeEnum type, String keySN, String password, int index) {
        this.kgElectronicSeal = new KGElectronicSeal(url, type, keySN, password, index);
    }

    public void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        if (this.getImage() == null) {
            SealInformation sealInformation = this.kgElectronicSeal.getSeal();
            float width = Float.valueOf(sealInformation.getImgWidth()).floatValue() * this.cm2px();
            float height = Float.valueOf(sealInformation.getImgHeight()).floatValue() * this.cm2px();
            String imgExt = sealInformation.getImgFileExt().substring(1);
            this.setImage(sealInformation.getImgValue(), imgExt, (int)width, (int)height);
            this.kgProperty(pdfReader, sealInformation.getKeySN(), sealInformation.getImgUserName(), sealInformation.getImgUnitName(), sealInformation.getSignSN(), sealInformation.getImgSignName(), "0", "", "127.0.0.1");
            if (this.logEntity != null) {
                this.logEntity.setLogType("00");
                this.logEntity.setLogSort("13");
                this.logEntity.setKeySN(sealInformation.getKeySN());
                this.logEntity.setSignSN(sealInformation.getSignSN());
            }
        }
        this.addText2Img();
    }

    private void kgProperty(PdfReader pdfReader, String keySN, String userName, String unitName, String signSN, String signName, String signatureType, String mac, String ip) {
        InputStream in = null;
        ARCFour rc4 = new ARCFour();
        KGBase64 base64 = new KGBase64();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                in = PdfSignature4KG.class.getResourceAsStream("/com/kinggrid/pdf/resources/KGProperty.xml");
                if (in != null) {
                    byte[] buff = new byte[in.available()];
                    in.read(buff);
                    String property = new String(buff, "UTF-8");
                    String index = "0";
                    AcroFields acroFields = pdfReader.getAcroFields();
                    if (acroFields != null) {
                        ArrayList<String> names = acroFields.getSignatureNames();
                        index = String.valueOf(names.size());
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("@index@", index);
                    map.put("@IP@", ip);
                    map.put("@MAC@", mac);
                    map.put("@userName@", userName);
                    map.put("@unitName@", unitName);
                    map.put("@signName@", signName);
                    map.put("@keySN@", keySN);
                    map.put("@signSN@", signSN);
                    map.put("@signatureType@", signatureType);
                    for (Map.Entry entry : map.entrySet()) {
                        String value = (String)entry.getValue();
                        if (value == null) {
                            value = "";
                        }
                        property = property.replace((CharSequence)entry.getKey(), value);
                    }
                    rc4.setKey("www.goldgrid.com".getBytes());
                    rc4.write(property.getBytes("UTF-8"), (OutputStream)byteArrayOutputStream);
                    base64.setBase64Table("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*-");
                    String kgProperty = base64.encode(byteArrayOutputStream.toByteArray());
                    this.setKGProperty(kgProperty.getBytes());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.close(in);
            this.close(byteArrayOutputStream);
        }
    }

    private void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

