/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfContentByte;
import com.KGitextpdf.text.pdf.PdfFormField;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfSignatureAppearance;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfTemplate;
import com.kinggrid.pdf.enmu.KGImgScaleEnum;
import com.kinggrid.pdf.executes.AbstractSign;
import com.kinggrid.pdf.executes.signature.KGPdfSignaureExecute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PdfSignature
extends AbstractSign {
    private PdfIndirectReference refSig;
    private String fieldName;
    private KGImgScaleEnum imgscale = KGImgScaleEnum.SCALE_ABSOLUTE;
    private int certificationLevel = 0;
    private boolean notInvisible;
    private boolean notInvisibleHashSig;
    private byte[] kgProperty;
    private boolean qfzOnlyFirstIsSig;
    private boolean fristSigned = false;
    private List<KGPdfSignaureExecute> executes;

    public PdfIndirectReference getRefSig() {
        return this.refSig;
    }

    public void setRefSig(PdfIndirectReference refSig) {
        this.refSig = refSig;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getCertificationLevel() {
        return this.certificationLevel;
    }

    public void setCertificationLevel(int certificationLevel) {
        this.certificationLevel = certificationLevel;
    }

    public void setKGProperty(byte[] kgProperty) {
        this.kgProperty = kgProperty;
    }

    public boolean isQfzOnlyFirstIsSig() {
        return this.qfzOnlyFirstIsSig;
    }

    public void setQfzOnlyFirstIsSig(boolean qfzOnlyFirstIsSig) {
        this.qfzOnlyFirstIsSig = qfzOnlyFirstIsSig;
    }

    public KGImgScaleEnum getImgscale() {
        return this.imgscale;
    }

    public void setImgscale(KGImgScaleEnum imgscale) {
        this.imgscale = imgscale;
    }

    public void notInvisible() {
        this.notInvisible = true;
    }

    public void addExtraExecute(KGPdfSignaureExecute pdfSignaureExecute) {
        if (this.executes == null) {
            this.executes = new ArrayList<KGPdfSignaureExecute>();
        }
        this.executes.add(pdfSignaureExecute);
    }

    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        if (this.notInvisible) {
            if (!this.notInvisibleHashSig) {
                this.sign(pdfReader, pdfStamper, 1, null, null);
                this.notInvisibleHashSig = true;
            }
            return;
        }
        super.execute(pdfReader, pdfStamper, pagen);
    }

    protected void sign(PdfReader pdfReader, PdfStamper pdfStamper, int pagen, Image image, Rectangle rect) throws DocumentException {
        if (this.qfzOnlyFirstIsSig && this.fristSigned) {
            this.addImage(pdfStamper, pagen, image, rect);
            return;
        }
        String name = null;
        name = this.fieldName != null ? String.valueOf(this.fieldName) + UUID.randomUUID().toString() : UUID.randomUUID().toString();
        PdfSignatureAppearance appearance = pdfStamper.getSignatureAppearance();
        appearance.setImageScale(this.imgscale);
        appearance.setBlendMode(this.getBlendMode());
        Rectangle rectangle = rect;
        if (rectangle != null) {
            appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC);
            appearance.setVisibleSignature(rectangle, pagen, name);
            appearance.setSignatureGraphic(image);
            appearance.setAcro6Layers(false);
        } else {
            rectangle = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        }
        appearance.setCertificationLevel(this.certificationLevel);
        rectangle.normalize();
        PdfFormField sigField = PdfFormField.createSignature(appearance.getStamper().getWriter());
        sigField.setFieldName(name);
        sigField.put(PdfName.V, this.refSig);
        sigField.setFlags(132);
        sigField.setWidget(rectangle, null);
        if (this.executes != null) {
            for (KGPdfSignaureExecute pdfSignaureExecute : this.executes) {
                pdfSignaureExecute.execute(pdfStamper, sigField, pagen);
            }
        }
        PdfTemplate app = appearance.getAppearance();
        if (!this.notInvisible && this.isRotation()) {
            this.rotationApp(app, 360 - rect.getRotation());
        } else {
            this.rotationApp(app, 360 - this.getRotationAngle());
        }
        sigField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, app);
        sigField.setPage(pagen);
        sigField.put(new PdfName("PageNumber"), new PdfNumber(pagen));
        if (this.kgProperty != null) {
            try {
                PdfStream property = new PdfStream(this.kgProperty);
                PdfIndirectObject obj = pdfStamper.getWriter().addToBody(property);
                PdfIndirectReference ref = obj.getIndirectReference();
                sigField.put(new PdfName("KGPROPERTY"), ref);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        appearance.getStamper().addAnnotation((PdfAnnotation)sigField, pagen);
        appearance.resetApp();
        this.fristSigned = true;
    }

    private void addImage(PdfStamper pdfStamper, int pagen, Image image, Rectangle rect) throws DocumentException {
        PdfGState gstate = new PdfGState();
        gstate.setBlendMode(PdfGState.BM_MULTIPLY);
        rect.normalize();
        image.setAbsolutePosition(rect.getWidth(), rect.getHeight());
        PdfContentByte pdfContentByte = pdfStamper.getOverContent(pagen);
        pdfContentByte.beginMarkedContentSequence(new PdfName("KINGGRID"));
        pdfContentByte.setGState(gstate);
        image.setAbsolutePosition(rect.getLeft(), rect.getBottom());
        pdfContentByte.addImage(image);
        pdfContentByte.endMarkedContentSequence();
    }
}

