/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.executes.electronicseal.customize.PdfElecWriter;
import com.kinggrid.pdf.executes.electronicseal.customize.PdfElecWriterAspect;
import com.kinggrid.pdf.utils.HashPDFDoc10;
import com.kinggrid.pdf.utils.KGPdfUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfElectronicSealDetails
extends PdfElecWriter {
    private List<Signinfo> seals = new ArrayList<Signinfo>();

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.before(pdfReader, pdfStamper);
        this.addExtraExecute(new PdfElecWriterAspect(){

            public void execute(PdfReader pdfReader, PdfStamper pdfStamper, PdfDictionary annot, int pagen, String hash) throws IOException {
                if (KGElectronicSealName.SEAL.equals(annot.getAsName(PdfName.SUBTYPE))) {
                    Map<String, String> map = KGPdfUtils.parseSeal(annot);
                    PdfArray asArray = annot.getAsArray(PdfName.RECT);
                    if (map != null) {
                        Signinfo signinfo = new Signinfo();
                        signinfo.setIndex(Integer.valueOf(map.get("sealIndex")));
                        signinfo.setAppName(map.get("AppName"));
                        signinfo.setCompName(map.get("CompName"));
                        signinfo.setKeySn(map.get("KeySerial"));
                        signinfo.setSignSn(map.get("SealSerial"));
                        signinfo.setSignTime(map.get("CreateTime"));
                        signinfo.setUserName(map.get("UserName"));
                        signinfo.setSignName(map.get("KeyName"));
                        String hashType = map.get("hashType");
                        if (hashType != null) {
                            signinfo.setHashType(hashType);
                        }
                        String singleHash = map.get("strMd5");
                        signinfo.setHash(singleHash);
                        if (!singleHash.equalsIgnoreCase(hash)) {
                            signinfo.setTamper(true);
                        }
                        PdfDictionary info = annot.getAsDict(PdfName.INFO);
                        PdfNumber proversion = info.getAsNumber(KGElectronicSealName.PROVERSION);
                        if (hash != null) {
                            if (proversion.intValue() == 10) {
                                signinfo.setNewHash(HashPDFDoc10.debase64(hash));
                            } else {
                                signinfo.setNewHash(Hex.decode((String)hash));
                            }
                        }
                        PdfIndirectReference certRef = annot.getAsIndirectObject(new PdfName("certContext"));
                        PdfIndirectReference signDataRef = annot.getAsIndirectObject(new PdfName("certSignMsg"));
                        if (certRef != null) {
                            PRStream certStream = (PRStream)pdfReader.getPdfObject(certRef.getNumber());
                            byte[] certData = PdfReader.getStreamBytesRaw(certStream);
                            if (PdfName.FLATEDECODE.equals(certStream.get(PdfName.FILTER))) {
                                certData = PdfReader.FlateDecode(certData);
                            }
                            signinfo.setCert(new String(certData, "UTF-16LE").getBytes("UTF-8"));
                        }
                        if (signDataRef != null) {
                            PRStream signDataStream = (PRStream)pdfReader.getPdfObject(signDataRef.getNumber());
                            byte[] signData = PdfReader.getStreamBytesRaw(signDataStream);
                            if (PdfName.FLATEDECODE.equals(signDataStream.get(PdfName.FILTER))) {
                                signData = PdfReader.FlateDecode(signData);
                            }
                            signinfo.setSignData(new String(signData, "UTF-16LE").getBytes("UTF-8"));
                        }
                        Rectangle pagRect = pdfReader.getPageSize(pagen);
                        int rotation = pdfReader.getPageRotation(pagen);
                        float width = pagRect.getWidth();
                        float height = pagRect.getHeight();
                        Map<String, Float> ll = KGPdfUtils.RotationXY(asArray.getAsNumber(0).floatValue(), asArray.getAsNumber(1).floatValue(), width, height, rotation);
                        Map<String, Float> ur = KGPdfUtils.RotationXY(asArray.getAsNumber(2).floatValue(), asArray.getAsNumber(3).floatValue(), width, height, rotation);
                        Rectangle rect = new Rectangle(ll.get("x").floatValue(), ll.get("y").floatValue(), ur.get("x").floatValue(), ur.get("y").floatValue());
                        rect.normalize();
                        signinfo.setRect(rect);
                        PdfElectronicSealDetails.this.seals.add(signinfo);
                    }
                }
            }
        });
    }

    @Override
    protected void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.after(pdfReader, pdfStamper);
        Collections.sort(this.seals, new Comparator<Signinfo>(){

            @Override
            public int compare(Signinfo o1, Signinfo o2) {
                return o1.getIndex() > o2.getIndex() ? 1 : 0;
            }
        });
    }

    public List<Signinfo> getSeals() {
        return this.seals;
    }

    public class Signinfo {
        private int index;
        private String signName;
        private String appName;
        private String compName;
        private String userName;
        private String keySn;
        private String signSn;
        private String signTime;
        private String hash;
        private boolean isTamper;
        private byte[] cert;
        private byte[] signData;
        private byte[] newHash;
        private String hashType = "0";
        private Rectangle rect;

        public String getSignName() {
            return this.signName;
        }

        public void setSignName(String signName) {
            this.signName = signName;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getCompName() {
            return this.compName;
        }

        public void setCompName(String compName) {
            this.compName = compName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getKeySn() {
            return this.keySn;
        }

        public void setKeySn(String keySn) {
            this.keySn = keySn;
        }

        public String getSignSn() {
            return this.signSn;
        }

        public void setSignSn(String signSn) {
            this.signSn = signSn;
        }

        public String getSignTime() {
            return this.signTime;
        }

        public void setSignTime(String signTime) {
            this.signTime = signTime;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public boolean isTamper() {
            return this.isTamper;
        }

        public void setTamper(boolean isTamper) {
            this.isTamper = isTamper;
        }

        public byte[] getCert() {
            return this.cert;
        }

        public void setCert(byte[] cert) {
            this.cert = cert;
        }

        public byte[] getSignData() {
            return this.signData;
        }

        public void setSignData(byte[] signData) {
            this.signData = signData;
        }

        public byte[] getNewHash() {
            return this.newHash;
        }

        public void setNewHash(byte[] newHash) {
            this.newHash = newHash;
        }

        public String getHashType() {
            return this.hashType;
        }

        public void setHashType(String hashType) {
            this.hashType = hashType;
        }

        public Rectangle getRect() {
            return this.rect;
        }

        public void setRect(Rectangle rect) {
            this.rect = rect;
        }

        public String toString() {
            return "KgPdfSignInfo [index=" + this.index + ", signName=" + this.signName + ", appName=" + this.appName + ", compName=" + this.compName + ", userName=" + this.userName + ", keySn=" + this.keySn + ", signSn=" + this.signSn + ", signTime=" + this.signTime + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + (this.signTime == null ? 0 : this.signTime.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Signinfo other = (Signinfo)obj;
            if (this.index != other.index) {
                return false;
            }
            return !(this.signTime == null ? other.signTime != null : !this.signTime.equals(other.signTime));
        }
    }
}

