/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfAppearance;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfBoolean;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.Version;
import com.kinggrid.pdf.enmu.KGPoistionEnum;
import com.kinggrid.pdf.executes.AbstractSign;
import com.kinggrid.pdf.executes.electronicseal.KGDefaultMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import com.kinggrid.pdf.utils.HashPDFDoc10;
import com.kinggrid.pdf.utils.KGPdfUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfElectronicSeal
extends AbstractSign {
    private byte[] hash;
    private String strMd5;
    private String strMd6;
    private String keySN;
    private String keyName;
    private String compName;
    private String userName;
    private String signSN;
    private int sealNumb = -1;
    private PdfDictionary qfzFirstPage;
    private int qfzFirstPageNumb;
    private PdfAnnotation parentAnnot;
    private PdfArray childList;
    private List<KGPdfElectronicExecute> executes;
    private KGMessageDigest messageDigest;
    private int proversion = 6;
    private PdfNumber hashType = KGElectronicSealName.HASH_TYPE_SHA1;
    private String protectDoc = "1";
    private String sealMsg;
    private IBaseinfo baseinfoInter;
    private boolean onlyShowInIWebPDF = false;

    public void setBaseinfoInter(IBaseinfo baseinfoInter) {
        this.baseinfoInter = baseinfoInter;
    }

    public void onlyShowInIWebPDF() {
        this.onlyShowInIWebPDF = true;
    }

    @Override
    protected void sign(PdfReader pdfReader, PdfStamper pdfStamper, int pagen, Image image, Rectangle rect) throws DocumentException {
        this.sealNumb = this.getSealNum(pdfReader);
        PdfWriter pdfWriter = pdfStamper.getWriter();
        rect.normalize();
        PdfAnnotation annotation = new PdfAnnotation(pdfWriter, rect);
        annotation.put(new PdfName("id"), new PdfString(UUID.randomUUID().toString()));
        annotation.put(PdfName.TYPE, PdfName.ANNOT);
        annotation.put(PdfName.SUBTYPE, KGElectronicSealName.SEAL);
        annotation.setFlags(4);
        if (this.position == KGPoistionEnum.QFZ) {
            annotation.put(KGElectronicSealName.STRADDLETYPE, new PdfNumber(this.getStraddleType()));
        }
        PdfDictionary page = pdfReader.getPageN(pagen);
        PdfAppearance app = PdfAppearance.createAppearance(pdfWriter, rect.getWidth(), rect.getHeight());
        PdfGState gstate = new PdfGState();
        gstate.setBlendMode(this.getBlendMode());
        app.setGState(gstate);
        if (this.position == KGPoistionEnum.QFZ) {
            this.rotationApp(app, rect.getRotation());
        } else if (!this.isRotation()) {
            this.rotationApp(app, rect.getRotation() + (360 - this.getRotationAngle()));
        }
        app.addImage(image, rect.getWidth(), 0.0f, 0.0f, rect.getHeight(), 0.0f, 0.0f);
        if (this.onlyShowInIWebPDF) {
            annotation.setAppearanceGGP(PdfAnnotation.APPEARANCE_NORMAL, app);
        } else {
            annotation.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, app);
        }
        if (this.position == KGPoistionEnum.QFZ) {
            if (this.qfzFirstPage == null) {
                this.qfzFirstPage = page;
                this.qfzFirstPageNumb = pagen;
                this.parentAnnot = annotation;
                this.childList = new PdfArray();
                int straddle = 1;
                PdfNumber straddleNumb = pdfReader.getCatalog().getAsNumber(KGElectronicSealName.STRADDLE);
                if (straddleNumb != null) {
                    straddle = straddleNumb.intValue() + 1;
                }
                annotation.put(PdfName.INFO, this.getKGSealInfoRef(pdfReader, pdfStamper, image, annotation, pagen));
                this.doExecute(pdfStamper, annotation, pagen);
                pdfReader.getCatalog().put(KGElectronicSealName.SEALNUM, new PdfNumber(this.sealNumb + 1));
                pdfReader.getCatalog().put(KGElectronicSealName.STRADDLE, new PdfNumber(straddle));
            } else {
                annotation.put(PdfName.P, this.qfzFirstPage.getIndRef());
                annotation.put(PdfName.PARENT, this.parentAnnot.getIndirectReference());
                this.doExecute(pdfStamper, annotation, pagen);
                this.childList.add(page.getIndRef());
                this.childList.add(annotation.getIndirectReference());
                pdfStamper.addAnnotation(annotation, page);
            }
        } else {
            annotation.put(PdfName.INFO, this.getKGSealInfoRef(pdfReader, pdfStamper, image, annotation, pagen));
            this.doExecute(pdfStamper, annotation, pagen);
            pdfReader.getCatalog().put(KGElectronicSealName.SEALNUM, new PdfNumber(++this.sealNumb));
            pdfStamper.addAnnotation(annotation, page);
        }
    }

    private PdfIndirectReference getKGSealInfoRef(PdfReader pdfReader, PdfStamper pdfStamper, Image image, PdfAnnotation annotation, int pagen) {
        PdfDictionary dicInfo = new PdfDictionary();
        dicInfo.put(KGElectronicSealName.PROVERSION, new PdfNumber(this.proversion));
        dicInfo.put(KGElectronicSealName.UNICODE, new PdfBoolean(true));
        dicInfo.put(KGElectronicSealName.HASH_TYPE, this.hashType);
        if (this.sealMsg == null) {
            if (this.messageDigest == null) {
                this.messageDigest = new KGDefaultMessageDigest();
            }
            if (this.proversion == 10) {
                if (this.strMd5 == null) {
                    try {
                        this.hash = HashPDFDoc10.getHashByte(pdfReader, this.messageDigest);
                        this.strMd5 = HashPDFDoc10.base64(this.hash);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (this.strMd5 == null) {
                this.hash = KGPdfUtils.calculatePdfHash4Elec(pdfReader, this.messageDigest);
                this.strMd5 = new String(Hex.encode((byte[])this.hash));
            }
            String typeSign = "1";
            if (this.position == KGPoistionEnum.QFZ) {
                typeSign = "5";
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sealIndex", String.valueOf(this.sealNumb));
            map.put("Width", String.valueOf(image.getWidth()));
            map.put("Height", String.valueOf(image.getHeight()));
            map.put("actWidth", String.valueOf(image.getScaledWidth()));
            map.put("actHeight", String.valueOf(image.getScaledHeight()));
            map.put("bProtectDoc", this.protectDoc);
            map.put("bEffect", "1");
            map.put("bCertSign", "0");
            map.put("AppName", Version.getApiVersion());
            map.put("KeyName", this.keyName);
            map.put("CompName", this.compName);
            map.put("UserName", this.userName);
            map.put("KeySerial", this.keySN);
            map.put("SealSerial", this.signSN);
            map.put("CreateTime", KGDateUtils.dateTime(new Date()));
            map.put("strMd5", this.strMd5);
            map.put("strMd6", this.strMd6);
            map.put("typeSign", typeSign);
            map.put("doffSign", "0");
            map.put("DateCheck", "0");
            map.put("noConnection", "0");
            if (this.baseinfoInter != null) {
                this.baseinfoInter.invoke(map, pdfStamper, annotation, pagen, this.strMd5);
            }
            KGBase64 base64 = new KGBase64();
            base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
            try {
                this.sealMsg = base64.encode(this.getBaseInfo(map).getBytes("UTF-16LE"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        PdfWriter pdfWriter = pdfStamper.getWriter();
        try {
            PdfStream baseInfo = new PdfStream(this.sealMsg.getBytes());
            PdfNumber pdfNumber = new PdfNumber(this.sealMsg.length());
            PdfIndirectObject pdfNumberIndObj = pdfWriter.addToBody(pdfNumber);
            baseInfo.put(KGElectronicSealName.STRLEN, pdfNumberIndObj.getIndirectReference());
            PdfIndirectObject baseInfoIndObj = pdfWriter.addToBody(baseInfo);
            dicInfo.put(KGElectronicSealName.BASEINFO, baseInfoIndObj.getIndirectReference());
            PdfIndirectObject dicInfoUndObj = pdfWriter.addToBody(dicInfo);
            this.sealMsg = null;
            return dicInfoUndObj.getIndirectReference();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.before(pdfReader, pdfStamper);
        this.proversion = Integer.valueOf(Version.getProperty("proversion"));
    }

    @Override
    public void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        if (this.position == KGPoistionEnum.QFZ) {
            this.parentAnnot.put(KGElectronicSealName.CHILDLIST, this.childList);
            pdfStamper.addAnnotation(this.parentAnnot, this.qfzFirstPageNumb);
        }
        pdfStamper.markUsed(pdfReader.getCatalog());
        super.after(pdfReader, pdfStamper);
    }

    private int getSealNum(PdfReader pdfReader) {
        PdfNumber pdfNumber = pdfReader.getCatalog().getAsNumber(KGElectronicSealName.SEALNUM);
        if (pdfNumber != null) {
            return pdfNumber.intValue();
        }
        return 0;
    }

    public void addExtraExecute(KGPdfElectronicExecute execute) {
        if (this.executes == null) {
            this.executes = new ArrayList<KGPdfElectronicExecute>();
        }
        this.executes.add(execute);
    }

    private void doExecute(PdfStamper pdfStamper, PdfAnnotation annotation, int pagen) {
        if (this.executes != null) {
            for (KGPdfElectronicExecute pdfElectronicExecute : this.executes) {
                pdfElectronicExecute.execute(pdfStamper, annotation, pagen, this.strMd5);
            }
        }
    }

    private String getBaseInfo(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            builder.append(String.valueOf(key) + "=" + map.get(key)).append("\r\n");
        }
        return builder.toString();
    }

    public PdfNumber getHashType() {
        return this.hashType;
    }

    public void setHashType(PdfNumber hashType) {
        this.hashType = hashType;
    }

    public int getSealNumb() {
        return this.sealNumb;
    }

    public void setSealNumb(int sealNumb) {
        this.sealNumb = sealNumb;
    }

    public void setSealMsg(String keySN, String unitName, String userName, String signSN, String signName) {
        this.keySN = keySN;
        this.compName = unitName;
        this.userName = userName;
        this.signSN = signSN;
        this.keyName = signName;
    }

    public void setMessageDigest(KGMessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    public String getHash() {
        return this.strMd5;
    }

    public String getProtectDoc() {
        return this.protectDoc;
    }

    public void setProtectDoc(String protectDoc) {
        this.protectDoc = protectDoc;
    }

    public String getSealMsg() {
        return this.sealMsg;
    }

    public void setSealMsg(String sealMsg) {
        this.sealMsg = sealMsg;
    }

    public int getProversion() {
        return this.proversion;
    }

    public void setProversion(int proversion) {
        this.proversion = proversion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IBaseinfo {
        public void invoke(Map<String, String> var1, PdfStamper var2, PdfAnnotation var3, int var4, String var5);
    }
}

