/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfBoolean;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGExecute;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteElectronicSeal
extends KGExecute {
    private boolean deleteLastOneSeal;
    private boolean hasDeleteLast;
    private int lastQfzRef;
    private int straddleNum = -1;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        int numb = this.getSealNum(pdfReader);
        if (this.straddleNum == -1) {
            this.straddleNum = this.getStraddleNum(pdfReader);
        }
        if (this.straddleNum == 0 && !this.deleteLastOneSeal && numb <= 0) {
            return;
        }
        if (this.hasDeleteLast) {
            return;
        }
        PdfDictionary page = pdfReader.getPageN(pagen);
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        int delSealNumb = 0;
        int delStraddleNum = 0;
        if (annots != null) {
            int i = annots.size() - 1;
            while (i >= 0) {
                PdfDictionary annot = annots.getAsDict(i);
                if (annot != null && KGElectronicSealName.SEAL.equals(annot.getAsName(PdfName.SUBTYPE))) {
                    PdfDictionary info = annot.getAsDict(PdfName.INFO);
                    PdfNumber straddletype = annot.getAsNumber(KGElectronicSealName.STRADDLETYPE);
                    if (!this.deleteLastOneSeal) {
                        if (info != null) {
                            ++delSealNumb;
                            if (straddletype != null) {
                                ++delStraddleNum;
                            }
                        } else {
                            pdfStamper.markUsed(annots);
                            pdfStamper.markUsed(page);
                        }
                        annots.remove(i);
                    } else if (info != null) {
                        PdfBoolean unicode = info.getAsBoolean(KGElectronicSealName.UNICODE);
                        boolean isUnicode = false;
                        if (unicode != null) {
                            isUnicode = unicode.booleanValue();
                        }
                        String charSet = "GBK";
                        if (isUnicode) {
                            charSet = "UTF-16LE";
                        }
                        PRStream baseInfo = (PRStream)info.getAsStream(KGElectronicSealName.BASEINFO);
                        byte[] baseInfob = PdfReader.getStreamBytes(baseInfo);
                        KGBase64 base64 = new KGBase64();
                        base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
                        String sealDetail = new String(base64.decode(new String(baseInfob)), charSet);
                        Map<String, String> map = this.getBaseInfo(sealDetail);
                        int sealIndex = Integer.valueOf(map.get("sealIndex"));
                        if (sealIndex == numb - 1) {
                            ++delSealNumb;
                            annots.remove(i);
                            if (straddletype != null) {
                                this.lastQfzRef = annot.getIndRef().getNumber();
                            } else {
                                this.hasDeleteLast = true;
                                break;
                            }
                        }
                    } else {
                        PdfDictionary parent = annot.getAsDict(PdfName.PARENT);
                        if (parent != null && this.lastQfzRef == parent.getIndRef().getNumber()) {
                            annots.remove(i);
                            pdfStamper.markUsed(annots);
                            pdfStamper.markUsed(page);
                        }
                    }
                }
                --i;
            }
        }
        if (delSealNumb > 0) {
            PdfDictionary root = pdfReader.getCatalog();
            if (numb >= delSealNumb) {
                numb -= delSealNumb;
            }
            root.put(KGElectronicSealName.SEALNUM, new PdfNumber(numb));
            if (delStraddleNum > 0) {
                root.put(KGElectronicSealName.STRADDLE, new PdfNumber(this.getStraddleNum(pdfReader) - delStraddleNum));
            }
            pdfStamper.markUsed(annots);
            pdfStamper.markUsed(page);
        }
    }

    @Override
    public void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        pdfStamper.markUsed(pdfReader.getCatalog());
    }

    public boolean isDeleteLastOneSeal() {
        return this.deleteLastOneSeal;
    }

    public void setDeleteLastOneSeal(boolean deleteLastOneSeal) {
        this.deleteLastOneSeal = deleteLastOneSeal;
    }

    private int getSealNum(PdfReader pdfReader) {
        return this.getStraddleNum(pdfReader, KGElectronicSealName.SEALNUM);
    }

    private int getStraddleNum(PdfReader pdfReader) {
        return this.getStraddleNum(pdfReader, KGElectronicSealName.STRADDLE);
    }

    private int getStraddleNum(PdfReader pdfReader, PdfName name) {
        PdfNumber pdfNumber = pdfReader.getCatalog().getAsNumber(name);
        if (pdfNumber != null) {
            return pdfNumber.intValue();
        }
        return 0;
    }

    private Map<String, String> getBaseInfo(String string) {
        String[] strings;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = strings = string.split("\r\n");
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            int indx = str.indexOf("=");
            if (indx != -1) {
                map.put(str.substring(0, indx), str.substring(indx + 1));
            }
            ++n2;
        }
        return map;
    }
}

