/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.core;

import com.KGitextpdf.awt.geom.Rectangle2D;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.CMapAwareDocumentFont;
import com.KGitextpdf.text.pdf.parser.ImageRenderInfo;
import com.KGitextpdf.text.pdf.parser.Matrix;
import com.KGitextpdf.text.pdf.parser.RenderListener;
import com.KGitextpdf.text.pdf.parser.TextRenderInfo;
import com.kinggrid.pdf.core.Coordinate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGTextMarginFinder
implements RenderListener {
    private Rectangle2D.Float textRectangle = null;
    private List<TextRenderInfo> renderInfos = new ArrayList<TextRenderInfo>();
    private float lx = -1.0f;
    private float ly = -1.0f;
    private StringBuilder text = new StringBuilder();
    private List<String> texts = null;
    private int[] indexOfTexts = null;
    private boolean onceFindReturn = false;
    private boolean onceFined = false;
    private boolean landscape;
    private List<Coordinate> positions = null;
    private List<Rectangle> rectangles = null;
    private List<Matrix> matrixs = null;
    private List<Matrix> dblIocnMatrixs = null;
    private boolean findByImageN = false;

    public void setTexts(String text) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(text);
        this.setTexts(list);
    }

    public void setTextsOnceFind(String text) {
        this.texts = new ArrayList<String>();
        this.texts.add(text);
        this.onceFindReturn = true;
        this.onceFined = false;
        this.indexOfTexts = new int[this.texts.size()];
        Arrays.fill(this.indexOfTexts, 0);
        this.positions = new ArrayList<Coordinate>();
        this.rectangles = new ArrayList<Rectangle>();
    }

    public void setTexts(List<String> texts) {
        this.onceFindReturn = false;
        this.onceFined = false;
        this.texts = texts;
        this.indexOfTexts = new int[texts.size()];
        Arrays.fill(this.indexOfTexts, 0);
        this.positions = new ArrayList<Coordinate>();
        this.rectangles = new ArrayList<Rectangle>();
    }

    public List<Coordinate> getPositions() {
        this.finallyLineFindText();
        return this.positions;
    }

    public List<Rectangle> getRectangles() {
        this.finallyLineFindText();
        return this.rectangles;
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        if (this.onceFined) {
            return;
        }
        if (this.texts == null || this.texts.size() == 0) {
            return;
        }
        this.textRectangle = renderInfo.getDescentLine().getBoundingRectange();
        if (Float.isNaN(this.textRectangle.x) && Float.isNaN(this.textRectangle.y) && Float.isNaN(this.textRectangle.width) && Float.isNaN(this.textRectangle.height)) {
            return;
        }
        String currentText = renderInfo.getText().trim();
        if (currentText.length() == 0) {
            return;
        }
        boolean isNewLine = false;
        boolean bl = this.landscape = this.textRectangle.getHeight() == 0.0;
        if (this.landscape) {
            if (Math.abs(this.getLly() - this.ly) > 3.0f && this.renderInfos.size() > 0) {
                isNewLine = true;
            }
            this.lx = -1.0f;
            this.ly = this.getLly();
        } else {
            if (Math.abs(this.getLlx() - this.lx) > 3.0f && this.renderInfos.size() > 0) {
                isNewLine = true;
            }
            this.lx = this.getLlx();
            this.ly = -1.0f;
        }
        if (!isNewLine) {
            this.renderInfos.add(renderInfo);
            return;
        }
        this.findText();
        this.text = new StringBuilder();
        Arrays.fill(this.indexOfTexts, 0);
        this.renderInfos.clear();
        this.renderInfos.add(renderInfo);
    }

    private void findText() {
        if (this.landscape) {
            Collections.sort(this.renderInfos, new Comparator<TextRenderInfo>(){

                @Override
                public int compare(TextRenderInfo o1, TextRenderInfo o2) {
                    float f1 = o1.getDescentLine().getBoundingRectange().x;
                    float f2 = o2.getDescentLine().getBoundingRectange().x;
                    return Float.compare(f1, f2);
                }
            });
        } else {
            Collections.sort(this.renderInfos, new Comparator<TextRenderInfo>(){

                @Override
                public int compare(TextRenderInfo o1, TextRenderInfo o2) {
                    float f1 = o1.getDescentLine().getBoundingRectange().y;
                    float f2 = o2.getDescentLine().getBoundingRectange().y;
                    return Float.compare(f1, f2);
                }
            });
        }
        for (TextRenderInfo textRenderInfo : this.renderInfos) {
            this.text.append(textRenderInfo.getText().trim());
        }
        int k = 0;
        while (k < this.texts.size()) {
            String text_position = this.texts.get(k);
            int len = text_position.length();
            String lineText = this.text.toString();
            int i = this.indexOfTexts[k];
            while ((i = lineText.indexOf(text_position, i)) != -1) {
                int length = 0;
                boolean hasStart = false;
                float startX = 0.0f;
                float startY = 0.0f;
                for (TextRenderInfo textRenderInfo : this.renderInfos) {
                    float textRenderInfoWidth;
                    float width;
                    float textWidth;
                    CMapAwareDocumentFont font;
                    Rectangle2D.Float rectangle;
                    String ltext = textRenderInfo.getText().trim();
                    int ltext_length = ltext.length();
                    if (!hasStart && length + ltext_length >= i + 1) {
                        hasStart = true;
                        int start = i - length;
                        rectangle = textRenderInfo.getDescentLine().getBoundingRectange();
                        font = (CMapAwareDocumentFont)textRenderInfo.getFont();
                        textWidth = font.getWidth(ltext);
                        width = 0.0f;
                        textRenderInfoWidth = 0.0f;
                        textRenderInfoWidth = this.landscape ? (float)rectangle.getWidth() : (float)rectangle.getHeight();
                        width = textWidth != 0.0f ? (float)font.getWidth(ltext.substring(0, start)) / textWidth * textRenderInfoWidth : textRenderInfoWidth / (float)ltext_length * (float)start;
                        if (this.landscape) {
                            startX = rectangle.x + width;
                            startY = rectangle.y;
                        } else {
                            startX = rectangle.x;
                            startY = rectangle.y + width;
                        }
                    }
                    if (hasStart && length + ltext_length >= i + len) {
                        int end = i + len - length;
                        rectangle = textRenderInfo.getAscentLine().getBoundingRectange();
                        font = (CMapAwareDocumentFont)textRenderInfo.getFont();
                        textWidth = font.getWidth(ltext);
                        width = 0.0f;
                        textRenderInfoWidth = 0.0f;
                        textRenderInfoWidth = this.landscape ? (float)rectangle.getWidth() : (float)rectangle.getHeight();
                        width = textWidth != 0.0f ? (float)font.getWidth(ltext.substring(0, end)) / textWidth * textRenderInfoWidth : (textRenderInfoWidth != 0.0f ? textRenderInfoWidth / (float)ltext_length * (float)end : textRenderInfo.getFontSize() * (float)end);
                        float endX = 0.0f;
                        float endY = 0.0f;
                        if (this.landscape) {
                            endX = rectangle.x + width;
                            endY = rectangle.y;
                        } else {
                            endX = rectangle.x;
                            endY = rectangle.y + width;
                        }
                        Coordinate coordinate = new Coordinate();
                        coordinate.setX((endX + startX) / 2.0f);
                        coordinate.setY((endY + startY) / 2.0f);
                        coordinate.setText(text_position);
                        this.positions.add(coordinate);
                        Rectangle rect = new Rectangle(startX, startY, endX, endY);
                        this.rectangles.add(rect);
                        hasStart = false;
                        if (!this.onceFindReturn) break;
                        this.onceFined = true;
                        return;
                    }
                    length += ltext_length;
                }
                this.indexOfTexts[k] = i += len;
            }
            ++k;
        }
    }

    private void finallyLineFindText() {
        this.findText();
    }

    public float getLlx() {
        return this.textRectangle.x;
    }

    public float getLly() {
        return this.textRectangle.y;
    }

    public float getUrx() {
        return this.textRectangle.x + this.textRectangle.width;
    }

    public float getUry() {
        return this.textRectangle.y + this.textRectangle.height;
    }

    public float getWidth() {
        return this.textRectangle.width;
    }

    public float getHeight() {
        return this.textRectangle.height;
    }

    @Override
    public void beginTextBlock() {
    }

    @Override
    public void endTextBlock() {
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
        if (this.findByImageN) {
            if (this.matrixs == null) {
                this.matrixs = new ArrayList<Matrix>();
            }
            this.matrixs.add(renderInfo.getImageCTM());
        }
    }

    public void setFindByImageN(boolean findByImageN) {
        this.findByImageN = findByImageN;
    }

    public boolean getFindByImageN() {
        return this.findByImageN;
    }

    public List<Matrix> getDblMarixIndex() {
        if (this.dblIocnMatrixs == null && this.matrixs != null) {
            this.dblIocnMatrixs = new ArrayList<Matrix>();
            HashMap<String, Matrix> maps = new HashMap<String, Matrix>();
            int i = 0;
            while (i < this.matrixs.size()) {
                Matrix matrix = this.matrixs.get(i);
                if (matrix != null) {
                    String key = String.valueOf(matrix.get(0)) + " " + matrix.get(4) + " " + matrix.get(6) + " " + matrix.get(7);
                    if (!maps.containsKey(key)) {
                        maps.put(key, matrix);
                    } else {
                        this.dblIocnMatrixs.add(matrix);
                    }
                }
                ++i;
            }
        }
        return this.dblIocnMatrixs;
    }
}

