/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.PageSize;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.io.FileChannelRandomAccessSource;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfAppearance;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfCopy;
import com.KGitextpdf.text.pdf.PdfCopyFields;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfFormField;
import com.KGitextpdf.text.pdf.PdfImportedPage;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfLiteral;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfRectangle;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.KGitextpdf.text.pdf.RandomAccessFileOrArray;
import com.KGitextpdf.text.pdf.SimpleBookmark;
import com.KGitextpdf.text.pdf.TextField;
import com.KGitextpdf.text.pdf.codec.TiffImage;
import com.KGitextpdf.text.pdf.parser.PdfReaderContentParser;
import com.kinggrid.authorization.AuthorizationMethod;
import com.kinggrid.authorization.KGLicense;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.core.KGTextMarginFinder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGPdfHummerUtils {
    private PdfReader pdfReader;
    private PdfStamper pdfStamper;

    protected KGPdfHummerUtils(PdfReader pdfReader, PdfStamper pdfStamper) {
        this.pdfReader = pdfReader;
        this.pdfStamper = pdfStamper;
    }

    public List<Rectangle> getPositionByText(int pageNumber, String text, boolean once) throws IOException {
        PdfReaderContentParser pdfReaderContentParser = new PdfReaderContentParser(this.pdfReader);
        KGTextMarginFinder textMarginFinder = new KGTextMarginFinder();
        if (once) {
            textMarginFinder.setTextsOnceFind(text);
        } else {
            textMarginFinder.setTexts(text);
        }
        pdfReaderContentParser.processContent(pageNumber, textMarginFinder);
        return textMarginFinder.getRectangles();
    }

    public void addFieldWithoutSignature(String fieldName, Rectangle rectangle, int page) throws IOException {
        PdfWriter writer = this.pdfStamper.getWriter();
        PdfFormField field = PdfFormField.createSignature(writer);
        field.setWidget(rectangle, null);
        field.setFieldName(fieldName);
        field.setFlags(4);
        field.setPage(page);
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(writer, rectangle.getWidth(), rectangle.getHeight());
        pdfAppearance.rectangle(rectangle);
        pdfAppearance.stroke();
        field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        this.pdfStamper.addAnnotation((PdfAnnotation)field, page);
    }

    public void addBtnField(String fieldName, Rectangle rectangle, int page) throws IOException {
        PdfFormField btn = PdfFormField.createPushButton(this.pdfStamper.getWriter());
        btn.setFieldName(fieldName);
        btn.setWidget(rectangle, PdfAnnotation.HIGHLIGHT_PUSH);
        this.pdfStamper.addAnnotation((PdfAnnotation)btn, page);
    }

    public TextField createTextField(String fieldName, Rectangle rectangle, String defaultText) {
        TextField text = new TextField(this.pdfStamper.getWriter(), rectangle, fieldName);
        text.setBorderWidth(0.5f);
        text.setBorderStyle(3);
        text.setText(defaultText);
        return text;
    }

    public void addTextField(TextField text, int page, boolean multiline, boolean password, int maxLen) throws IOException, DocumentException {
        PdfFormField textField = text.getTextField();
        int flags = multiline ? 4096 : 0;
        textField.put(PdfName.FF, new PdfNumber(flags += password ? 8192 : 0));
        if (maxLen > 0) {
            textField.put(PdfName.MAXLEN, new PdfNumber(maxLen));
        }
        this.pdfStamper.addAnnotation((PdfAnnotation)textField, page);
    }

    public void sealVector(String sealInfo) throws IOException, org.dom4j.DocumentException {
        Document document = DocumentHelper.parseText((String)sealInfo);
        List list = document.selectNodes("/Signature/Item");
        KGBase64 kgBase64 = new KGBase64();
        for (Element element : list) {
            String page = element.selectSingleNode("page").getText();
            float left = Float.valueOf(element.selectSingleNode("left").getText()).floatValue();
            float top = Float.valueOf(element.selectSingleNode("top").getText()).floatValue();
            float right = Float.valueOf(element.selectSingleNode("right").getText()).floatValue();
            float bottom = Float.valueOf(element.selectSingleNode("bottom").getText()).floatValue();
            String ap = element.selectSingleNode("ap").getText();
            byte[] vectorData = kgBase64.decode(ap);
            PdfAnnotation annot = new PdfAnnotation(this.pdfStamper.getWriter(), new Rectangle(left, top, right, bottom));
            annot.put(PdfName.SUBTYPE, new PdfName("kinggrid"));
            annot.put(PdfName.F, new PdfNumber(4));
            annot.put(PdfName.TYPE, PdfName.ANNOT);
            PdfStream N = new PdfStream(vectorData);
            N.put(PdfName.TYPE, PdfName.XOBJECT);
            N.put(PdfName.SUBTYPE, PdfName.FORM);
            N.put(PdfName.BBOX, new PdfRectangle(0.0f, 0.0f, right - left, bottom - top));
            N.put(PdfName.FORMTYPE, new PdfNumber(1));
            N.put(PdfName.MATRIX, new PdfLiteral("[1 0 0 1 0 0]"));
            PdfDictionary resources = new PdfDictionary();
            PdfArray procset = new PdfArray();
            procset.add(PdfName.PDF);
            procset.add(PdfName.TEXT);
            procset.add(PdfName.IMAGEB);
            procset.add(PdfName.IMAGEC);
            procset.add(PdfName.IMAGEI);
            resources.put(PdfName.PROCSET, procset);
            PdfDictionary xobject = new PdfDictionary();
            resources.put(PdfName.XOBJECT, xobject);
            N.put(PdfName.RESOURCES, resources);
            PdfIndirectObject pdfIndirectObject = this.pdfStamper.getWriter().addToBody(N);
            PdfDictionary AP = new PdfDictionary();
            AP.put(PdfName.N, pdfIndirectObject.getIndirectReference());
            annot.put(PdfName.AP, AP);
            this.pdfStamper.addAnnotation(annot, Integer.valueOf(page));
        }
    }

    public boolean isExistFont(String baseFont) {
        int xrefSize = this.pdfReader.getXrefSize();
        int i = 1;
        while (i < xrefSize) {
            PdfDictionary pdfDictionary;
            PdfName pdfName;
            PdfObject pdfObject = this.pdfReader.getPdfObjectRelease(i);
            if (pdfObject instanceof PdfDictionary && (pdfName = (PdfName)(pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.TYPE)) != null && "/Font".equals(pdfName.toString())) {
                PdfName fontName = (PdfName)pdfDictionary.get(PdfName.BASEFONT);
                try {
                    String fontType = new String(PdfName.decodeName(fontName.toString()).getBytes("ISO8859_1"), "GBK");
                    if (fontType.indexOf(baseFont) != -1) {
                        return true;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        return false;
    }

    @AuthorizationMethod(authEx=true)
    public void addFileAttachment(InputStream attachment, String attachmentFileName, String description) throws IOException, org.dom4j.DocumentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int len = -1;
        byte[] buff = new byte[1024];
        while ((len = attachment.read(buff)) != -1) {
            byteArrayOutputStream.write(buff, 0, len);
        }
        this.pdfStamper.addFileAttachment(description, byteArrayOutputStream.toByteArray(), null, attachmentFileName);
    }

    @AuthorizationMethod(authEx=true)
    public void addFileAttachment(String file, String attachmentFileName, String description) throws IOException {
        this.pdfStamper.addFileAttachment(description, null, file, attachmentFileName);
    }

    @AuthorizationMethod(authEx=true)
    public void addBookMarks(InputStream in) throws IOException, org.dom4j.DocumentException, org.dom4j.DocumentException {
        ArrayList bookmakes = (ArrayList)SimpleBookmark.importFromXML(in);
        this.pdfStamper.setOutlines(bookmakes);
    }

    public void addBookMarks(List<String> bookmarkList) throws IOException, org.dom4j.DocumentException {
        ArrayList<HashMap<String, Object>> bookmarks = new ArrayList<HashMap<String, Object>>();
        LinkedHashMap bookmarkMap = new LinkedHashMap();
        int page = 1;
        float x = 0.0f;
        float y = 0.0f;
        for (String bookmark : bookmarkList) {
            int indexOfSpace = bookmark.indexOf(" ");
            if (indexOfSpace == -1) {
                throw new RuntimeException("\u4e66\u7b7e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002(" + bookmark + ")");
            }
            String level = bookmark.substring(0, indexOfSpace);
            String title = bookmark.substring(indexOfSpace + 1).trim();
            HashMap<String, String> aBookmark = new HashMap<String, String>();
            aBookmark.put("Action", "GoTo");
            aBookmark.put("Title", title);
            int totalPages = this.pdfReader.getNumberOfPages();
            List<Rectangle> rectangleList = null;
            int i = page;
            while (i <= totalPages) {
                rectangleList = this.getPositionByText(i, title, true);
                if (rectangleList != null && rectangleList.size() > 0) {
                    page = i;
                    Rectangle rectangle = rectangleList.get(0);
                    x = rectangle.getLeft();
                    y = rectangle.getTop();
                    break;
                }
                ++i;
            }
            if (rectangleList == null || rectangleList.size() == 0) {
                throw new RuntimeException("\u6ca1\u6709\u5728\u6587\u6863\u4e2d\u627e\u5230\u4e66\u7b7e\u6587\u672c(" + bookmark + ")");
            }
            String pageAndPosition = String.valueOf(page) + " XYZ " + x + " " + y + " null";
            aBookmark.put("Page", pageAndPosition);
            Set keys = bookmarkMap.keySet();
            boolean hasParent = false;
            for (String key : keys) {
                int index = level.lastIndexOf(".");
                String parentLevel = index == -1 ? level : level.substring(0, index);
                if (!parentLevel.equals(key)) continue;
                ArrayList kids = (ArrayList)((HashMap)bookmarkMap.get(key)).get("Kids");
                if (kids == null) {
                    kids = new ArrayList();
                }
                kids.add(aBookmark);
                ((HashMap)bookmarkMap.get(key)).put("Kids", kids);
                hasParent = true;
            }
            bookmarkMap.put(level, aBookmark);
            if (hasParent) continue;
            bookmarks.add(aBookmark);
        }
        this.pdfStamper.setOutlines(bookmarks);
    }

    @AuthorizationMethod(authEx=true)
    public void extractPages(List<Integer> pagesToKeep, OutputStream os) throws DocumentException, IOException {
        this.pdfReader.selectPages(pagesToKeep);
        this.extractPages(os);
    }

    @AuthorizationMethod(authEx=true)
    public void extractPages(String ranges, OutputStream os) throws DocumentException, IOException {
        this.pdfReader.selectPages(ranges);
        this.extractPages(os);
    }

    private void extractPages(OutputStream os) throws DocumentException, IOException {
        com.KGitextpdf.text.Document document = new com.KGitextpdf.text.Document();
        PdfCopy copy = new PdfCopy(document, os);
        document.open();
        int i = 1;
        while (i <= this.pdfReader.getNumberOfPages()) {
            PdfImportedPage page = copy.getImportedPage(this.pdfReader, i);
            copy.addPage(page);
            ++i;
        }
        copy.close();
        document.close();
    }

    public List<Rectangle> getSigFieldsRectOfPageNum(int pageNum) {
        PdfDictionary pageDic = this.pdfReader.getPageNRelease(pageNum);
        PdfNumber pdfNumber = pageDic.getAsNumber(PdfName.ROTATE);
        int rotate = pdfNumber == null ? 0 : pdfNumber.intValue();
        Rectangle pageRect = this.pdfReader.getPageSize(pageNum);
        PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>();
        if (annots != null) {
            int i = 0;
            while (i < annots.size()) {
                PdfDictionary annot = annots.getAsDict(i);
                PdfName ft = annot.getAsName(PdfName.FT);
                if (ft != null && "/Sig".equals(ft.toString())) {
                    PdfArray array = annot.getAsArray(PdfName.RECT);
                    Rectangle rect = null;
                    rect = rotate == 90 ? new Rectangle(array.getAsNumber(1).floatValue(), pageRect.getWidth() - array.getAsNumber(2).floatValue(), array.getAsNumber(3).floatValue(), pageRect.getWidth() - array.getAsNumber(0).floatValue()) : (rotate == 180 ? new Rectangle(pageRect.getWidth() - array.getAsNumber(2).floatValue(), pageRect.getHeight() - array.getAsNumber(3).floatValue(), pageRect.getWidth() - array.getAsNumber(0).floatValue(), pageRect.getHeight() - array.getAsNumber(1).floatValue()) : (rotate == 270 ? new Rectangle(pageRect.getHeight() - array.getAsNumber(3).floatValue(), array.getAsNumber(0).floatValue(), pageRect.getHeight() - array.getAsNumber(1).floatValue(), array.getAsNumber(2).floatValue()) : new Rectangle(array.getAsNumber(0).floatValue(), array.getAsNumber(1).floatValue(), array.getAsNumber(2).floatValue(), array.getAsNumber(3).floatValue())));
                    rects.add(rect);
                }
                ++i;
            }
        }
        return rects;
    }

    public static void mergeMultiPdf(List<InputStream> srcs, OutputStream os) throws DocumentException, IOException {
        KGLicense.authorization(KGPdfHummerUtils.class.getName(), "mergeMultiPdf");
        PdfCopyFields copyFields = new PdfCopyFields(os);
        copyFields.open();
        int i = 0;
        while (i < srcs.size()) {
            PdfReader reader = new PdfReader(srcs.get(i));
            copyFields.addDocument(reader);
            ++i;
        }
        copyFields.close();
    }

    public static void CreatePDF4ImageList(List<Image> images, OutputStream os) throws DocumentException {
        if (images != null && images.size() < 1) {
            throw new RuntimeException("images.Count\u4e0d\u80fd\u4e3a0.");
        }
        com.KGitextpdf.text.Document document = new com.KGitextpdf.text.Document();
        PdfWriter pdfWriter = PdfWriter.getInstance(document, os);
        document.open();
        int i = 0;
        while (i < images.size()) {
            Image img = images.get(i);
            document.newPage();
            if (PageSize.A4.getWidth() < img.getWidth() || PageSize.A4.getHeight() < img.getHeight()) {
                img.scaleToFit(PageSize.A4.getWidth(), img.getHeight());
            }
            float x = (PageSize.A4.getWidth() - img.getScaledWidth()) / 2.0f;
            float y = (PageSize.A4.getHeight() - img.getScaledHeight()) / 2.0f;
            img.setAbsolutePosition(x, y);
            document.add(img);
            ++i;
        }
        document.close();
        pdfWriter.close();
    }

    public static void tiff2Pdf(String fileName, OutputStream os) throws IOException, DocumentException {
        RandomAccessFile raf = null;
        com.KGitextpdf.text.Document document = null;
        try {
            raf = new RandomAccessFile(fileName, "r");
            FileChannel channel = raf.getChannel();
            FileChannelRandomAccessSource fileChannelRandomAccessSource = new FileChannelRandomAccessSource(channel);
            RandomAccessFileOrArray ra = new RandomAccessFileOrArray(fileChannelRandomAccessSource);
            int pageNumber = TiffImage.getNumberOfPages(ra);
            document = new com.KGitextpdf.text.Document(PageSize.LETTER, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter.getInstance(document, os);
            document.open();
            int i = 1;
            while (i <= pageNumber) {
                Image image = TiffImage.getTiffImage(ra, i);
                image.scalePercent(7200.0f / (float)image.getDpiX(), 7200.0f / (float)image.getDpiY());
                document.setPageSize(new Rectangle(image.getScaledWidth(), image.getScaledHeight()));
                image.setAbsolutePosition(0.0f, 0.0f);
                document.add(image);
                document.newPage();
                ++i;
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
            if (document != null) {
                document.close();
            }
        }
    }

    public static void image2Pdf(String fileName, OutputStream os) throws IOException, DocumentException {
        com.KGitextpdf.text.Document document = null;
        try {
            Image image = Image.getInstance(fileName);
            Rectangle rect = null;
            if (image.getDpiX() != 0) {
                image.scalePercent(7200.0f / (float)image.getDpiX(), 7200.0f / (float)image.getDpiY());
                rect = new Rectangle(image.getScaledWidth(), image.getScaledHeight());
            } else {
                rect = new Rectangle(image.getWidth(), image.getHeight());
            }
            document = new com.KGitextpdf.text.Document(rect, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter.getInstance(document, os);
            document.open();
            image.setAbsolutePosition(0.0f, 0.0f);
            document.add(image);
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }
}

