/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf;

import com.KGitextpdf.text.BadElementException;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.AcroFields;
import com.KGitextpdf.text.pdf.OutputStreamCounter;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfSignatureAppearance;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.security.BouncyCastleDigest;
import com.KGitextpdf.text.pdf.security.ExternalSignature;
import com.KGitextpdf.text.pdf.security.MakeSignature;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.KGitextpdf.text.pdf.security.PrivateKeySignature;
import com.KGitextpdf.text.pdf.security.TSAClient;
import com.KGitextpdf.text.pdf.security.TSAClientBouncyCastle;
import com.kinggrid.authorization.AuthorizationMethod;
import com.kinggrid.authorization.KGFacadeCglib;
import com.kinggrid.encrypt.KGSignature;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.KGPdfHummerUtils;
import com.kinggrid.pdf.SignatureInter;
import com.kinggrid.pdf.Version;
import com.kinggrid.pdf.core.PdfSignatureApCallback;
import com.kinggrid.pdf.enmu.KGPoistionEnum;
import com.kinggrid.pdf.executes.PdfElectronicSeal;
import com.kinggrid.pdf.executes.PdfSignature;
import com.kinggrid.pdf.executes.PdfSignature4KG;
import com.kinggrid.pdf.signinter.DigitalSignature;
import com.kinggrid.pdf.utils.NewAntiCopyImage;
import com.kinggrid.pdf.utils.PrintMarkUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGPdfHummer {
    private PdfReader pdfReader;
    private PdfStamper pdfStamper;
    private PrivateKey pk = null;
    private Certificate[] chain = null;
    private List<KGExecute> executes = new ArrayList<KGExecute>();
    private PdfSignature pdfSignature;
    private int pagen;
    private SignatureInter signatureInter;
    private TSAClient tsaClient;
    private KGPdfHummerUtils kGPdfHummerUtils;
    private boolean savePartial = true;
    private boolean relaseXObjectsAndPagesInfo = false;
    private int savePerPage = 10;
    private String reason;
    private String location;

    protected KGPdfHummer() {
    }

    public static KGPdfHummer createSignature(String fileName, byte[] ownerPassword, boolean partial, OutputStream os, File tmpDic, boolean append) throws IOException, DocumentException {
        return KGPdfHummer.createSignature(new PdfReader(fileName, ownerPassword, partial), os, tmpDic, append);
    }

    public static KGPdfHummer createSignature(InputStream in, byte[] ownerPassword, OutputStream os, File tmpDic, boolean append) throws IOException, DocumentException {
        return KGPdfHummer.createSignature(new PdfReader(in, ownerPassword), os, tmpDic, append);
    }

    private static KGPdfHummer createSignature(PdfReader pdfReader, OutputStream os, File tmpDic, boolean append) throws IOException, DocumentException {
        if (tmpDic != null && !tmpDic.isDirectory()) {
            throw new IllegalArgumentException("tmpDic\u4e0d\u662f\u6587\u4ef6\u5939.");
        }
        PdfStamper pdfStamper = PdfStamper.createSignature(pdfReader, os, '\u0000', tmpDic, append);
        KGPdfHummer hummer = KGPdfHummer.getInstance();
        hummer.setPdfReader(pdfReader);
        hummer.setPdfStamper(pdfStamper);
        hummer.setPdfSignature(new PdfSignature());
        return hummer;
    }

    public static KGPdfHummer createInstance(String fileName, byte[] ownerPassword, boolean partial, OutputStream os, boolean append) throws IOException, DocumentException {
        return KGPdfHummer.createInstance(new PdfReader(fileName, ownerPassword, partial), os, append);
    }

    public static KGPdfHummer createInstance(InputStream in, byte[] ownerPassword, OutputStream os, boolean append) throws IOException, DocumentException {
        return KGPdfHummer.createInstance(new PdfReader(in, ownerPassword), os, append);
    }

    private static KGPdfHummer createInstance(PdfReader pdfReader, OutputStream os, boolean append) throws IOException, DocumentException {
        PdfStamper pdfStamper = new PdfStamper(pdfReader, os, '\u0000', append);
        KGPdfHummer hummer = KGPdfHummer.getInstance();
        hummer.setPdfReader(pdfReader);
        hummer.setPdfStamper(pdfStamper);
        return hummer;
    }

    public static KGPdfHummer createInstance(String fileName, byte[] ownerPassword, boolean partial) throws IOException {
        KGPdfHummer hummer = KGPdfHummer.getInstance();
        hummer.setPdfReader(new PdfReader(fileName, ownerPassword, partial));
        return hummer;
    }

    public static KGPdfHummer createInstance(InputStream in, byte[] ownerPassword) throws IOException {
        KGPdfHummer hummer = KGPdfHummer.getInstance();
        hummer.setPdfReader(new PdfReader(in, ownerPassword));
        return hummer;
    }

    private static KGPdfHummer getInstance() {
        return (KGPdfHummer)KGFacadeCglib.getInstance(KGPdfHummer.class);
    }

    public void setCertificate(InputStream cert, String keystorePwd, String pwd) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KGSignature signature = new KGSignature(cert, keystorePwd, pwd);
        this.pk = signature.getPrivateKey();
        this.chain = signature.getChain();
    }

    public void setCertificate(Certificate cert, SignatureInter signatureInter) {
        this.chain = new Certificate[]{cert};
        this.signatureInter = signatureInter;
    }

    public void setCertificate(DigitalSignature digitalSignature) {
        this.chain = digitalSignature.getCertificate();
        this.signatureInter = digitalSignature;
    }

    public boolean verifyCertificateIsNotExpired() {
        KGSignature signature = new KGSignature(null, this.chain);
        return signature.verifyCertificateIsExpired();
    }

    public void setSigReasonLocaction(String reason, String location) {
        this.reason = reason;
        this.location = location;
    }

    @AuthorizationMethod(authEx=true)
    public void setTSAClient(String url, String username, String password) {
        this.tsaClient = new TSAClientBouncyCastle(url, username, password);
    }

    public void setTSAClient(String url, String username, String password, int tokSzEstimate, String digestAlgorithm) {
        this.tsaClient = new TSAClientBouncyCastle(url, username, password, tokSzEstimate, digestAlgorithm);
    }

    public void setTSAClient(TSAClient tsaClient) {
        this.tsaClient = tsaClient;
    }

    public void setPagen(int pagen) {
        this.pagen = pagen;
    }

    public void signature(String fieldName, Rectangle rect, Image image) {
        this.pdfSignature.setImage(image);
        this.pdfSignature.setRect(rect);
        this.pdfSignature.setFieldName(fieldName);
    }

    public void addExecute(KGExecute execute) {
        this.executes.add(execute);
        execute.setKGHummderExecutes(this.executes);
    }

    public void doSignature() throws IOException, DocumentException, GeneralSecurityException {
        PdfSignatureAppearance app = this.pdfStamper.getSignatureAppearance();
        app.setPdfSignatureApCallback(new PdfSignatureApCallbackImpl());
        app.setReason(this.reason);
        app.setLocation(this.location);
        ExternalSignature es = this.signatureInter;
        if (es == null) {
            es = new PrivateKeySignature(this.pk, "SHA1", "BC");
        }
        BouncyCastleDigest digest = new BouncyCastleDigest();
        MakeSignature.signDetached(app, digest, es, this.chain, null, null, this.tsaClient, 0, MakeSignature.CryptoStandard.CMS);
    }

    public void doExecute() throws DocumentException, IOException {
        PdfSignatureApCallbackImpl pdfSignatureApCallback = new PdfSignatureApCallbackImpl();
        ((PdfSignatureApCallback)pdfSignatureApCallback).execute(null);
        if (this.pdfStamper != null) {
            this.pdfStamper.close();
        }
    }

    public void close() {
        if (this.pdfStamper != null) {
            PdfSignatureAppearance app;
            OutputStreamCounter os = this.pdfStamper.getWriter().getOs();
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if ((app = this.pdfStamper.getSignatureAppearance()) != null) {
                app.closeException();
            }
        }
        this.pdfReader.close();
    }

    @AuthorizationMethod(authEx=true)
    public String verifySignatures() throws IOException, GeneralSecurityException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        AcroFields acroFields = this.pdfReader.getAcroFields();
        ArrayList<String> signatureNames = acroFields.getSignatureNames();
        boolean signatureCoversWholeDocument = false;
        if (signatureNames.size() == 0) {
            return "-1";
        }
        for (String name : signatureNames) {
            PdfPKCS7 pk = acroFields.verifySignature(name);
            if (!pk.verify()) {
                return "0";
            }
            if (!acroFields.signatureCoversWholeDocument(name)) continue;
            signatureCoversWholeDocument = true;
        }
        return signatureCoversWholeDocument ? "1" : "2";
    }

    @AuthorizationMethod(authEx=true)
    public List<Certificate> getSignatureCertificates() {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        List<PdfPKCS7> list = this.getSignaturePKCS7();
        for (PdfPKCS7 pk : list) {
            Certificate[] certificates = pk.getCertificates();
            certs.add(certificates[certificates.length - 1]);
        }
        return certs;
    }

    @AuthorizationMethod(authEx=true)
    public List<PdfPKCS7> getSignaturePKCS7() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ArrayList<PdfPKCS7> list = new ArrayList<PdfPKCS7>();
        AcroFields acroFields = this.pdfReader.getAcroFields();
        ArrayList<String> signatureNames = acroFields.getSignatureNames();
        if (signatureNames != null) {
            for (String name : signatureNames) {
                list.add(acroFields.verifySignature(name));
            }
        }
        return list;
    }

    @AuthorizationMethod(authEx=true)
    public void openPdfValidateSignature() {
        InputStream in = null;
        try {
            try {
                in = KGPdfHummer.class.getResourceAsStream("/com/kinggrid/pdf/resources/openPdfvalidateSignature.js");
                byte[] js = new byte[in.available()];
                in.read(js);
                this.pdfStamper.addJavaScript(new String(js));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @AuthorizationMethod(authEx=true)
    public Image generateAntiCopyImage(String text, double waterMarkWidth, double watermarkHeight, int fontChroma, int rowChroma, int columnChroma, String fontName) throws IOException, BadElementException {
        int dpi = 600;
        PrintMarkUtil printMarkUtil = new PrintMarkUtil();
        byte[] imageData = printMarkUtil.createCopyBitmapByTextEx(45, text, fontChroma, rowChroma, columnChroma, fontName, Color.WHITE, waterMarkWidth, watermarkHeight, dpi);
        Image image = Image.getInstance(imageData);
        float scale = (float)(7200 / dpi) + 0.35f;
        image.scalePercent(scale);
        return image;
    }

    @AuthorizationMethod(authEx=true)
    public Image generateAntiCopyImage(String text, double waterMarkWidth, double watermarkHeight, int fontChroma, int rowChroma, int columnChroma, String fontName, int l, int h) throws IOException, BadElementException {
        int dpi = 600;
        NewAntiCopyImage newAntiCopyImage = new NewAntiCopyImage();
        byte[] imageData = newAntiCopyImage.createCopyBitmapByTextEx(45, text, fontChroma, rowChroma, columnChroma, "\u9ed1\u4f53", Color.BLACK, waterMarkWidth, watermarkHeight, dpi, l, h);
        Image image = Image.getInstance(imageData);
        float scale = 7200 / dpi;
        image.scalePercent(scale);
        return image;
    }

    @AuthorizationMethod(authEx=true)
    public Image generateOpticImage(String text, double width, double height, int accuracy) throws IOException, BadElementException {
        return this.generateOpticImage(text, width, height, accuracy, false);
    }

    @AuthorizationMethod(authEx=true)
    public Image generateOpticImage(String text, double width, double height, int accuracy, boolean vertical) throws IOException, BadElementException {
        int dpi = 600;
        int rotate = 45;
        String firstText = "KINGGRID.COM";
        BufferedImage opticImage = null;
        NewAntiCopyImage newAntiCopyImage = new NewAntiCopyImage();
        opticImage = vertical ? newAntiCopyImage.createPrintBitmapByText(rotate, text, firstText, null, "\u9ed1\u4f53", Color.black, width, height, dpi, accuracy) : newAntiCopyImage.createPrintBitmapByText(rotate, firstText, text, null, "\u9ed1\u4f53", Color.black, width, height, dpi, accuracy);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)opticImage, "BMP", byteArrayOutputStream);
        Image image = Image.getInstance(byteArrayOutputStream.toByteArray());
        float scale = 7200 / dpi;
        image.scalePercent(scale);
        return image;
    }

    @AuthorizationMethod(authEx=true)
    public Map getMetaInfo() {
        return this.pdfReader.getInfo();
    }

    @AuthorizationMethod(authEx=true)
    public void setMetaInfo(Map map) {
        this.pdfStamper.setMoreInfo((HashMap)map);
    }

    @AuthorizationMethod(authEx=true)
    public void encryptPdf(String userPassword, String ownerPassword, int permission) throws DocumentException {
        this.pdfStamper.setEncryption(userPassword.getBytes(), ownerPassword.getBytes(), permission, 2);
    }

    @AuthorizationMethod(authEx=true)
    public void encryptPdf(Certificate certificate, int[] permission) throws DocumentException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.pdfStamper.setEncryption(new Certificate[]{certificate}, permission, 2);
    }

    public int getNumberOfPages() {
        return this.pdfReader.getNumberOfPages();
    }

    public PdfReader getPdfReader() {
        return this.pdfReader;
    }

    public void setPdfReader(PdfReader pdfReader) {
        this.pdfReader = pdfReader;
    }

    public PdfStamper getPdfStamper() {
        return this.pdfStamper;
    }

    public void setPdfStamper(PdfStamper pdfStamper) {
        this.pdfStamper = pdfStamper;
    }

    public PdfSignature getPdfSignature() {
        return this.pdfSignature;
    }

    public void setPdfSignature(PdfSignature pdfSignature) {
        this.pdfSignature = pdfSignature;
    }

    public boolean isSavePartial() {
        return this.savePartial;
    }

    @AuthorizationMethod(authEx=false)
    public void setSavePartial(boolean savePartial) {
        this.savePartial = savePartial;
    }

    public int getSavePerPage() {
        return this.savePerPage;
    }

    @AuthorizationMethod(authEx=false)
    public void setSavePerPage(int savePerPage) {
        this.savePerPage = savePerPage;
    }

    public boolean isRelaseXObjectsAndPagesInfo() {
        return this.relaseXObjectsAndPagesInfo;
    }

    @AuthorizationMethod(authEx=false)
    public void setRelaseXObjectsAndPagesInfo(boolean relaseXObjectsAndPagesInfo) {
        this.relaseXObjectsAndPagesInfo = relaseXObjectsAndPagesInfo;
    }

    public KGPdfHummerUtils getKGPdfHummerUtils() {
        if (this.kGPdfHummerUtils == null) {
            this.kGPdfHummerUtils = (KGPdfHummerUtils)KGFacadeCglib.getInstance(KGPdfHummerUtils.class, new Class[]{PdfReader.class, PdfStamper.class}, new Object[]{this.pdfReader, this.pdfStamper});
        }
        return this.kGPdfHummerUtils;
    }

    class PdfSignatureApCallbackImpl
    extends PdfSignatureApCallback {
        PdfSignatureApCallbackImpl() {
        }

        public void execute(PdfIndirectReference refSig) throws DocumentException, IOException {
            int pageSize = KGPdfHummer.this.pdfReader.getNumberOfPages();
            boolean haveSeal = false;
            int proversion = Integer.valueOf(Version.getProperty("proversion"));
            if (refSig != null && KGPdfHummer.this.pdfSignature != null) {
                KGPdfHummer.this.executes.add(KGPdfHummer.this.pdfSignature);
                KGPdfHummer.this.pdfSignature.setRefSig(refSig);
            }
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (KGExecute execute : KGPdfHummer.this.executes) {
                if (refSig != null && (execute instanceof PdfSignature4KG || execute instanceof PdfSignature)) {
                    ((PdfSignature)execute).setRefSig(refSig);
                }
                if (!KGPdfHummer.this.savePartial || !(execute instanceof PdfElectronicSeal) || proversion != 10) continue;
                if (!haveSeal) {
                    int i = 1;
                    while (i <= KGPdfHummer.this.pdfReader.getNumberOfPages()) {
                        PdfDictionary page = KGPdfHummer.this.pdfReader.getPageN(i);
                        PdfString pageID = page.getAsString(PdfName.ID);
                        if (pageID == null) {
                            String id = UUID.randomUUID().toString().replaceAll("-", "");
                            page.put(PdfName.ID, new PdfString(id));
                        }
                        ++i;
                    }
                }
                haveSeal = true;
                PdfElectronicSeal pdfElectronicSeal = (PdfElectronicSeal)execute;
                if (pdfElectronicSeal.getPosition() != KGPoistionEnum.QFZ) continue;
                map.put(pdfElectronicSeal.getStartPage(), 1);
            }
            for (KGExecute executeInterface : KGPdfHummer.this.executes) {
                executeInterface.before(KGPdfHummer.this.pdfReader, KGPdfHummer.this.pdfStamper);
            }
            if (KGPdfHummer.this.pagen == 0) {
                int i = 1;
                while (i <= pageSize && KGPdfHummer.this.executes.size() > 0) {
                    int k = 0;
                    while (k < KGPdfHummer.this.executes.size()) {
                        KGExecute executeInterface = (KGExecute)KGPdfHummer.this.executes.get(k);
                        executeInterface.doExecute(KGPdfHummer.this.pdfReader, KGPdfHummer.this.pdfStamper, i);
                        ++k;
                    }
                    if (haveSeal) {
                        PdfDictionary page = KGPdfHummer.this.pdfReader.getPageN(i);
                        if (map.get(i) == null) {
                            KGPdfHummer.this.pdfStamper.markUsed(page);
                        } else {
                            KGPdfHummer.this.pdfStamper.markUsedRemove(page);
                        }
                    }
                    if (KGPdfHummer.this.savePartial && i % KGPdfHummer.this.savePerPage == 0) {
                        if (KGPdfHummer.this.pdfStamper != null) {
                            KGPdfHummer.this.pdfStamper.prePageClose(KGPdfHummer.this.relaseXObjectsAndPagesInfo);
                        }
                        if (KGPdfHummer.this.relaseXObjectsAndPagesInfo) {
                            k = i;
                            while (k < i - KGPdfHummer.this.savePerPage) {
                                KGPdfHummer.this.pdfReader.releasePage(i);
                                --k;
                            }
                        }
                    }
                    ++i;
                }
            } else {
                for (KGExecute executeInterface : KGPdfHummer.this.executes) {
                    executeInterface.doExecute(KGPdfHummer.this.pdfReader, KGPdfHummer.this.pdfStamper, KGPdfHummer.this.pagen);
                }
                if (haveSeal) {
                    int i = 1;
                    while (i <= KGPdfHummer.this.pdfReader.getNumberOfPages()) {
                        PdfDictionary page = KGPdfHummer.this.pdfReader.getPageN(i);
                        KGPdfHummer.this.pdfStamper.markUsed(page);
                        ++i;
                    }
                }
            }
            for (KGExecute executeInterface : KGPdfHummer.this.executes) {
                executeInterface.after(KGPdfHummer.this.pdfReader, KGPdfHummer.this.pdfStamper);
            }
        }
    }
}

