/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.authorization.AuthorizationType;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class ElectronicSignatureByKey
extends KGPdfElectronicExecute {
    private String strMd5;
    private JSONArray keepData = new JSONArray();
    private String certSignMsg;
    private String certContext;

    public void execute(PdfStamper pdfStamper, PdfAnnotation annotation, int pagen, String hash) {
        if (this.strMd5 == null) {
            this.strMd5 = hash;
        }
        String id = annotation.get(new PdfName("id")).toString();
        JSONObject obj = new JSONObject();
        obj.put("page", (Object)pagen);
        obj.put("id", (Object)id);
        this.keepData.add((Object)obj);
    }

    public String getHash() {
        return this.strMd5;
    }

    public String getKeepData() {
        KGBase64 base64 = new KGBase64();
        String ret = this.keepData.toJSONString();
        try {
            ret = base64.encode(ret.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public void setKeepData(String keepDataMsg) {
        KGBase64 base64 = new KGBase64();
        String data = null;
        try {
            data = new String(base64.decode(keepDataMsg), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.keepData = JSON.parseArray(data);
    }

    public void setSig(String certSignMsg, String certContext) {
        this.certSignMsg = certSignMsg;
        this.certContext = certContext.indexOf("BEGIN CERTIFICATE") == -1 ? "-----BEGIN CERTIFICATE-----\n" + certContext + "\n-----END CERTIFICATE-----\n" : certContext;
    }

    public RewriteSig getRewriteSig() {
        return new RewriteSig();
    }

    @AuthorizationType(hasAuth=true)
    class RewriteSig
    extends KGExecute {
        private Map<Integer, String> map = new HashMap<Integer, String>();

        protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
            super.before(pdfReader, pdfStamper);
            if (ElectronicSignatureByKey.this.keepData == null) {
                return;
            }
            int i = 0;
            while (i < ElectronicSignatureByKey.this.keepData.size()) {
                JSONObject obj = ElectronicSignatureByKey.this.keepData.getJSONObject(i);
                int page = obj.getIntValue("page");
                String id = obj.getString("id");
                if (this.map.containsKey(page)) {
                    String old_id = this.map.get(page);
                    this.map.put(page, String.valueOf(old_id) + ";" + id);
                } else {
                    this.map.put(page, id);
                }
                ++i;
            }
        }

        protected void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
            String[] idArray;
            String ids = this.map.get(pagen);
            if (ids == null) {
                return;
            }
            String[] stringArray = idArray = ids.split(";");
            int n = idArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.write(pdfReader, pdfStamper, pagen, id);
                ++n2;
            }
        }

        private void write(PdfReader pdfReader, PdfStamper pdfStamper, int pagen, String id) throws DocumentException, IOException {
            PdfDictionary pagedic = pdfReader.getPageN(pagen);
            PdfArray annots = pagedic.getAsArray(PdfName.ANNOTS);
            if (annots == null) {
                return;
            }
            int idx = 0;
            while (idx < annots.size()) {
                PdfDictionary annot = annots.getAsDict(idx);
                PdfString str = annot.getAsString(new PdfName("id"));
                if (str != null && str.toString().equals(id)) {
                    if (ElectronicSignatureByKey.this.certSignMsg != null) {
                        byte[] streambyte = ElectronicSignatureByKey.this.certSignMsg.getBytes("UTF-16LE");
                        PdfStream certSignMsgStream = new PdfStream(streambyte);
                        PdfIndirectObject refObj = pdfStamper.getWriter().addToBody(certSignMsgStream);
                        annot.put(new PdfName("certSignMsg"), refObj.getIndirectReference());
                    }
                    if (ElectronicSignatureByKey.this.certContext != null) {
                        byte[] streambyte1 = ElectronicSignatureByKey.this.certContext.getBytes("UTF-16LE");
                        PdfStream certContextStream = new PdfStream(streambyte1);
                        PdfIndirectObject refObj1 = pdfStamper.getWriter().addToBody(certContextStream);
                        annot.put(new PdfName("certContext"), refObj1.getIndirectReference());
                    }
                    pdfStamper.markUsed(annot);
                }
                ++idx;
            }
        }
    }
}

