/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf;

import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.security.MakeSignature;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.KGitextpdf.text.pdf.security.TSAClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.SignatureInter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Calendar;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class DigitalSignatureByKey
implements SignatureInter {
    private static final String DEFAULT_ENCRYPTIONALGORITHM = "RSA";
    private static final String DEFAULT_HASHALGORITHM = "SHA-1";
    public static final int SIG_P1 = 0;
    public static final int SIG_P7 = 1;
    private String encryptionAlgorithm = "RSA";
    private String hashAlgorithm = "SHA-1";
    private boolean contentsReversal = true;
    private int sigType = 0;
    private Certificate[] chain;
    private byte[] extSignature;
    private String hash;
    private long contentsPostion;
    private long time;
    private String pdfHash;
    private TSAClient tsaClient;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void contentsNotResversal() {
        this.contentsReversal = false;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setSigType(int sigType) {
        this.sigType = sigType;
    }

    public int getSigType() {
        return this.sigType;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setPdfHash(byte[] hash) {
        this.pdfHash = new String(Hex.encode((byte[])hash));
    }

    public byte[] sign(byte[] message) throws GeneralSecurityException {
        this.hash = new String(Hex.encode((byte[])message));
        return null;
    }

    @Deprecated
    public void rewriteContents(String fileName, byte[] cert, long contentsPostion, String contents) throws Exception {
        this.rewriteContents(fileName, contentsPostion, contents);
    }

    @Deprecated
    public void rewriteContents(String fileName, long contentsPostion, String contents) throws Exception {
        if (this.contentsReversal) {
            contents = this.reversalContents(contents);
        }
        this.extSignature = Hex.decode((byte[])contents.getBytes());
        this.rewriteContents(fileName, contentsPostion, this.extSignature);
    }

    @Deprecated
    public void rewriteContents(String fileName, long contentsPostion, byte[] contents) throws Exception {
        this.extSignature = contents;
        this.contentsPostion = contentsPostion;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream dout = new ASN1OutputStream((OutputStream)bOut);
        dout.writeObject((ASN1Encodable)new DEROctetString(this.extSignature));
        dout.close();
        byte[] encodedSig = new String(Hex.encode((byte[])bOut.toByteArray())).getBytes();
        this.write(fileName, encodedSig);
    }

    public void rewriteContents(String fileName, byte[] contents) throws Exception {
        this.extSignature = contents;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream dout = new ASN1OutputStream((OutputStream)bOut);
        dout.writeObject((ASN1Encodable)new DEROctetString(this.extSignature));
        dout.close();
        byte[] encodedSig = new String(Hex.encode((byte[])bOut.toByteArray())).getBytes();
        this.write(fileName, encodedSig);
    }

    public void rewriteContentsPKCS7(String fileName, byte[] contents) throws Exception {
        if (contents != null) {
            this.pkcs7(contents);
        }
        PdfPKCS7 sgn = new PdfPKCS7(null, this.chain, this.hashAlgorithm, null, null, false);
        sgn.setExternalDigest(this.extSignature, null, this.encryptionAlgorithm);
        byte[] hashData = Hex.decode((String)this.pdfHash);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        byte[] sigData = sgn.getEncodedPKCS7(hashData, cal, this.tsaClient, null, null, MakeSignature.CryptoStandard.CMS);
        byte[] encodedSig = new String(Hex.encode((byte[])sigData)).getBytes();
        this.write(fileName, encodedSig);
    }

    private void write(String fileName, byte[] encodedSig) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(new File(fileName), "rw");
            raf.seek(this.contentsPostion + 1L);
            raf.write(encodedSig, 0, encodedSig.length);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    public String reversalContents(String contents) {
        char[] signedArray = contents.toCharArray();
        StringBuilder builder = new StringBuilder();
        int i = signedArray.length - 1;
        while (i >= 0) {
            builder.append(signedArray[i - 1]).append(signedArray[i]);
            i -= 2;
        }
        return builder.toString();
    }

    public String getSigKeepData() {
        JSONObject obj = new JSONObject();
        obj.put("contentsPostion", (Object)this.contentsPostion);
        obj.put("time", (Object)this.time);
        obj.put("pdfHash", (Object)this.pdfHash);
        KGBase64 base64 = new KGBase64();
        String ret = null;
        try {
            ret = base64.encode(obj.toJSONString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public void setSigKeepData(String sigKeepData) {
        KGBase64 base64 = new KGBase64();
        try {
            String str = new String(base64.decode(sigKeepData), "UTF-8");
            JSONObject obj = JSON.parseObject((String)str);
            this.contentsPostion = obj.getLongValue("contentsPostion");
            this.time = obj.getLongValue("time");
            this.pdfHash = obj.getString("pdfHash");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void pkcs7(byte[] signData) {
        PdfPKCS7 pdfPKCS7 = new PdfPKCS7(signData, new PdfName("KG"), "BC");
        this.chain = pdfPKCS7.getSignCertificateChain();
        this.extSignature = pdfPKCS7.getDigest();
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getHash() {
        return this.hash;
    }

    public void setContentsPostion(long contentsPostion) {
        this.contentsPostion = contentsPostion;
    }

    public long getContentsPostion() {
        return this.contentsPostion;
    }

    public TSAClient getTsaClient() {
        return this.tsaClient;
    }

    public void setTsaClient(TSAClient tsaClient) {
        this.tsaClient = tsaClient;
    }

    public Certificate[] getChain() {
        return this.chain;
    }

    public void setChain(Certificate[] chain) {
        this.chain = chain;
    }

    public byte[] getExtSignature() {
        return this.extSignature;
    }

    public void setExtSignature(byte[] extSignature) {
        this.extSignature = extSignature;
    }
}

